/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ScriptMetaData
implements MetaData.Custom {
    public static final String TYPE = "stored_scripts";
    public static final ScriptMetaData PROTO = new ScriptMetaData(Collections.emptyMap());
    private final Map<String, ScriptAsBytes> scripts;

    ScriptMetaData(Map<String, ScriptAsBytes> scripts) {
        this.scripts = scripts;
    }

    public BytesReference getScriptAsBytes(String language, String id) {
        ScriptAsBytes scriptAsBytes = this.scripts.get(ScriptMetaData.toKey(language, id));
        if (scriptAsBytes != null) {
            return scriptAsBytes.script;
        }
        return null;
    }

    public String getScript(String language, String id) {
        BytesReference scriptAsBytes = this.getScriptAsBytes(language, id);
        if (scriptAsBytes == null) {
            return null;
        }
        return scriptAsBytes.utf8ToString();
    }

    /*
     * Exception decompiling
     */
    public static String parseStoredScript(BytesReference scriptAsBytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 21[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public ScriptMetaData fromXContent(XContentParser parser) throws IOException {
        HashMap<String, ScriptAsBytes> scripts = new HashMap<String, ScriptAsBytes>();
        String key = null;
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    key = parser.currentName();
                    break;
                }
                case VALUE_STRING: {
                    scripts.put(key, new ScriptAsBytes(new BytesArray(parser.text())));
                    break;
                }
                default: {
                    throw new ParsingException(parser.getTokenLocation(), "Unexpected token [" + (Object)((Object)token) + "]", new Object[0]);
                }
            }
            token = parser.nextToken();
        }
        return new ScriptMetaData(scripts);
    }

    @Override
    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.ALL_CONTEXTS;
    }

    @Override
    public ScriptMetaData readFrom(StreamInput in) throws IOException {
        int size = in.readVInt();
        HashMap<String, ScriptAsBytes> scripts = new HashMap<String, ScriptAsBytes>();
        for (int i = 0; i < size; ++i) {
            String languageAndId = in.readString();
            BytesReference script = in.readBytesReference();
            scripts.put(languageAndId, new ScriptAsBytes(script));
        }
        return new ScriptMetaData(scripts);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, ScriptAsBytes> entry : this.scripts.entrySet()) {
            builder.field(entry.getKey(), entry.getValue().script.utf8ToString());
        }
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.scripts.size());
        for (Map.Entry<String, ScriptAsBytes> entry : this.scripts.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    @Override
    public Diff<MetaData.Custom> diff(MetaData.Custom before) {
        return new ScriptMetadataDiff((ScriptMetaData)before, this);
    }

    @Override
    public Diff<MetaData.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ScriptMetadataDiff(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptMetaData other = (ScriptMetaData)o;
        return this.scripts.equals(other.scripts);
    }

    public int hashCode() {
        return this.scripts.hashCode();
    }

    public String toString() {
        return "ScriptMetaData{scripts=" + this.scripts + '}';
    }

    static String toKey(String language, String id) {
        if (id.contains("#")) {
            throw new IllegalArgumentException("stored script id can't contain: '#'");
        }
        if (language.contains("#")) {
            throw new IllegalArgumentException("stored script language can't contain: '#'");
        }
        return language + "#" + id;
    }

    static final class ScriptAsBytes
    extends AbstractDiffable<ScriptAsBytes> {
        private final BytesReference script;

        public ScriptAsBytes(BytesReference script) {
            this.script = script;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesReference(this.script);
        }

        @Override
        public ScriptAsBytes readFrom(StreamInput in) throws IOException {
            return new ScriptAsBytes(in.readBytesReference());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScriptAsBytes that = (ScriptAsBytes)o;
            return this.script.equals(that.script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }

    static final class ScriptMetadataDiff
    implements Diff<MetaData.Custom> {
        final Diff<Map<String, ScriptAsBytes>> pipelines;

        ScriptMetadataDiff(ScriptMetaData before, ScriptMetaData after) {
            this.pipelines = DiffableUtils.diff(before.scripts, after.scripts, DiffableUtils.getStringKeySerializer());
        }

        public ScriptMetadataDiff(StreamInput in) throws IOException {
            this.pipelines = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), new ScriptAsBytes(null));
        }

        @Override
        public MetaData.Custom apply(MetaData.Custom part) {
            return new ScriptMetaData(this.pipelines.apply(((ScriptMetaData)part).scripts));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.pipelines.writeTo(out);
        }
    }

    public static final class Builder {
        private Map<String, ScriptAsBytes> scripts;

        public Builder(ScriptMetaData previous) {
            this.scripts = previous != null ? new HashMap<String, ScriptAsBytes>(previous.scripts) : new HashMap<String, ScriptAsBytes>();
        }

        public Builder storeScript(String lang, String id, BytesReference script) {
            BytesArray scriptBytest = new BytesArray(ScriptMetaData.parseStoredScript(script));
            this.scripts.put(ScriptMetaData.toKey(lang, id), new ScriptAsBytes(scriptBytest));
            return this;
        }

        public Builder deleteScript(String lang, String id) {
            if (this.scripts.remove(ScriptMetaData.toKey(lang, id)) == null) {
                throw new ResourceNotFoundException("Stored script with id [{}] for language [{}] does not exist", id, lang);
            }
            return this;
        }

        public ScriptMetaData build() {
            return new ScriptMetaData(Collections.unmodifiableMap(this.scripts));
        }
    }
}

