/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class DateHistogramAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.Numeric, DateHistogramAggregationBuilder> {
    public static final String NAME = InternalDateHistogram.TYPE.name();
    public static final Map<String, DateTimeUnit> DATE_FIELD_UNITS;
    private long interval;
    private DateHistogramInterval dateHistogramInterval;
    private long offset = 0L;
    private ExtendedBounds extendedBounds;
    private InternalOrder order = (InternalOrder)Histogram.Order.KEY_ASC;
    private boolean keyed = false;
    private long minDocCount = 0L;

    public DateHistogramAggregationBuilder(String name) {
        super(name, InternalDateHistogram.TYPE, ValuesSourceType.NUMERIC, ValueType.DATE);
    }

    public DateHistogramAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalDateHistogram.TYPE, ValuesSourceType.NUMERIC, ValueType.DATE);
        if (in.readBoolean()) {
            this.order = InternalOrder.Streams.readOrder(in);
        }
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.interval = in.readLong();
        this.dateHistogramInterval = in.readOptionalWriteable(DateHistogramInterval::new);
        this.offset = in.readLong();
        this.extendedBounds = in.readOptionalWriteable(ExtendedBounds::new);
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        boolean hasOrder = this.order != null;
        out.writeBoolean(hasOrder);
        if (hasOrder) {
            InternalOrder.Streams.writeOrder(this.order, out);
        }
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        out.writeLong(this.interval);
        out.writeOptionalWriteable(this.dateHistogramInterval);
        out.writeLong(this.offset);
        out.writeOptionalWriteable(this.extendedBounds);
    }

    public double interval() {
        return this.interval;
    }

    public DateHistogramAggregationBuilder interval(long interval) {
        if (interval < 1L) {
            throw new IllegalArgumentException("[interval] must be 1 or greater for histogram aggregation [" + this.name + "]");
        }
        this.interval = interval;
        return this;
    }

    public DateHistogramInterval dateHistogramInterval() {
        return this.dateHistogramInterval;
    }

    public DateHistogramAggregationBuilder dateHistogramInterval(DateHistogramInterval dateHistogramInterval) {
        if (dateHistogramInterval == null) {
            throw new IllegalArgumentException("[dateHistogramInterval] must not be null: [" + this.name + "]");
        }
        this.dateHistogramInterval = dateHistogramInterval;
        return this;
    }

    public double offset() {
        return this.offset;
    }

    public DateHistogramAggregationBuilder offset(long offset) {
        this.offset = offset;
        return this;
    }

    public DateHistogramAggregationBuilder offset(String offset) {
        if (offset == null) {
            throw new IllegalArgumentException("[offset] must not be null: [" + this.name + "]");
        }
        return this.offset(DateHistogramAggregationBuilder.parseStringOffset(offset));
    }

    static long parseStringOffset(String offset) {
        if (offset.charAt(0) == '-') {
            return -TimeValue.parseTimeValue(offset.substring(1), null, DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset").millis();
        }
        int beginIndex = offset.charAt(0) == '+' ? 1 : 0;
        return TimeValue.parseTimeValue(offset.substring(beginIndex), null, DateHistogramAggregationBuilder.class.getSimpleName() + ".parseOffset").millis();
    }

    public ExtendedBounds extendedBounds() {
        return this.extendedBounds;
    }

    public DateHistogramAggregationBuilder extendedBounds(ExtendedBounds extendedBounds) {
        if (extendedBounds == null) {
            throw new IllegalArgumentException("[extendedBounds] must not be null: [" + this.name + "]");
        }
        this.extendedBounds = extendedBounds;
        return this;
    }

    public Histogram.Order order() {
        return this.order;
    }

    public DateHistogramAggregationBuilder order(Histogram.Order order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = (InternalOrder)order;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    public DateHistogramAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public long minDocCount() {
        return this.minDocCount;
    }

    public DateHistogramAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.minDocCount = minDocCount;
        return this;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.dateHistogramInterval == null) {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.interval);
        } else {
            builder.field(Histogram.INTERVAL_FIELD.getPreferredName(), this.dateHistogramInterval.toString());
        }
        builder.field(Histogram.OFFSET_FIELD.getPreferredName(), this.offset);
        if (this.order != null) {
            builder.field(Histogram.ORDER_FIELD.getPreferredName());
            this.order.toXContent(builder, params);
        }
        builder.field(Histogram.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(Histogram.MIN_DOC_COUNT_FIELD.getPreferredName(), this.minDocCount);
        if (this.extendedBounds != null) {
            this.extendedBounds.toXContent(builder, params);
        }
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.Numeric, ?> innerBuild(AggregationContext context, ValuesSourceConfig<ValuesSource.Numeric> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Rounding rounding = this.createRounding();
        ExtendedBounds roundedBounds = null;
        if (this.extendedBounds != null) {
            roundedBounds = this.extendedBounds.parseAndValidate(this.name, context.searchContext(), config.format()).round(rounding);
        }
        return new DateHistogramAggregatorFactory(this.name, this.type, config, this.interval, this.dateHistogramInterval, this.offset, this.order, this.keyed, this.minDocCount, rounding, roundedBounds, context, parent, subFactoriesBuilder, this.metaData);
    }

    private Rounding createRounding() {
        DateTimeUnit dateTimeUnit;
        Rounding.Builder tzRoundingBuilder = this.dateHistogramInterval != null ? ((dateTimeUnit = DATE_FIELD_UNITS.get(this.dateHistogramInterval.toString())) != null ? Rounding.builder(dateTimeUnit) : Rounding.builder(TimeValue.parseTimeValue(this.dateHistogramInterval.toString(), null, this.getClass().getSimpleName() + ".interval"))) : Rounding.builder(TimeValue.timeValueMillis(this.interval));
        if (this.timeZone() != null) {
            tzRoundingBuilder.timeZone(this.timeZone());
        }
        Rounding rounding = tzRoundingBuilder.build();
        return rounding;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.order, this.keyed, this.minDocCount, this.interval, this.dateHistogramInterval, this.minDocCount, this.extendedBounds);
    }

    @Override
    protected boolean innerEquals(Object obj) {
        DateHistogramAggregationBuilder other = (DateHistogramAggregationBuilder)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.minDocCount, other.minDocCount) && Objects.equals(this.interval, other.interval) && Objects.equals(this.dateHistogramInterval, other.dateHistogramInterval) && Objects.equals(this.offset, other.offset) && Objects.equals(this.extendedBounds, other.extendedBounds);
    }

    static {
        HashMap<String, DateTimeUnit> dateFieldUnits = new HashMap<String, DateTimeUnit>();
        dateFieldUnits.put("year", DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("1y", DateTimeUnit.YEAR_OF_CENTURY);
        dateFieldUnits.put("quarter", DateTimeUnit.QUARTER);
        dateFieldUnits.put("1q", DateTimeUnit.QUARTER);
        dateFieldUnits.put("month", DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("1M", DateTimeUnit.MONTH_OF_YEAR);
        dateFieldUnits.put("week", DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("1w", DateTimeUnit.WEEK_OF_WEEKYEAR);
        dateFieldUnits.put("day", DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("1d", DateTimeUnit.DAY_OF_MONTH);
        dateFieldUnits.put("hour", DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("1h", DateTimeUnit.HOUR_OF_DAY);
        dateFieldUnits.put("minute", DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("1m", DateTimeUnit.MINUTES_OF_HOUR);
        dateFieldUnits.put("second", DateTimeUnit.SECOND_OF_MINUTE);
        dateFieldUnits.put("1s", DateTimeUnit.SECOND_OF_MINUTE);
        DATE_FIELD_UNITS = Collections.unmodifiableMap(dateFieldUnits);
    }
}

