/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.range.AbstractRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public class RangeParser
extends AbstractValuesSourceParser.NumericValuesSourceParser {
    public RangeParser() {
        this(true, true, false);
    }

    protected RangeParser(boolean scriptable, boolean formattable, boolean timezoneAware) {
        super(scriptable, formattable, timezoneAware);
    }

    @Override
    protected AbstractRangeBuilder<?, ?> createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        RangeAggregationBuilder factory = new RangeAggregationBuilder(aggregationName);
        List ranges = (List)otherOptions.get(RangeAggregator.RANGES_FIELD);
        for (RangeAggregator.Range range : ranges) {
            factory.addRange(range);
        }
        Boolean keyed = (Boolean)otherOptions.get(RangeAggregator.KEYED_FIELD);
        if (keyed != null) {
            factory.keyed(keyed);
        }
        return factory;
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (token == XContentParser.Token.START_ARRAY) {
            if (context.matchField(currentFieldName, RangeAggregator.RANGES_FIELD)) {
                ArrayList<RangeAggregator.Range> ranges = new ArrayList<RangeAggregator.Range>();
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    RangeAggregator.Range range = this.parseRange(parser, context.getParseFieldMatcher());
                    ranges.add(range);
                }
                otherOptions.put(RangeAggregator.RANGES_FIELD, ranges);
                return true;
            }
        } else if (token == XContentParser.Token.VALUE_BOOLEAN && context.matchField(currentFieldName, RangeAggregator.KEYED_FIELD)) {
            boolean keyed = parser.booleanValue();
            otherOptions.put(RangeAggregator.KEYED_FIELD, keyed);
            return true;
        }
        return false;
    }

    protected RangeAggregator.Range parseRange(XContentParser parser, ParseFieldMatcher parseFieldMatcher) throws IOException {
        return RangeAggregator.Range.fromXContent(parser, parseFieldMatcher);
    }
}

