/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph.index;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.index.SegmentIntersector;

public class SweepLineSegment {
    Edge edge;
    Coordinate[] pts;
    int ptIndex;

    public SweepLineSegment(Edge edge, int ptIndex) {
        this.edge = edge;
        this.ptIndex = ptIndex;
        this.pts = edge.getCoordinates();
    }

    public double getMinX() {
        double x1 = this.pts[this.ptIndex].x;
        double x2 = this.pts[this.ptIndex + 1].x;
        return x1 < x2 ? x1 : x2;
    }

    public double getMaxX() {
        double x1 = this.pts[this.ptIndex].x;
        double x2 = this.pts[this.ptIndex + 1].x;
        return x1 > x2 ? x1 : x2;
    }

    public void computeIntersections(SweepLineSegment ss, SegmentIntersector si) {
        si.addIntersections(this.edge, this.ptIndex, ss.edge, ss.ptIndex);
    }
}

