/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.MutablePointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;

class PointValuesWriter {
    private final FieldInfo fieldInfo;
    private final ByteBlockPool bytes;
    private final Counter iwBytesUsed;
    private int[] docIDs;
    private int numPoints;
    private int numDocs;
    private int lastDocID = -1;
    private final int packedBytesLength;

    public PointValuesWriter(DocumentsWriterPerThread docWriter, FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = docWriter.bytesUsed;
        this.bytes = new ByteBlockPool(docWriter.byteBlockAllocator);
        this.docIDs = new int[16];
        this.iwBytesUsed.addAndGet(64L);
        this.packedBytesLength = fieldInfo.getPointDimensionCount() * fieldInfo.getPointNumBytes();
    }

    public void addPackedValue(int docID, BytesRef value) {
        if (value == null) {
            throw new IllegalArgumentException("field=" + this.fieldInfo.name + ": point value must not be null");
        }
        if (value.length != this.packedBytesLength) {
            throw new IllegalArgumentException("field=" + this.fieldInfo.name + ": this field's value has length=" + value.length + " but should be " + this.fieldInfo.getPointDimensionCount() * this.fieldInfo.getPointNumBytes());
        }
        if (this.docIDs.length == this.numPoints) {
            this.docIDs = ArrayUtil.grow(this.docIDs, this.numPoints + 1);
            this.iwBytesUsed.addAndGet((this.docIDs.length - this.numPoints) * 4);
        }
        this.bytes.append(value);
        this.docIDs[this.numPoints] = docID;
        if (docID != this.lastDocID) {
            ++this.numDocs;
            this.lastDocID = docID;
        }
        ++this.numPoints;
    }

    public void flush(SegmentWriteState state, PointsWriter writer) throws IOException {
        MutablePointsReader reader = new MutablePointsReader(){
            final int[] ords;
            {
                this.ords = new int[PointValuesWriter.this.numPoints];
                for (int i = 0; i < PointValuesWriter.this.numPoints; ++i) {
                    this.ords[i] = i;
                }
            }

            @Override
            public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
                if (!fieldName.equals(((PointValuesWriter)PointValuesWriter.this).fieldInfo.name)) {
                    throw new IllegalArgumentException("fieldName must be the same");
                }
                BytesRef scratch = new BytesRef();
                byte[] packedValue = new byte[PointValuesWriter.this.packedBytesLength];
                for (int i = 0; i < PointValuesWriter.this.numPoints; ++i) {
                    this.getValue(i, scratch);
                    assert (scratch.length == packedValue.length);
                    System.arraycopy(scratch.bytes, scratch.offset, packedValue, 0, PointValuesWriter.this.packedBytesLength);
                    visitor.visit(this.getDocID(i), packedValue);
                }
            }

            @Override
            public void checkIntegrity() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public byte[] getMinPackedValue(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getMaxPackedValue(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getNumDimensions(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getBytesPerDimension(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size(String fieldName) {
                if (!fieldName.equals(((PointValuesWriter)PointValuesWriter.this).fieldInfo.name)) {
                    throw new IllegalArgumentException("fieldName must be the same");
                }
                return PointValuesWriter.this.numPoints;
            }

            @Override
            public int getDocCount(String fieldName) {
                if (!fieldName.equals(((PointValuesWriter)PointValuesWriter.this).fieldInfo.name)) {
                    throw new IllegalArgumentException("fieldName must be the same");
                }
                return PointValuesWriter.this.numDocs;
            }

            @Override
            public void swap(int i, int j) {
                int tmp = this.ords[i];
                this.ords[i] = this.ords[j];
                this.ords[j] = tmp;
            }

            @Override
            public int getDocID(int i) {
                return PointValuesWriter.this.docIDs[this.ords[i]];
            }

            @Override
            public void getValue(int i, BytesRef packedValue) {
                long offset = (long)PointValuesWriter.this.packedBytesLength * (long)this.ords[i];
                packedValue.length = PointValuesWriter.this.packedBytesLength;
                PointValuesWriter.this.bytes.setRawBytesRef(packedValue, offset);
            }

            @Override
            public byte getByteAt(int i, int k) {
                long offset = (long)PointValuesWriter.this.packedBytesLength * (long)this.ords[i] + (long)k;
                return PointValuesWriter.this.bytes.readByte(offset);
            }
        };
        writer.writeField(this.fieldInfo, reader);
    }
}

