/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.ic;

import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.ic.AnyHelper;
import com.ericsson.otp.ic.TCKind;
import com.ericsson.otp.ic.TypeCode;

public class Any {
    protected TypeCode tcV = null;
    protected String stringV;
    protected byte byteV;
    protected boolean booleanV;
    protected char charV;
    protected short shortV;
    protected int intV;
    protected long longV;
    protected float floatV;
    protected double doubleV;
    protected OtpInputStream is;
    protected OtpOutputStream os;

    public boolean equal(Any any) {
        TypeCode typeCode = any.type();
        if (!this.tcV.equal(typeCode)) {
            return false;
        }
        try {
            TCKind tCKind = typeCode.kind();
            switch (tCKind.value()) {
                case 2: {
                    return any.extract_short() == this.shortV;
                }
                case 4: {
                    return any.extract_ushort() == this.shortV;
                }
                case 3: {
                    return any.extract_long() == this.intV;
                }
                case 23: {
                    return any.extract_longlong() == this.longV;
                }
                case 5: {
                    return any.extract_ulong() == this.intV;
                }
                case 24: {
                    return any.extract_ulonglong() == this.longV;
                }
                case 6: {
                    return this.equal(any.extract_float(), this.floatV);
                }
                case 7: {
                    return this.equal(any.extract_double(), this.doubleV);
                }
                case 8: {
                    return any.extract_boolean() == this.booleanV;
                }
                case 9: {
                    return any.extract_char() == this.charV;
                }
                case 26: {
                    return any.extract_wchar() == this.charV;
                }
                case 10: {
                    return any.extract_octet() == this.byteV;
                }
                case 18: {
                    return any.extract_string().compareTo(this.stringV) == 0;
                }
                case 27: {
                    return any.extract_wstring().compareTo(this.stringV) == 0;
                }
                case 19: {
                    OtpInputStream otpInputStream = new OtpInputStream(this.os.toByteArray());
                    OtpInputStream otpInputStream2 = any.extract_Streamable();
                    if (otpInputStream.peek() != otpInputStream2.peek()) {
                        if (otpInputStream.peek() == 107) {
                            byte[] byArray = otpInputStream.read_string().getBytes();
                            int n = byArray.length;
                            otpInputStream2.read_list_head();
                            for (int i = 0; i < n; ++i) {
                                if ((long)(byArray[i] & 0xFF) == otpInputStream2.read_long()) continue;
                                return false;
                            }
                            otpInputStream2.read_nil();
                        } else {
                            byte[] byArray = otpInputStream2.read_string().getBytes();
                            int n = byArray.length;
                            otpInputStream.read_list_head();
                            for (int i = 0; i < n; ++i) {
                                if ((long)(byArray[i] & 0xFF) == otpInputStream.read_long()) continue;
                                return false;
                            }
                            otpInputStream.read_nil();
                        }
                    } else {
                        int n = otpInputStream2.available();
                        if (otpInputStream.available() != n) {
                            return false;
                        }
                        for (int i = 0; i < n; ++i) {
                            if (otpInputStream.read() == otpInputStream2.read()) continue;
                            return false;
                        }
                    }
                    return true;
                }
                case 15: 
                case 16: 
                case 17: 
                case 20: {
                    OtpInputStream otpInputStream = new OtpInputStream(this.os.toByteArray());
                    OtpInputStream otpInputStream3 = any.extract_Streamable();
                    int n = otpInputStream3.available();
                    if (otpInputStream.available() != n) {
                        return false;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (otpInputStream.read() == otpInputStream3.read()) continue;
                        return false;
                    }
                    return true;
                }
                case 0: 
                case 1: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 21: 
                case 22: 
                case 25: 
                case 28: 
                case 20000: {
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean equal(float f, float f2) {
        if (f != 0.0f) {
            return (double)Math.abs((f - f2) / f) < 1.0E-15;
        }
        if (f2 != 0.0f) {
            return (double)Math.abs((f2 - f) / f2) < 1.0E-15;
        }
        return f == f2;
    }

    boolean equal(double d, double d2) {
        if (d != 0.0) {
            return Math.abs((d - d2) / d) < 1.0E-15;
        }
        if (d2 != 0.0) {
            return Math.abs((d2 - d) / d2) < 1.0E-15;
        }
        return d == d2;
    }

    public TypeCode type() {
        return this.tcV;
    }

    public void type(TypeCode typeCode) {
        this.tcV = typeCode;
    }

    public void read_value(OtpInputStream otpInputStream, TypeCode typeCode) throws Exception {
        this.tcV = typeCode;
        switch (this.tcV.kind().value()) {
            case 2: {
                this.shortV = otpInputStream.read_short();
                break;
            }
            case 4: {
                this.shortV = otpInputStream.read_ushort();
                break;
            }
            case 3: {
                this.intV = otpInputStream.read_int();
                break;
            }
            case 5: {
                this.intV = otpInputStream.read_uint();
                break;
            }
            case 23: {
                this.longV = otpInputStream.read_long();
                break;
            }
            case 24: {
                this.longV = otpInputStream.read_ulong();
                break;
            }
            case 6: {
                this.floatV = otpInputStream.read_float();
                break;
            }
            case 7: {
                this.doubleV = otpInputStream.read_double();
                break;
            }
            case 8: {
                this.booleanV = otpInputStream.read_boolean();
                break;
            }
            case 9: 
            case 26: {
                this.charV = otpInputStream.read_char();
                break;
            }
            case 10: {
                this.byteV = otpInputStream.read_byte();
                break;
            }
            case 18: 
            case 27: {
                this.stringV = otpInputStream.read_string();
                break;
            }
            case 20000: {
                this.stringV = otpInputStream.read_atom();
                break;
            }
            case 1: {
                otpInputStream.read_atom();
                break;
            }
            case 0: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 25: 
            case 28: {
                throw new Exception("Unsupported type");
            }
            default: {
                if (this.os == null) {
                    this.os = new OtpOutputStream();
                } else {
                    this.os.reset();
                }
                try {
                    this.read_user_defined(otpInputStream, typeCode);
                    this.is = new OtpInputStream(this.os.toByteArray());
                    break;
                }
                catch (Exception exception) {
                    throw new Exception("BAD VALUE");
                }
            }
        }
    }

    void read_user_defined(OtpInputStream otpInputStream, TypeCode typeCode) throws Exception {
        Object var3_3 = null;
        int n = -1;
        block0 : switch (typeCode.kind().value()) {
            case 2: {
                this.os.write_short(otpInputStream.read_short());
                break;
            }
            case 4: {
                this.os.write_ushort(otpInputStream.read_ushort());
                break;
            }
            case 3: {
                this.os.write_int(otpInputStream.read_int());
                break;
            }
            case 23: {
                this.os.write_long(otpInputStream.read_long());
                break;
            }
            case 5: {
                this.os.write_uint(otpInputStream.read_uint());
                break;
            }
            case 24: {
                this.os.write_ulong(otpInputStream.read_ulong());
                break;
            }
            case 6: {
                this.os.write_float(otpInputStream.read_float());
                break;
            }
            case 7: {
                this.os.write_double(otpInputStream.read_double());
                break;
            }
            case 8: {
                this.os.write_boolean(otpInputStream.read_boolean());
                break;
            }
            case 9: 
            case 26: {
                this.os.write_char(otpInputStream.read_char());
                break;
            }
            case 10: {
                this.os.write_byte(otpInputStream.read_byte());
                break;
            }
            case 18: 
            case 27: {
                this.os.write_string(otpInputStream.read_string());
                break;
            }
            case 15: {
                n = otpInputStream.read_tuple_head();
                this.os.write_tuple_head(n);
                this.os.write_atom(otpInputStream.read_atom());
                --n;
                for (int i = 0; i < n; ++i) {
                    this.read_user_defined(otpInputStream, typeCode.member_type(i));
                }
                break;
            }
            case 16: {
                this.os.write_tuple_head(otpInputStream.read_tuple_head());
                this.os.write_atom(otpInputStream.read_atom());
                int n2 = typeCode.member_count();
                int n3 = otpInputStream.peek();
                boolean bl = false;
                switch (n3) {
                    case 100: 
                    case 118: 
                    case 119: {
                        String string = otpInputStream.read_atom();
                        this.os.write_atom(string);
                        for (int i = 0; i < n2; ++i) {
                            String string2 = typeCode.member_label(i).type().kind().value() == 18 ? typeCode.member_label(i).extract_string() : typeCode.member_label(i).extract_atom();
                            if (string.compareTo(string2) != 0) continue;
                            this.read_user_defined(otpInputStream, typeCode.member_type(i));
                            i = n2;
                            bl = true;
                        }
                        break;
                    }
                    default: {
                        long l = otpInputStream.read_long();
                        this.os.write_long(l);
                        for (int i = 0; i < n2; ++i) {
                            boolean bl2 = true;
                            long l2 = 0L;
                            switch (typeCode.member_label(i).type().kind().value()) {
                                case 2: {
                                    l2 = typeCode.member_label(i).extract_short();
                                    break;
                                }
                                case 4: {
                                    l2 = typeCode.member_label(i).extract_ushort();
                                    break;
                                }
                                case 3: {
                                    l2 = typeCode.member_label(i).extract_long();
                                    break;
                                }
                                case 23: {
                                    l2 = typeCode.member_label(i).extract_longlong();
                                    break;
                                }
                                case 5: {
                                    l2 = typeCode.member_label(i).extract_ulong();
                                    break;
                                }
                                case 24: {
                                    l2 = typeCode.member_label(i).extract_ulonglong();
                                    break;
                                }
                                case 9: {
                                    l2 = typeCode.member_label(i).extract_char();
                                    break;
                                }
                                case 26: {
                                    l2 = typeCode.member_label(i).extract_wchar();
                                    break;
                                }
                                default: {
                                    bl2 = false;
                                }
                            }
                            if (!bl2 || l != l2) continue;
                            this.read_user_defined(otpInputStream, typeCode.member_type(i));
                            i = n2;
                            bl = true;
                        }
                    }
                }
                if (bl) break;
                this.read_user_defined(otpInputStream, typeCode.member_type(typeCode.default_index()));
                break;
            }
            case 19: {
                int n4 = otpInputStream.peek();
                switch (n4) {
                    case 107: {
                        this.os.write_string(otpInputStream.read_string());
                        break block0;
                    }
                }
                n = otpInputStream.read_list_head();
                this.os.write_list_head(n);
                for (int i = 0; i < n; ++i) {
                    this.read_user_defined(otpInputStream, typeCode.content_type());
                }
                otpInputStream.read_nil();
                this.os.write_nil();
                break;
            }
            case 20: {
                n = otpInputStream.read_tuple_head();
                this.os.write_tuple_head(n);
                for (int i = 0; i < n; ++i) {
                    this.read_user_defined(otpInputStream, typeCode.content_type());
                }
                break;
            }
            case 17: {
                this.os.write_atom(otpInputStream.read_atom());
                break;
            }
            case 1: {
                this.os.write_atom(otpInputStream.read_atom());
                break;
            }
            case 11: {
                AnyHelper.marshal(this.os, AnyHelper.unmarshal(otpInputStream));
                break;
            }
            default: {
                throw new Exception("");
            }
        }
    }

    public void write_value(OtpOutputStream otpOutputStream) throws Exception {
        switch (this.tcV.kind().value()) {
            case 2: {
                otpOutputStream.write_short(this.shortV);
                break;
            }
            case 4: {
                otpOutputStream.write_ushort(this.shortV);
                break;
            }
            case 3: {
                otpOutputStream.write_int(this.intV);
                break;
            }
            case 5: {
                otpOutputStream.write_uint(this.intV);
                break;
            }
            case 23: {
                otpOutputStream.write_long(this.longV);
                break;
            }
            case 24: {
                otpOutputStream.write_ulong(this.longV);
                break;
            }
            case 6: {
                otpOutputStream.write_float(this.floatV);
                break;
            }
            case 7: {
                otpOutputStream.write_double(this.doubleV);
                break;
            }
            case 8: {
                otpOutputStream.write_boolean(this.booleanV);
                break;
            }
            case 9: 
            case 26: {
                otpOutputStream.write_char(this.charV);
                break;
            }
            case 10: {
                otpOutputStream.write_byte(this.byteV);
                break;
            }
            case 18: 
            case 27: {
                otpOutputStream.write_string(this.stringV);
                break;
            }
            case 20000: {
                otpOutputStream.write_atom(this.stringV);
                break;
            }
            case 1: {
                otpOutputStream.write_atom("ok");
                break;
            }
            case 0: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 25: 
            case 28: {
                throw new Exception("BAD KIND");
            }
            default: {
                otpOutputStream.write(this.os.toByteArray());
            }
        }
    }

    public short extract_short() throws Exception {
        if (this.tcV.kind() == TCKind.tk_short) {
            return this.shortV;
        }
        throw new Exception("");
    }

    public void insert_short(short s) {
        this.shortV = s;
        this.tcV = new TypeCode(TCKind.tk_short);
    }

    public int extract_long() throws Exception {
        if (this.tcV.kind() == TCKind.tk_long) {
            return this.intV;
        }
        throw new Exception("");
    }

    public void insert_long(int n) {
        this.intV = n;
        this.tcV = new TypeCode(TCKind.tk_long);
    }

    public long extract_longlong() throws Exception {
        if (this.tcV.kind() == TCKind.tk_longlong) {
            return this.longV;
        }
        throw new Exception("");
    }

    public void insert_longlong(long l) {
        this.longV = l;
        this.tcV = new TypeCode(TCKind.tk_longlong);
    }

    public short extract_ushort() throws Exception {
        if (this.tcV.kind() == TCKind.tk_ushort) {
            return this.shortV;
        }
        throw new Exception("");
    }

    public void insert_ushort(short s) {
        this.shortV = s;
        this.tcV = new TypeCode(TCKind.tk_ushort);
    }

    public int extract_ulong() throws Exception {
        if (this.tcV.kind() == TCKind.tk_ulong) {
            return this.intV;
        }
        throw new Exception("");
    }

    public void insert_ulong(int n) {
        this.intV = n;
        this.tcV = new TypeCode(TCKind.tk_ulong);
    }

    public long extract_ulonglong() throws Exception {
        if (this.tcV.kind() == TCKind.tk_ulonglong) {
            return this.longV;
        }
        throw new Exception("");
    }

    public void insert_ulonglong(long l) {
        this.longV = l;
        this.tcV = new TypeCode(TCKind.tk_ulonglong);
    }

    public float extract_float() throws Exception {
        if (this.tcV.kind() == TCKind.tk_float) {
            return this.floatV;
        }
        throw new Exception("");
    }

    public void insert_float(float f) {
        this.floatV = f;
        this.tcV = new TypeCode(TCKind.tk_float);
    }

    public double extract_double() throws Exception {
        if (this.tcV.kind() == TCKind.tk_double) {
            return this.doubleV;
        }
        throw new Exception("");
    }

    public void insert_double(double d) {
        this.doubleV = d;
        this.tcV = new TypeCode(TCKind.tk_double);
    }

    public boolean extract_boolean() throws Exception {
        if (this.tcV.kind() == TCKind.tk_boolean) {
            return this.booleanV;
        }
        throw new Exception("");
    }

    public void insert_boolean(boolean bl) {
        this.booleanV = bl;
        this.tcV = new TypeCode(TCKind.tk_boolean);
    }

    public char extract_char() throws Exception {
        if (this.tcV.kind() == TCKind.tk_char) {
            return this.charV;
        }
        throw new Exception("");
    }

    public void insert_char(char c) {
        this.charV = c;
        this.tcV = new TypeCode(TCKind.tk_char);
    }

    public char extract_wchar() throws Exception {
        if (this.tcV.kind() == TCKind.tk_wchar) {
            return this.charV;
        }
        throw new Exception("");
    }

    public void insert_wchar(char c) {
        this.charV = c;
        this.tcV = new TypeCode(TCKind.tk_wchar);
    }

    public byte extract_octet() throws Exception {
        if (this.tcV.kind() == TCKind.tk_octet) {
            return this.byteV;
        }
        throw new Exception("");
    }

    public void insert_octet(byte by) {
        this.byteV = by;
        this.tcV = new TypeCode(TCKind.tk_octet);
    }

    public String extract_string() throws Exception {
        if (this.tcV.kind() == TCKind.tk_string) {
            return this.stringV;
        }
        throw new Exception("");
    }

    public void insert_string(String string) {
        this.stringV = string;
        this.tcV = new TypeCode(TCKind.tk_string);
    }

    public String extract_wstring() throws Exception {
        if (this.tcV.kind() == TCKind.tk_wstring) {
            return this.stringV;
        }
        throw new Exception("");
    }

    public void insert_wstring(String string) {
        this.stringV = string;
        this.tcV = new TypeCode(TCKind.tk_wstring);
    }

    public String extract_atom() throws Exception {
        if (this.tcV.kind() == TCKind.tk_atom) {
            return this.stringV;
        }
        throw new Exception("");
    }

    public void insert_atom(String string) {
        this.stringV = string;
        this.tcV = new TypeCode(TCKind.tk_atom);
    }

    public void insert_Streamable(OtpOutputStream otpOutputStream) {
        this.os = otpOutputStream;
    }

    public OtpInputStream extract_Streamable() {
        if (this.is == null) {
            if (this.os == null) {
                return null;
            }
            this.is = new OtpInputStream(this.os.toByteArray());
        }
        this.is.reset();
        return this.is;
    }
}

