/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common.geometry;

import de.tuberlin.polymake.common.geometry.GeometryIf;
import de.tuberlin.polymake.common.geometry.PointSet;

public class EmbeddedGeometry {
    protected GeometryIf geometry;
    protected int[] vertexList;
    protected boolean dynamic = false;

    public EmbeddedGeometry(int[] nArray, GeometryIf geometryIf, boolean bl) {
        if (nArray != null) {
            this.vertexList = new int[nArray.length];
            System.arraycopy(nArray, 0, this.vertexList, 0, nArray.length);
        }
        this.geometry = geometryIf.copy();
        this.dynamic = bl;
    }

    public EmbeddedGeometry(int[] nArray) {
        System.arraycopy(nArray, 0, this.vertexList, 0, nArray.length);
    }

    public void update(PointSet pointSet, boolean bl) {
        for (int i = 0; i < this.vertexList.length; ++i) {
            double[] dArray = pointSet.getPoint(this.vertexList[i]).getCoords();
            this.geometry.setPointCoords(i, dArray);
        }
        this.geometry.update();
    }

    public void setGeometry(GeometryIf geometryIf) {
        this.geometry = geometryIf.copy();
    }

    public GeometryIf getGeometry() {
        return this.geometry;
    }

    public Object clone() {
        return new EmbeddedGeometry(this.vertexList, this.geometry, this.dynamic);
    }

    public String getName() {
        return this.geometry.getName();
    }

    public String toString() {
        String string = new String();
        string = string + "geometry=" + this.geometry.toString() + "\n";
        string = string + "vertexList=";
        if (this.vertexList != null) {
            for (int i = 0; i < this.vertexList.length; ++i) {
                string = string + this.vertexList[i] + " ";
            }
        } else {
            string = string + "null";
        }
        string = string + "\ndynamic = " + this.dynamic + "\n";
        return string;
    }

    public int[] getVertexList() {
        int[] nArray = new int[this.vertexList.length];
        System.arraycopy(this.vertexList, 0, nArray, 0, nArray.length);
        return nArray;
    }

    public int getVertexIndex(int n) {
        return this.vertexList[n];
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

