/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.uml;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.ElementId;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.NewGridElement;
import com.baselet.element.draw.DrawHelper;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.facet.Settings;
import com.baselet.element.facet.common.SeparatorLineFacet;
import com.baselet.element.facet.common.TextBeforeFirstSeparatorCollectorFacet;
import com.baselet.element.settings.SettingsManualresizeCenter;
import com.baselet.element.sticking.polygon.PointDoubleStickingPolygonGenerator;
import java.util.Arrays;
import java.util.List;

public class Package
extends NewGridElement {
    @Override
    protected Settings createSettings() {
        return new SettingsManualresizeCenter(){

            @Override
            protected List<Facet> createFacets() {
                return 1.listOf(super.createFacets(), TextBeforeFirstSeparatorCollectorFacet.INSTANCE, SeparatorLineFacet.INSTANCE);
            }
        };
    }

    @Override
    public ElementId getId() {
        return ElementId.UMLPackage;
    }

    @Override
    protected void drawCommonContent(PropertiesParserState state) {
        DrawHandler drawer = state.getDrawer();
        List<String> packageTitle = Package.getTitleLines(state);
        double packageHeight = 0.0;
        double packageWidth = (double)this.getRealSize().getWidth() / 2.5;
        double txtHeight = drawer.textHeightMaxWithSpace();
        for (String line : packageTitle) {
            packageWidth = Math.max(packageWidth, drawer.textWidth(line) + drawer.getDistanceBorderToText() * 2.0);
            drawer.setLayer(DrawHandler.Layer.Foreground);
            drawer.print(line, new PointDouble(drawer.getDistanceBorderToText(), packageHeight += txtHeight), AlignHorizontal.LEFT);
            drawer.setLayer(DrawHandler.Layer.Background);
        }
        int height = this.getRealSize().getHeight();
        int width = this.getRealSize().getWidth();
        List<PointDouble> points = DrawHelper.drawPackage(drawer, 0.0, 0.0, packageHeight += drawer.getDistanceBorderToText(), packageWidth, height, width);
        state.getBuffer().setTopMin(packageHeight);
        state.setStickingPolygonGenerator(new PointDoubleStickingPolygonGenerator(points));
    }

    private static List<String> getTitleLines(PropertiesParserState state) {
        TextBeforeFirstSeparatorCollectorFacet.TextBeforeFirstSeparatorCollectorFacetResponse packageTitleResponse = state.getFacetResponse(TextBeforeFirstSeparatorCollectorFacet.class, null);
        List<String> packageTitle = packageTitleResponse != null ? packageTitleResponse.getLines() : Arrays.asList("");
        return packageTitle;
    }
}

