/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.array.ArrayReflector;

public abstract class ArrayOperations {
    public static int normalizeIndex(int length, int index, ConditionProfile negativeIndexProfile) {
        if (negativeIndexProfile.profile(index < 0)) {
            return length + index;
        }
        return index;
    }

    public static int normalizeIndex(int length, int index) {
        if (CompilerDirectives.injectBranchProbability(1.0E-4, index < 0)) {
            return length + index;
        }
        return index;
    }

    public static int clampExclusiveIndex(int length, int index) {
        if (CompilerDirectives.injectBranchProbability(0.25, index < 0)) {
            return 0;
        }
        if (CompilerDirectives.injectBranchProbability(0.25, index > length)) {
            return length;
        }
        return index;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object[] toObjectArray(DynamicObject array) {
        return ArrayReflector.reflect(Layouts.ARRAY.getStore(array)).getBoxedCopy(Layouts.ARRAY.getSize(array));
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterable<Object> toIterable(DynamicObject array) {
        return ArrayReflector.reflect(Layouts.ARRAY.getStore(array)).iterableUntil(Layouts.ARRAY.getSize(array));
    }
}

