/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayEnsureCapacityNode;
import org.jruby.truffle.core.array.ArrayGeneralizeNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ArrayWriteNormalizedNode.class)
@SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
public final class ArrayWriteNormalizedNodeGen
extends ArrayWriteNormalizedNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> indexType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArrayWriteNormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeWrite(DynamicObject arrayValue, int indexValue, Object valueValue) {
        return this.specialization_.execute1(arrayValue, indexValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static ArrayWriteNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        return new ArrayWriteNormalizedNodeGen(context, sourceSection, array, index, value);
    }

    @GeneratedBy(methodName="writeBeyondObject(DynamicObject, int, Object, ArrayEnsureCapacityNode)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondObjectNode_
    extends BaseNode_ {
        @Node.Child
        private ArrayEnsureCapacityNode ensureCapacityNode;
        private final Class<?> indexImplicitType;

        WriteBeyondObjectNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayEnsureCapacityNode ensureCapacityNode) {
            super(root, 7);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.ensureCapacityNode = ensureCapacityNode;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteBeyondObjectNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeBeyondObject(arrayValue_, indexValue_, valueValue_, this.ensureCapacityNode);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isObjectArray(arrayValue) && !ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                return this.root.writeBeyondObject(arrayValue, indexValue, valueValue, this.ensureCapacityNode);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    return this.root.writeBeyondObject(arrayValue_, indexValue_, valueValue, this.ensureCapacityNode);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayEnsureCapacityNode ensureCapacityNode) {
            return new WriteBeyondObjectNode_(root, indexValue, ensureCapacityNode);
        }
    }

    @GeneratedBy(methodName="writeBeyondPrimitive(DynamicObject, int, Object, ArrayGeneralizeNode)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteBeyondPrimitiveNode_
    extends BaseNode_ {
        @Node.Child
        private ArrayGeneralizeNode generalizeNode;
        private final Class<?> indexImplicitType;

        WriteBeyondPrimitiveNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayGeneralizeNode generalizeNode) {
            super(root, 6);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.generalizeNode = generalizeNode;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteBeyondPrimitiveNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (!(ArrayGuards.isObjectArray(arrayValue_) || ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_))) {
                return this.root.writeBeyondPrimitive(arrayValue_, indexValue_, valueValue_, this.generalizeNode);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (!(ArrayGuards.isObjectArray(arrayValue) || ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue))) {
                return this.root.writeBeyondPrimitive(arrayValue, indexValue, valueValue, this.generalizeNode);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (!(ArrayGuards.isObjectArray(arrayValue_) || ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_))) {
                    return this.root.writeBeyondPrimitive(arrayValue_, indexValue_, valueValue, this.generalizeNode);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayGeneralizeNode generalizeNode) {
            return new WriteBeyondPrimitiveNode_(root, indexValue, generalizeNode);
        }
    }

    @GeneratedBy(methodName="writeExtendByOne(DynamicObject, int, Object, ArrayAppendOneNode)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteExtendByOneNode_
    extends BaseNode_ {
        @Node.Child
        private ArrayAppendOneNode appendNode;
        private final Class<?> indexImplicitType;

        WriteExtendByOneNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayAppendOneNode appendNode) {
            super(root, 5);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.appendNode = appendNode;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteExtendByOneNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue_, this.appendNode);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayWriteNormalizedNode.isExtendingByOne(arrayValue, indexValue)) {
                return this.root.writeExtendByOne(arrayValue, indexValue, valueValue, this.appendNode);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType))) {
                return this.root.writeExtendByOne(arrayValue_, indexValue_, valueValue, this.appendNode);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayAppendOneNode appendNode) {
            return new WriteExtendByOneNode_(root, indexValue, appendNode);
        }
    }

    @GeneratedBy(methodName="writeWithinGeneralize(DynamicObject, int, Object, ArrayStrategy, ArrayStrategy)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinGeneralizeNode_
    extends BaseNode_ {
        private final ArrayStrategy currentStrategy;
        private final ArrayStrategy generalizedStrategy;
        private final Class<?> indexImplicitType;

        WriteWithinGeneralizeNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy currentStrategy, ArrayStrategy generalizedStrategy) {
            super(root, 4);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.currentStrategy = currentStrategy;
            this.generalizedStrategy = generalizedStrategy;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinGeneralizeNode_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.currentStrategy.matches(arrayValue_) && !this.currentStrategy.accepts(arrayValue_) && this.generalizedStrategy.accepts(valueValue);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && this.currentStrategy.matches(arrayValue_) && !this.currentStrategy.accepts(arrayValue_) && this.generalizedStrategy.accepts(valueValue_)) {
                return this.root.writeWithinGeneralize(arrayValue_, indexValue_, valueValue_, this.currentStrategy, this.generalizedStrategy);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && this.currentStrategy.matches(arrayValue) && !this.currentStrategy.accepts(arrayValue) && this.generalizedStrategy.accepts(valueValue)) {
                return this.root.writeWithinGeneralize(arrayValue, indexValue, valueValue, this.currentStrategy, this.generalizedStrategy);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.currentStrategy.matches(arrayValue_) && !this.currentStrategy.accepts(arrayValue_) && this.generalizedStrategy.accepts(valueValue)) {
                return this.root.writeWithinGeneralize(arrayValue_, indexValue_, valueValue, this.currentStrategy, this.generalizedStrategy);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy currentStrategy, ArrayStrategy generalizedStrategy) {
            return new WriteWithinGeneralizeNode_(root, indexValue, currentStrategy, generalizedStrategy);
        }
    }

    @GeneratedBy(methodName="writeWithin(DynamicObject, int, Object, ArrayStrategy)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteWithinNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final Class<?> indexImplicitType;

        WriteWithinNode_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            super(root, 3);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.strategy = strategy;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteWithinNode_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.strategy.matches(arrayValue_) && this.strategy.accepts(valueValue);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && this.strategy.matches(arrayValue_) && this.strategy.accepts(valueValue_)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue_, this.strategy);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayWriteNormalizedNode.isInBounds(arrayValue, indexValue) && this.strategy.matches(arrayValue) && this.strategy.accepts(valueValue)) {
                return this.root.writeWithin(arrayValue, indexValue, valueValue, this.strategy);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && ArrayWriteNormalizedNode.isInBounds(arrayValue_ = (DynamicObject)arrayValue, indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType)) && this.strategy.matches(arrayValue_) && this.strategy.accepts(valueValue)) {
                return this.root.writeWithin(arrayValue_, indexValue_, valueValue, this.strategy);
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            return new WriteWithinNode_(root, indexValue, strategy);
        }
    }

    @GeneratedBy(methodName="writeNullBeyond(DynamicObject, int, Object)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNullBeyondNode_
    extends BaseNode_ {
        private final Class<?> indexImplicitType;

        WriteNullBeyondNode_(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            super(root, 2);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNullBeyondNode_)other).indexImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                return this.root.writeNullBeyond(arrayValue_, indexValue_, valueValue_);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isNullArray(arrayValue) && indexValue != 0) {
                return this.root.writeNullBeyond(arrayValue, indexValue, valueValue);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                    return this.root.writeNullBeyond(arrayValue_, indexValue_, valueValue);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue) {
            return new WriteNullBeyondNode_(root, indexValue);
        }
    }

    @GeneratedBy(methodName="writeNull0(DynamicObject, int, Object, ArrayStrategy)", value=ArrayWriteNormalizedNode.class)
    private static final class WriteNull0Node_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final Class<?> indexImplicitType;

        WriteNull0Node_(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            super(root, 1);
            this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
            this.strategy = strategy;
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.indexImplicitType == ((WriteNull0Node_)other).indexImplicitType;
        }

        @Override
        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0 && this.strategy.specializesFor(valueValue)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            int indexValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue = this.executeIndex_(frameValue);
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(ex.getResult(), indexValue, valueValue);
            }
            try {
                if (this.indexImplicitType == Integer.TYPE) {
                    indexValue_ = this.root.index_.executeInteger(frameValue);
                } else {
                    Object indexValue__ = this.executeIndex_(frameValue);
                    indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.root.value_.execute(frameValue);
                return this.getNext().execute_(arrayValue_, ex.getResult(), valueValue);
            }
            Object valueValue_ = this.root.value_.execute(frameValue);
            if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0 && this.strategy.specializesFor(valueValue_)) {
                return this.root.writeNull0(arrayValue_, indexValue_, valueValue_, this.strategy);
            }
            return this.getNext().execute_(arrayValue_, indexValue_, valueValue_);
        }

        @Override
        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            if (ArrayGuards.isNullArray(arrayValue) && indexValue == 0 && this.strategy.specializesFor(valueValue)) {
                return this.root.writeNull0(arrayValue, indexValue, valueValue, this.strategy);
            }
            return this.getNext().execute1(arrayValue, indexValue, valueValue);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType)) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0 && this.strategy.specializesFor(valueValue)) {
                    return this.root.writeNull0(arrayValue_, indexValue_, valueValue, this.strategy);
                }
            }
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root, Object indexValue, ArrayStrategy strategy) {
            return new WriteNull0Node_(root, indexValue, strategy);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, indexValue, valueValue));
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            return this.getNext().execute_(arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArrayWriteNormalizedNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(Object arrayValue, Object indexValue, Object valueValue) {
            return this.uninitialized((Frame)null, arrayValue, indexValue, valueValue);
        }

        static BaseNode_ create(ArrayWriteNormalizedNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArrayWriteNormalizedNodeGen root;

        BaseNode_(ArrayWriteNormalizedNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ArrayWriteNormalizedNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.index_, this.root.value_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.execute_(arrayValue, indexValue, valueValue);
        }

        public abstract Object execute_(Object var1, Object var2, Object var3);

        public Object execute1(DynamicObject arrayValue, int indexValue, Object valueValue) {
            return this.execute_(arrayValue, indexValue, valueValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object indexValue_ = this.executeIndex_(frameValue);
            Object valueValue_ = this.root.value_.execute(frameValue);
            return this.execute_(arrayValue_, indexValue_, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (arrayValue instanceof DynamicObject && RubyTypesGen.isImplicitInteger(indexValue)) {
                BaseNode_ s;
                BaseNode_ s2;
                BaseNode_ s3;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue);
                ArrayStrategy strategy1 = ArrayStrategy.forValue(valueValue);
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ == 0 && strategy1.specializesFor(valueValue) && this.countSame(s3 = WriteNull0Node_.create(this.root, indexValue, strategy1)) < 25) {
                    return s3;
                }
                if (ArrayGuards.isNullArray(arrayValue_) && indexValue_ != 0) {
                    return WriteNullBeyondNode_.create(this.root, indexValue);
                }
                ArrayStrategy strategy3 = ArrayStrategy.of(arrayValue_, valueValue);
                if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && strategy3.matches(arrayValue_) && strategy3.accepts(valueValue) && this.countSame(s2 = WriteWithinNode_.create(this.root, indexValue, strategy3)) < 25) {
                    return s2;
                }
                ArrayStrategy currentStrategy4 = ArrayStrategy.of(arrayValue_);
                ArrayStrategy generalizedStrategy4 = currentStrategy4.generalizeFor(valueValue);
                if (ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && currentStrategy4.matches(arrayValue_) && !currentStrategy4.accepts(arrayValue_) && generalizedStrategy4.accepts(valueValue) && this.countSame(s = WriteWithinGeneralizeNode_.create(this.root, indexValue, currentStrategy4, generalizedStrategy4)) < 25) {
                    return s;
                }
                if (ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    ArrayAppendOneNode appendNode5 = this.root.createArrayAppendOneNode();
                    return WriteExtendByOneNode_.create(this.root, indexValue, appendNode5);
                }
                if (!(ArrayGuards.isObjectArray(arrayValue_) || ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_))) {
                    ArrayGeneralizeNode generalizeNode6 = ArrayGeneralizeNode.create(this.root.getContext());
                    return WriteBeyondPrimitiveNode_.create(this.root, indexValue, generalizeNode6);
                }
                if (ArrayGuards.isObjectArray(arrayValue_) && !ArrayWriteNormalizedNode.isInBounds(arrayValue_, indexValue_) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValue_, indexValue_)) {
                    ArrayEnsureCapacityNode ensureCapacityNode7 = ArrayEnsureCapacityNode.create(this.root.getContext());
                    return WriteBeyondObjectNode_.create(this.root, indexValue, ensureCapacityNode7);
                }
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeIndex_(Frame frameValue) {
            Object object;
            Class indexType_ = this.root.indexType_;
            if (indexType_ == Integer.TYPE) {
                return this.root.index_.executeInteger((VirtualFrame)frameValue);
            }
            if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.indexType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.indexType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.indexType_ = _type;
            return object;
        }
    }
}

