/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.ext.DelegatableDecoder;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208;

public class ISO2022_JP
extends Charset
implements HistoricallyNamedCharset {
    private static final int ASCII = 0;
    private static final int JISX0201_1976 = 1;
    private static final int JISX0208_1978 = 2;
    private static final int JISX0208_1983 = 3;
    private static final int JISX0212_1990 = 4;
    private static final int JISX0201_1976_KANA = 5;
    private static final int SHIFTOUT = 6;
    private static final int ESC = 27;
    private static final int SO = 14;
    private static final int SI = 15;

    public ISO2022_JP() {
        super("ISO-2022-JP", ExtendedCharsets.aliasesFor("ISO-2022-JP"));
    }

    protected ISO2022_JP(String string, String[] stringArray) {
        super(string, stringArray);
    }

    @Override
    public String historicalName() {
        return "ISO2022JP";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof JIS_X_0201 || charset instanceof US_ASCII || charset instanceof JIS_X_0208 || charset instanceof ISO2022_JP;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    protected boolean doSBKANA() {
        return true;
    }

    static class Encoder
    extends CharsetEncoder {
        static final DoubleByte.Encoder ENC0208 = (DoubleByte.Encoder)new JIS_X_0208().newEncoder();
        private static byte[] repl = new byte[]{33, 41};
        private int currentMode = 0;
        private int replaceMode = 3;
        private DoubleByte.Encoder enc0208;
        private DoubleByte.Encoder enc0212;
        private boolean doSBKANA;
        private final Surrogate.Parser sgp = new Surrogate.Parser();

        private Encoder(Charset charset) {
            this(charset, ENC0208, null, true);
        }

        Encoder(Charset charset, DoubleByte.Encoder encoder, DoubleByte.Encoder encoder2, boolean bl) {
            super(charset, 4.0f, encoder2 != null ? 9.0f : 8.0f, repl);
            this.enc0208 = encoder;
            this.enc0212 = encoder2;
            this.doSBKANA = bl;
        }

        protected int encodeSingle(char c) {
            return -1;
        }

        @Override
        protected void implReset() {
            this.currentMode = 0;
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            if (byArray.length == 1) {
                this.replaceMode = 0;
            } else if (byArray.length == 2) {
                this.replaceMode = 3;
            }
        }

        @Override
        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            if (this.currentMode != 0) {
                if (byteBuffer.remaining() < 3) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put((byte)27);
                byteBuffer.put((byte)40);
                byteBuffer.put((byte)66);
                this.currentMode = 0;
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        public boolean canEncode(char c) {
            return c <= '\u007f' || c >= '\uff61' && c <= '\uff9f' || c == '\u00a5' || c == '\u203e' || this.enc0208.canEncode(c) || this.enc0212 != null && this.enc0212.canEncode(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    char c = cArray[n];
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (n4 - n3 < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 66;
                            this.currentMode = 0;
                        }
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)c;
                        continue;
                    }
                    if (c >= '\uff61' && c <= '\uff9f' && this.doSBKANA) {
                        if (this.currentMode != 5) {
                            if (n4 - n3 < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 73;
                            this.currentMode = 5;
                        }
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(c - 65344);
                        continue;
                    }
                    if (c == '\u00a5' || c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (n4 - n3 < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 74;
                            this.currentMode = 1;
                        }
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = c == '\u00a5' ? 92 : 126;
                        continue;
                    }
                    int n5 = this.enc0208.encodeChar(c);
                    if (n5 != 65533) {
                        if (this.currentMode != 3) {
                            if (n4 - n3 < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 36;
                            byArray[n3++] = 66;
                            this.currentMode = 3;
                        }
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)(n5 & 0xFF);
                        continue;
                    }
                    if (this.enc0212 != null && (n5 = this.enc0212.encodeChar(c)) != 65533) {
                        if (this.currentMode != 4) {
                            if (n4 - n3 < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byArray[n3++] = 27;
                            byArray[n3++] = 36;
                            byArray[n3++] = 40;
                            byArray[n3++] = 68;
                            this.currentMode = 4;
                        }
                        if (n4 - n3 < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3++] = (byte)(n5 >> 8);
                        byArray[n3++] = (byte)(n5 & 0xFF);
                        continue;
                    }
                    if (Character.isSurrogate(c) && this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    if (this.unmappableCharacterAction() == CodingErrorAction.REPLACE && this.currentMode != this.replaceMode) {
                        if (n4 - n3 < 3) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        if (this.replaceMode == 0) {
                            byArray[n3++] = 27;
                            byArray[n3++] = 40;
                            byArray[n3++] = 66;
                        } else {
                            byArray[n3++] = 27;
                            byArray[n3++] = 36;
                            byArray[n3++] = 66;
                        }
                        this.currentMode = this.replaceMode;
                    }
                    if (Character.isSurrogate(c)) {
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    if (c <= '\u007f') {
                        if (this.currentMode != 0) {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)66);
                            this.currentMode = 0;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                    } else if (c >= '\uff61' && c <= '\uff9f' && this.doSBKANA) {
                        if (this.currentMode != 5) {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)73);
                            this.currentMode = 5;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)(c - 65344));
                    } else if (c == '\u00a5' || c == '\u203e') {
                        if (this.currentMode != 1) {
                            if (byteBuffer.remaining() < 3) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)27);
                            byteBuffer.put((byte)40);
                            byteBuffer.put((byte)74);
                            this.currentMode = 1;
                        }
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put(c == '\u00a5' ? (byte)92 : 126);
                    } else {
                        int n2 = this.enc0208.encodeChar(c);
                        if (n2 != 65533) {
                            if (this.currentMode != 3) {
                                if (byteBuffer.remaining() < 3) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byteBuffer.put((byte)27);
                                byteBuffer.put((byte)36);
                                byteBuffer.put((byte)66);
                                this.currentMode = 3;
                            }
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(n2 >> 8));
                            byteBuffer.put((byte)(n2 & 0xFF));
                        } else if (this.enc0212 != null && (n2 = this.enc0212.encodeChar(c)) != 65533) {
                            if (this.currentMode != 4) {
                                if (byteBuffer.remaining() < 4) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                byteBuffer.put((byte)27);
                                byteBuffer.put((byte)36);
                                byteBuffer.put((byte)40);
                                byteBuffer.put((byte)68);
                                this.currentMode = 4;
                            }
                            if (byteBuffer.remaining() < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            byteBuffer.put((byte)(n2 >> 8));
                            byteBuffer.put((byte)(n2 & 0xFF));
                        } else {
                            if (Character.isSurrogate(c) && this.sgp.parse(c, charBuffer) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            if (this.unmappableCharacterAction() == CodingErrorAction.REPLACE && this.currentMode != this.replaceMode) {
                                if (byteBuffer.remaining() < 3) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                if (this.replaceMode == 0) {
                                    byteBuffer.put((byte)27);
                                    byteBuffer.put((byte)40);
                                    byteBuffer.put((byte)66);
                                } else {
                                    byteBuffer.put((byte)27);
                                    byteBuffer.put((byte)36);
                                    byteBuffer.put((byte)66);
                                }
                                this.currentMode = this.replaceMode;
                            }
                            if (Character.isSurrogate(c)) {
                                CoderResult coderResult = this.sgp.unmappableResult();
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }
    }

    static class Decoder
    extends CharsetDecoder
    implements DelegatableDecoder {
        static final DoubleByte.Decoder DEC0208 = (DoubleByte.Decoder)new JIS_X_0208().newDecoder();
        private int currentState;
        private int previousState;
        private DoubleByte.Decoder dec0208;
        private DoubleByte.Decoder dec0212;

        private Decoder(Charset charset) {
            this(charset, DEC0208, null);
        }

        protected Decoder(Charset charset, DoubleByte.Decoder decoder, DoubleByte.Decoder decoder2) {
            super(charset, 0.5f, 1.0f);
            this.dec0208 = decoder;
            this.dec0212 = decoder2;
            this.currentState = 0;
            this.previousState = 0;
        }

        @Override
        public void implReset() {
            this.currentState = 0;
            this.previousState = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 65533;
            byte[] byArray = byteBuffer.array();
            int n7 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n8 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n7 <= n8);
            n7 = n7 <= n8 ? n7 : n8;
            char[] cArray = charBuffer.array();
            int n9 = charBuffer.arrayOffset() + charBuffer.position();
            int n10 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n9 <= n10);
            n9 = n9 <= n10 ? n9 : n10;
            try {
                while (n7 < n8) {
                    block54: {
                        block53: {
                            block55: {
                                block57: {
                                    block56: {
                                        n2 = byArray[n7] & 0xFF;
                                        n = 1;
                                        if ((n2 & 0x80) != 0) {
                                            CoderResult coderResult = CoderResult.malformedForLength(n);
                                            return coderResult;
                                        }
                                        if (n2 != 27 && n2 != 14 && n2 != 15) break block54;
                                        if (n2 != 27) break block55;
                                        if (n7 + n + 2 > n8) {
                                            CoderResult coderResult = CoderResult.UNDERFLOW;
                                            return coderResult;
                                        }
                                        if ((n3 = byArray[n7 + n++] & 0xFF) != 40) break block56;
                                        if ((n4 = byArray[n7 + n++] & 0xFF) == 66) {
                                            this.currentState = 0;
                                            break block53;
                                        } else if (n4 == 74) {
                                            this.currentState = 1;
                                            break block53;
                                        } else {
                                            if (n4 != 73) {
                                                CoderResult coderResult = CoderResult.malformedForLength(n);
                                                return coderResult;
                                            }
                                            this.currentState = 5;
                                        }
                                        break block53;
                                    }
                                    if (n3 != 36) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n);
                                        return coderResult;
                                    }
                                    if ((n4 = byArray[n7 + n++] & 0xFF) != 64) break block57;
                                    this.currentState = 2;
                                    break block53;
                                }
                                if (n4 == 66) {
                                    this.currentState = 3;
                                    break block53;
                                } else if (n4 == 40 && this.dec0212 != null) {
                                    if (n7 + n + 1 > n8) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    if ((n5 = byArray[n7 + n++] & 0xFF) != 68) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n);
                                        return coderResult;
                                    }
                                    this.currentState = 4;
                                    break block53;
                                } else {
                                    CoderResult coderResult = CoderResult.malformedForLength(n);
                                    return coderResult;
                                }
                            }
                            if (n2 == 14) {
                                this.previousState = this.currentState;
                                this.currentState = 6;
                            } else if (n2 == 15) {
                                this.currentState = this.previousState;
                            }
                        }
                        n7 += n;
                        continue;
                    }
                    if (n9 + 1 > n10) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    block14 : switch (this.currentState) {
                        case 0: {
                            cArray[n9++] = (char)(n2 & 0xFF);
                            break;
                        }
                        case 1: {
                            switch (n2) {
                                case 92: {
                                    cArray[n9++] = 165;
                                    break block14;
                                }
                                case 126: {
                                    cArray[n9++] = 8254;
                                    break block14;
                                }
                            }
                            cArray[n9++] = (char)n2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (n7 + n + 1 > n8) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if ((n6 = (int)this.dec0208.decodeDouble(n2, n3 = byArray[n7 + n++] & 0xFF)) == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(n);
                                return coderResult;
                            }
                            cArray[n9++] = n6;
                            break;
                        }
                        case 4: {
                            if (n7 + n + 1 > n8) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            if ((n6 = (int)this.dec0212.decodeDouble(n2, n3 = byArray[n7 + n++] & 0xFF)) == 65533) {
                                CoderResult coderResult = CoderResult.unmappableForLength(n);
                                return coderResult;
                            }
                            cArray[n9++] = n6;
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (n2 > 96) {
                                CoderResult coderResult = CoderResult.malformedForLength(n);
                                return coderResult;
                            }
                            cArray[n9++] = (char)(n2 + 65344);
                            break;
                        }
                    }
                    n7 += n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n7 - byteBuffer.arrayOffset());
                charBuffer.position(n9 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            char c = '\ufffd';
            int n6 = 0;
            try {
                while (byteBuffer.hasRemaining()) {
                    block52: {
                        block51: {
                            block53: {
                                block55: {
                                    block54: {
                                        n2 = byteBuffer.get() & 0xFF;
                                        n6 = 1;
                                        if ((n2 & 0x80) != 0) {
                                            CoderResult coderResult = CoderResult.malformedForLength(n6);
                                            return coderResult;
                                        }
                                        if (n2 != 27 && n2 != 14 && n2 != 15) break block52;
                                        if (n2 != 27) break block53;
                                        if (byteBuffer.remaining() < 2) {
                                            CoderResult coderResult = CoderResult.UNDERFLOW;
                                            return coderResult;
                                        }
                                        n3 = byteBuffer.get() & 0xFF;
                                        ++n6;
                                        if (n3 != 40) break block54;
                                        n4 = byteBuffer.get() & 0xFF;
                                        ++n6;
                                        if (n4 == 66) {
                                            this.currentState = 0;
                                            break block51;
                                        } else if (n4 == 74) {
                                            this.currentState = 1;
                                            break block51;
                                        } else {
                                            if (n4 != 73) {
                                                CoderResult coderResult = CoderResult.malformedForLength(n6);
                                                return coderResult;
                                            }
                                            this.currentState = 5;
                                        }
                                        break block51;
                                    }
                                    if (n3 != 36) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n6);
                                        return coderResult;
                                    }
                                    n4 = byteBuffer.get() & 0xFF;
                                    ++n6;
                                    if (n4 != 64) break block55;
                                    this.currentState = 2;
                                    break block51;
                                }
                                if (n4 == 66) {
                                    this.currentState = 3;
                                    break block51;
                                } else if (n4 == 40 && this.dec0212 != null) {
                                    if (!byteBuffer.hasRemaining()) {
                                        CoderResult coderResult = CoderResult.UNDERFLOW;
                                        return coderResult;
                                    }
                                    n5 = byteBuffer.get() & 0xFF;
                                    ++n6;
                                    if (n5 != 68) {
                                        CoderResult coderResult = CoderResult.malformedForLength(n6);
                                        return coderResult;
                                    }
                                    this.currentState = 4;
                                    break block51;
                                } else {
                                    CoderResult coderResult = CoderResult.malformedForLength(n6);
                                    return coderResult;
                                }
                            }
                            if (n2 == 14) {
                                this.previousState = this.currentState;
                                this.currentState = 6;
                            } else if (n2 == 15) {
                                this.currentState = this.previousState;
                            }
                        }
                        n += n6;
                        continue;
                    }
                    if (!charBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    block14 : switch (this.currentState) {
                        case 0: {
                            charBuffer.put((char)(n2 & 0xFF));
                            break;
                        }
                        case 1: {
                            switch (n2) {
                                case 92: {
                                    charBuffer.put('\u00a5');
                                    break block14;
                                }
                                case 126: {
                                    charBuffer.put('\u203e');
                                    break block14;
                                }
                            }
                            charBuffer.put((char)n2);
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (!byteBuffer.hasRemaining()) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n3 = byteBuffer.get() & 0xFF;
                            ++n6;
                            c = this.dec0208.decodeDouble(n2, n3);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(n6);
                                return coderResult;
                            }
                            charBuffer.put(c);
                            break;
                        }
                        case 4: {
                            if (!byteBuffer.hasRemaining()) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            n3 = byteBuffer.get() & 0xFF;
                            ++n6;
                            c = this.dec0212.decodeDouble(n2, n3);
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(n6);
                                return coderResult;
                            }
                            charBuffer.put(c);
                            break;
                        }
                        case 5: 
                        case 6: {
                            if (n2 > 96) {
                                CoderResult coderResult = CoderResult.malformedForLength(n6);
                                return coderResult;
                            }
                            charBuffer.put((char)(n2 + 65344));
                            break;
                        }
                    }
                    n += n6;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        public CoderResult implFlush(CharBuffer charBuffer) {
            return super.implFlush(charBuffer);
        }
    }
}

