/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class ChangesetDataSet {
    private final Map<PrimitiveId, HistoryOsmPrimitive> primitives = new HashMap<PrimitiveId, HistoryOsmPrimitive>();
    private final Map<PrimitiveId, ChangesetModificationType> modificationTypes = new HashMap<PrimitiveId, ChangesetModificationType>();

    public void put(HistoryOsmPrimitive historyOsmPrimitive, ChangesetModificationType changesetModificationType) {
        CheckParameterUtil.ensureParameterNotNull(historyOsmPrimitive, "primitive");
        CheckParameterUtil.ensureParameterNotNull((Object)changesetModificationType, "cmt");
        this.primitives.put(historyOsmPrimitive.getPrimitiveId(), historyOsmPrimitive);
        this.modificationTypes.put(historyOsmPrimitive.getPrimitiveId(), changesetModificationType);
    }

    public boolean contains(PrimitiveId primitiveId) {
        if (primitiveId == null) {
            return false;
        }
        return this.primitives.containsKey(primitiveId);
    }

    public ChangesetModificationType getModificationType(PrimitiveId primitiveId) {
        if (!this.contains(primitiveId)) {
            return null;
        }
        return this.modificationTypes.get(primitiveId);
    }

    public boolean isCreated(PrimitiveId primitiveId) {
        if (!this.contains(primitiveId)) {
            return false;
        }
        return ChangesetModificationType.CREATED.equals((Object)this.getModificationType(primitiveId));
    }

    public boolean isUpdated(PrimitiveId primitiveId) {
        if (!this.contains(primitiveId)) {
            return false;
        }
        return ChangesetModificationType.UPDATED.equals((Object)this.getModificationType(primitiveId));
    }

    public boolean isDeleted(PrimitiveId primitiveId) {
        if (!this.contains(primitiveId)) {
            return false;
        }
        return ChangesetModificationType.DELETED.equals((Object)this.getModificationType(primitiveId));
    }

    public Set<HistoryOsmPrimitive> getPrimitivesByModificationType(ChangesetModificationType changesetModificationType) {
        CheckParameterUtil.ensureParameterNotNull((Object)changesetModificationType, "cmt");
        return this.modificationTypes.entrySet().stream().filter(entry -> ((ChangesetModificationType)((Object)((Object)entry.getValue()))).equals((Object)changesetModificationType)).map(entry -> this.primitives.get(entry.getKey())).collect(Collectors.toSet());
    }

    public int size() {
        return this.primitives.size();
    }

    public HistoryOsmPrimitive getPrimitive(PrimitiveId primitiveId) {
        if (primitiveId == null) {
            return null;
        }
        return this.primitives.get(primitiveId);
    }

    public Iterator<ChangesetDataSetEntry> iterator() {
        return new DefaultIterator();
    }

    private class DefaultIterator
    implements Iterator<ChangesetDataSetEntry> {
        private final Iterator<Map.Entry<PrimitiveId, ChangesetModificationType>> typeIterator;

        DefaultIterator() {
            this.typeIterator = ChangesetDataSet.this.modificationTypes.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.typeIterator.hasNext();
        }

        @Override
        public ChangesetDataSetEntry next() {
            Map.Entry<PrimitiveId, ChangesetModificationType> entry = this.typeIterator.next();
            ChangesetModificationType changesetModificationType = entry.getValue();
            HistoryOsmPrimitive historyOsmPrimitive = (HistoryOsmPrimitive)ChangesetDataSet.this.primitives.get(entry.getKey());
            return new DefaultChangesetDataSetEntry(changesetModificationType, historyOsmPrimitive);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DefaultChangesetDataSetEntry
    implements ChangesetDataSetEntry {
        private final ChangesetModificationType modificationType;
        private final HistoryOsmPrimitive primitive;

        DefaultChangesetDataSetEntry(ChangesetModificationType changesetModificationType, HistoryOsmPrimitive historyOsmPrimitive) {
            this.modificationType = changesetModificationType;
            this.primitive = historyOsmPrimitive;
        }

        @Override
        public ChangesetModificationType getModificationType() {
            return this.modificationType;
        }

        @Override
        public HistoryOsmPrimitive getPrimitive() {
            return this.primitive;
        }
    }

    public static interface ChangesetDataSetEntry {
        public ChangesetModificationType getModificationType();

        public HistoryOsmPrimitive getPrimitive();
    }

    public static enum ChangesetModificationType {
        CREATED,
        UPDATED,
        DELETED;

    }
}

