/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;

public class OpeningHourTest
extends Test.TagTest {
    public static final ScriptEngine ENGINE = new ScriptEngineManager().getEngineByName("JavaScript");

    public OpeningHourTest() {
        super(I18n.tr("Opening hours syntax", new Object[0]), I18n.tr("This test checks the correct usage of the opening hours syntax.", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        block25: {
            super.initialize();
            if (ENGINE != null) {
                try (CachedFile cachedFile = new CachedFile("resource://data/validator/opening_hours.js");
                     BufferedReader bufferedReader = cachedFile.getContentReader();){
                    ENGINE.eval(bufferedReader);
                    ENGINE.eval("var opening_hours = require('opening_hours');");
                    ENGINE.eval("var nominatimJSON = {address: {state: 'Bayern', country_code: 'de'}};");
                    ENGINE.eval("var oh = function (value, mode, locale) { try {    var r = new opening_hours(value, nominatimJSON, {mode: mode, locale: locale});    r.getErrors = function() {return [];};    return r;  } catch (err) {    return {      prettifyValue: function() {return null;},      getWarnings: function() {return [];},      getErrors: function() {return [err.toString()]}    };  }};");
                    break block25;
                }
            }
            Main.warn("Unable to initialize OpeningHourTest because no JavaScript engine has been found");
        }
    }

    protected Object parse(String string, CheckMode checkMode, String string2) throws ScriptException, NoSuchMethodException {
        return ((Invocable)((Object)ENGINE)).invokeFunction("oh", string, checkMode.code, string2);
    }

    protected List<Object> getList(Object object) throws ScriptException, NoSuchMethodException {
        if (object == null || "".equals(object)) {
            return Arrays.asList(new Object[0]);
        }
        if (object instanceof String) {
            String[] stringArray = ((String)object).split("\\\\n");
            return Arrays.asList(stringArray);
        }
        if (object instanceof List) {
            return (List)object;
        }
        return this.getList(((Invocable)((Object)ENGINE)).invokeMethod(object, "join", "\\n"));
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String string, String string2, CheckMode checkMode) {
        return this.checkOpeningHourSyntax(string, string2, checkMode, false, LanguageInfo.getJOSMLocaleCode());
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String string, String string2, CheckMode checkMode, boolean bl, String string3) {
        if (ENGINE == null || string2 == null || string2.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<OpeningHoursTestError> arrayList = new ArrayList<OpeningHoursTestError>();
        try {
            Object object = this.parse(string2, checkMode, string3);
            String string4 = null;
            try {
                string4 = (String)((Invocable)((Object)ENGINE)).invokeMethod(object, "prettifyValue", new Object[0]);
            }
            catch (NoSuchMethodException | ScriptException exception) {
                Main.warn(exception);
            }
            for (Object object2 : this.getList(((Invocable)((Object)ENGINE)).invokeMethod(object, "getErrors", new Object[0]))) {
                arrayList.add(new OpeningHoursTestError(OpeningHourTest.getErrorMessage(string, object2), Severity.ERROR, string4));
            }
            for (Object object2 : this.getList(((Invocable)((Object)ENGINE)).invokeMethod(object, "getWarnings", new Object[0]))) {
                arrayList.add(new OpeningHoursTestError(OpeningHourTest.getErrorMessage(string, object2), Severity.WARNING, string4));
            }
            if (!bl && arrayList.isEmpty() && string4 != null && !string2.equals(string4)) {
                arrayList.add(new OpeningHoursTestError(I18n.tr("opening_hours value can be prettified", new Object[0]), Severity.OTHER, string4));
            }
        }
        catch (NoSuchMethodException | ScriptException exception) {
            Main.error(exception);
        }
        return arrayList;
    }

    private static String getErrorMessage(String string, Object object) {
        String string2 = object.toString().trim().replace("Unexpected token:", I18n.tr("Unexpected token:", new Object[0])).replace("Unexpected token (school holiday parser):", I18n.tr("Unexpected token (school holiday parser):", new Object[0])).replace("Unexpected token in number range:", I18n.tr("Unexpected token in number range:", new Object[0])).replace("Unexpected token in week range:", I18n.tr("Unexpected token in week range:", new Object[0])).replace("Unexpected token in weekday range:", I18n.tr("Unexpected token in weekday range:", new Object[0])).replace("Unexpected token in month range:", I18n.tr("Unexpected token in month range:", new Object[0])).replace("Unexpected token in year range:", I18n.tr("Unexpected token in year range:", new Object[0])).replace("This means that the syntax is not valid at that point or it is currently not supported.", I18n.tr("Invalid/unsupported syntax.", new Object[0]));
        return string + " - " + string2;
    }

    public List<OpeningHoursTestError> checkOpeningHourSyntax(String string, String string2) {
        return this.checkOpeningHourSyntax(string, string2, "opening_hours".equals(string) ? CheckMode.TIME_RANGE : CheckMode.BOTH);
    }

    protected void check(OsmPrimitive osmPrimitive, String string, CheckMode checkMode) {
        for (OpeningHoursTestError openingHoursTestError : this.checkOpeningHourSyntax(string, osmPrimitive.get(string), checkMode)) {
            this.errors.add(openingHoursTestError.getTestError(osmPrimitive, string));
        }
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        this.check(osmPrimitive, "opening_hours", CheckMode.TIME_RANGE);
        this.check(osmPrimitive, "collection_times", CheckMode.BOTH);
        this.check(osmPrimitive, "service_times", CheckMode.BOTH);
    }

    public class OpeningHoursTestError {
        private final Severity severity;
        private final String message;
        private final String prettifiedValue;

        public OpeningHoursTestError(String string, Severity severity, String string2) {
            this.message = string;
            this.severity = severity;
            this.prettifiedValue = string2;
        }

        public TestError getTestError(OsmPrimitive osmPrimitive, String string) {
            TestError.Builder builder = TestError.builder(OpeningHourTest.this, this.severity, 2901).message(I18n.tr("Opening hours syntax", new Object[0]), this.message, new Object[0]).primitives(osmPrimitive);
            if (this.prettifiedValue == null || this.prettifiedValue.equals(osmPrimitive.get(string))) {
                return builder.build();
            }
            return builder.fix(() -> new ChangePropertyCommand(osmPrimitive, string, this.prettifiedValue)).build();
        }

        public String getMessage() {
            return this.message;
        }

        public String getPrettifiedValue() {
            return this.prettifiedValue;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.getMessage() + " => " + this.getPrettifiedValue();
        }
    }

    static enum CheckMode {
        TIME_RANGE(0),
        POINTS_IN_TIME(1),
        BOTH(2);

        private final int code;

        private CheckMode(int n2) {
            this.code = n2;
        }
    }
}

