/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.preferences.SourceType;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.tools.I18n;

public class ValidatorTagCheckerRulesPreference
implements SubPreferenceSetting {
    private static final List<SourceProvider> ruleSourceProviders = new ArrayList<SourceProvider>();
    private SourceEditor sources;

    public static final boolean registerSourceProvider(SourceProvider sourceProvider) {
        if (sourceProvider != null) {
            return ruleSourceProviders.add(sourceProvider);
        }
        return false;
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        ValidatorPreference validatorPreference = preferenceTabbedPane.getValidatorPreference();
        this.sources = new TagCheckerRulesSourceEditor();
        validatorPreference.addSubTab(this, I18n.tr("Tag checker rules", new Object[0]), this.sources, I18n.tr("Choose Tag checker rules to enable", new Object[0]));
        this.sources.deferLoading(validatorPreference, this.sources);
    }

    @Override
    public boolean ok() {
        MapCSSTagChecker mapCSSTagChecker;
        if (this.sources.finish() && (mapCSSTagChecker = OsmValidator.getTest(MapCSSTagChecker.class)) != null) {
            OsmValidator.initializeTests(Collections.singleton(mapCSSTagChecker));
        }
        return false;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getValidatorPreference();
    }

    public static class RulePrefHelper
    extends SourceEditor.SourcePrefHelper {
        public static final RulePrefHelper INSTANCE = new RulePrefHelper();

        public RulePrefHelper() {
            super(MapCSSTagChecker.ENTRIES_PREF_KEY);
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            ArrayList<SourceEditor.ExtendedSourceEntry> arrayList = new ArrayList<SourceEditor.ExtendedSourceEntry>();
            RulePrefHelper.addDefault(arrayList, "addresses", I18n.tr("Addresses", new Object[0]), I18n.tr("Checks for errors on addresses", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "combinations", I18n.tr("Tag combinations", new Object[0]), I18n.tr("Checks for missing tag or suspicious combinations", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "deprecated", I18n.tr("Deprecated features", new Object[0]), I18n.tr("Checks for deprecated features", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "geometry", I18n.tr("Geometry", new Object[0]), I18n.tr("Checks for geometry errors", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "highway", I18n.tr("Highways", new Object[0]), I18n.tr("Checks for errors on highways", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "multiple", I18n.tr("Multiple values", new Object[0]), I18n.tr("Checks for wrong multiple values", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "numeric", I18n.tr("Numeric values", new Object[0]), I18n.tr("Checks for wrong numeric values", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "religion", I18n.tr("Religion", new Object[0]), I18n.tr("Checks for errors on religious objects", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "relation", I18n.tr("Relations", new Object[0]), I18n.tr("Checks for errors on relations", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "territories", I18n.tr("Territories", new Object[0]), I18n.tr("Checks for territories-specific features", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "unnecessary", I18n.tr("Unnecessary tags", new Object[0]), I18n.tr("Checks for unnecessary tags", new Object[0]));
            RulePrefHelper.addDefault(arrayList, "wikipedia", I18n.tr("Wikipedia", new Object[0]), I18n.tr("Checks for wrong wikipedia tags", new Object[0]));
            return arrayList;
        }

        private static void addDefault(List<SourceEditor.ExtendedSourceEntry> list, String string, String string2, String string3) {
            SourceEditor.ExtendedSourceEntry extendedSourceEntry = new SourceEditor.ExtendedSourceEntry(string + ".mapcss", "resource://data/validator/" + string + ".mapcss");
            extendedSourceEntry.title = string2;
            extendedSourceEntry.description = string3;
            list.add(extendedSourceEntry);
        }

        @Override
        public Map<String, String> serialize(SourceEntry sourceEntry) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("url", sourceEntry.url);
            hashMap.put("title", sourceEntry.title == null ? "" : sourceEntry.title);
            hashMap.put("active", Boolean.toString(sourceEntry.active));
            return hashMap;
        }

        @Override
        public SourceEntry deserialize(Map<String, String> map) {
            return new SourceEntry(map.get("url"), null, map.get("title"), Boolean.parseBoolean(map.get("active")));
        }
    }

    static class TagCheckerRulesSourceEditor
    extends SourceEditor {
        TagCheckerRulesSourceEditor() {
            super(SourceType.TAGCHECKER_RULE, Main.getJOSMWebsite() + "/rules", ruleSourceProviders, false);
        }

        @Override
        public Collection<? extends SourceEntry> getInitialSourcesList() {
            return RulePrefHelper.INSTANCE.get();
        }

        @Override
        public boolean finish() {
            return RulePrefHelper.INSTANCE.put(this.activeSourcesModel.getSources());
        }

        @Override
        public Collection<SourceEditor.ExtendedSourceEntry> getDefault() {
            return RulePrefHelper.INSTANCE.getDefault();
        }

        @Override
        public Collection<String> getInitialIconPathsList() {
            return null;
        }

        @Override
        public String getStr(SourceEditor.I18nString i18nString) {
            switch (i18nString) {
                case AVAILABLE_SOURCES: {
                    return I18n.tr("Available rules:", new Object[0]);
                }
                case ACTIVE_SOURCES: {
                    return I18n.tr("Active rules:", new Object[0]);
                }
                case NEW_SOURCE_ENTRY_TOOLTIP: {
                    return I18n.tr("Add a new rule by entering filename or URL", new Object[0]);
                }
                case NEW_SOURCE_ENTRY: {
                    return I18n.tr("New rule entry:", new Object[0]);
                }
                case REMOVE_SOURCE_TOOLTIP: {
                    return I18n.tr("Remove the selected rules from the list of active rules", new Object[0]);
                }
                case EDIT_SOURCE_TOOLTIP: {
                    return I18n.tr("Edit the filename or URL for the selected active rule", new Object[0]);
                }
                case ACTIVATE_TOOLTIP: {
                    return I18n.tr("Add the selected available rules to the list of active rules", new Object[0]);
                }
                case RELOAD_ALL_AVAILABLE: {
                    return I18n.marktr("Reloads the list of available rules from ''{0}''");
                }
                case LOADING_SOURCES_FROM: {
                    return I18n.marktr("Loading rule sources from ''{0}''");
                }
                case FAILED_TO_LOAD_SOURCES_FROM: {
                    return I18n.marktr("<html>Failed to load the list of rule sources from<br>''{0}''.<br><br>Details (untranslated):<br>{1}</html>");
                }
                case FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC: {
                    return "/Preferences/Rules#FailedToLoadRuleSources";
                }
                case ILLEGAL_FORMAT_OF_ENTRY: {
                    return I18n.marktr("Warning: illegal format of entry in rule list ''{0}''. Got ''{1}''");
                }
            }
            throw new AssertionError();
        }

        @Override
        protected String getTitleForSourceEntry(SourceEntry sourceEntry) {
            String string = MapPaintPreference.getTitleFromSourceEntry(sourceEntry);
            return string != null ? string : super.getTitleForSourceEntry(sourceEntry);
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        @Override
        public PreferenceSetting createPreferenceSetting() {
            return new ValidatorTagCheckerRulesPreference();
        }
    }
}

