/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmChangesetContentParser;
import org.openstreetmap.josm.io.OsmChangesetParser;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;

public class OsmServerChangesetReader
extends OsmServerReader {
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    protected final InputStream getChangesetInputStream(long l, boolean bl, ProgressMonitor progressMonitor) throws OsmTransferException {
        StringBuilder stringBuilder = new StringBuilder(48).append("changeset/").append(l);
        if (bl) {
            stringBuilder.append("?include_discussion=true");
        }
        return this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Changeset> queryChangesets(ChangesetQuery changesetQuery, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changesetQuery, "query");
        List<Changeset> list = null;
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Reading changesets...", new Object[0]));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("changesets?").append(changesetQuery.getQueryString());
            try {
                Throwable throwable;
                InputStream inputStream;
                block26: {
                    List<Changeset> list2;
                    block27: {
                        inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                        throwable = null;
                        if (inputStream != null) break block26;
                        list2 = Collections.emptyList();
                        if (inputStream == null) return list2;
                        if (throwable == null) break block27;
                        try {
                            inputStream.close();
                            return list2;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return list2;
                        }
                    }
                    inputStream.close();
                    return list2;
                }
                try {
                    progressMonitor.indeterminateSubTask(I18n.tr("Downloading changesets ...", new Object[0]));
                    list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
                    return list;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
                return list;
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Changeset readChangeset(long l, boolean bl, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (l <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", l));
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        Changeset changeset = null;
        try {
            Throwable throwable;
            InputStream inputStream;
            progressMonitor.beginTask(I18n.tr("Reading changeset {0} ...", l));
            try {
                List<Changeset> list;
                block33: {
                    Changeset changeset2;
                    block34: {
                        block31: {
                            Changeset changeset3;
                            block32: {
                                inputStream = this.getChangesetInputStream(l, bl, progressMonitor);
                                throwable = null;
                                if (inputStream != null) break block31;
                                changeset3 = null;
                                if (inputStream == null) return changeset3;
                                if (throwable == null) break block32;
                                try {
                                    inputStream.close();
                                    return changeset3;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return changeset3;
                                }
                            }
                            inputStream.close();
                            return changeset3;
                        }
                        progressMonitor.indeterminateSubTask(I18n.tr("Downloading changeset {0} ...", l));
                        list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
                        if (list != null && !list.isEmpty()) break block33;
                        changeset2 = null;
                        if (inputStream == null) return changeset2;
                        if (throwable == null) break block34;
                        try {
                            inputStream.close();
                            return changeset2;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            return changeset2;
                        }
                    }
                    inputStream.close();
                    return changeset2;
                }
                try {
                    changeset = list.get(0);
                    return changeset;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
                return changeset;
            }
            {
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Changeset> readChangesets(Collection<Integer> collection, boolean bl, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (collection == null) {
            return Collections.emptyList();
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.trn("Downloading {0} changeset ...", "Downloading {0} changesets ...", collection.size(), collection.size()));
            progressMonitor.setTicksCount(collection.size());
            ArrayList<Changeset> arrayList = new ArrayList<Changeset>();
            int n = 0;
            Object object = collection.iterator();
            while (object.hasNext()) {
                int n2 = object.next();
                if (n2 <= 0) continue;
                ++n;
                try {
                    List<Changeset> list;
                    Throwable throwable;
                    InputStream inputStream;
                    block29: {
                        block30: {
                            inputStream = this.getChangesetInputStream(n2, bl, progressMonitor);
                            throwable = null;
                            if (inputStream != null) break block29;
                            list = null;
                            if (inputStream == null) return list;
                            if (throwable == null) break block30;
                            try {
                                inputStream.close();
                                return list;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return list;
                            }
                        }
                        inputStream.close();
                        return list;
                    }
                    try {
                        progressMonitor.indeterminateSubTask(I18n.tr("({0}/{1}) Downloading changeset {2} ...", n, collection.size(), n2));
                        list = OsmChangesetParser.parse(inputStream, progressMonitor.createSubTaskMonitor(1, true));
                        if (list == null || list.isEmpty()) continue;
                        arrayList.addAll(list);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        inputStream.close();
                        continue;
                    }
                }
                catch (IOException iOException) {
                    Main.warn(iOException);
                }
                progressMonitor.worked(1);
            }
            object = arrayList;
            return object;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (IllegalDataException illegalDataException) {
            throw new OsmTransferException(illegalDataException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangesetDataSet downloadChangeset(int n, ProgressMonitor progressMonitor) throws OsmTransferException {
        if (n <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected value of type integer > 0 for parameter ''{0}'', got {1}", "id", n));
        }
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        ChangesetDataSet changesetDataSet = null;
        try {
            progressMonitor.beginTask(I18n.tr("Downloading changeset content", new Object[0]));
            StringBuilder stringBuilder = new StringBuilder(32).append("changeset/").append(n).append("/download");
            try {
                Throwable throwable;
                InputStream inputStream;
                block26: {
                    ChangesetDataSet changesetDataSet2;
                    block27: {
                        inputStream = this.getInputStream(stringBuilder.toString(), progressMonitor.createSubTaskMonitor(1, true));
                        throwable = null;
                        if (inputStream != null) break block26;
                        changesetDataSet2 = null;
                        if (inputStream == null) return changesetDataSet2;
                        if (throwable == null) break block27;
                        try {
                            inputStream.close();
                            return changesetDataSet2;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return changesetDataSet2;
                        }
                    }
                    inputStream.close();
                    return changesetDataSet2;
                }
                try {
                    progressMonitor.setCustomText(I18n.tr("Downloading content for changeset {0} ...", n));
                    OsmChangesetContentParser osmChangesetContentParser = new OsmChangesetContentParser(inputStream);
                    changesetDataSet = osmChangesetContentParser.parse(progressMonitor.createSubTaskMonitor(1, true));
                    return changesetDataSet;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
                return changesetDataSet;
            }
        }
        catch (XmlParsingException xmlParsingException) {
            throw new OsmTransferException(xmlParsingException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

