/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.ffi.LastError;
import jnr.ffi.LibraryLoader;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.annotations.Transient;
import jnr.ffi.byref.IntByReference;
import jnr.posix.DefaultNativeTimeval;
import jnr.posix.Timeval;
import jnr.unixsocket.SockAddrUnix;

class Native {
    static final String[] libnames;
    static final LibC INSTANCE;

    Native() {
    }

    static final LibC libsocket() {
        return INSTANCE;
    }

    static final LibC libc() {
        return INSTANCE;
    }

    static int socket(ProtocolFamily domain, Sock type2, int protocol2) throws IOException {
        int fd = Native.libsocket().socket(domain.intValue(), type2.intValue(), protocol2);
        if (fd < 0) {
            throw new IOException(Native.getLastErrorString());
        }
        return fd;
    }

    static int socketpair(ProtocolFamily domain, Sock type2, int protocol2, int[] sv) throws IOException {
        if (Native.libsocket().socketpair(domain.intValue(), type2.intValue(), protocol2, sv) < 0) {
            throw new IOException("socketpair(2) failed " + Native.getLastErrorString());
        }
        return 0;
    }

    static int listen(int fd, int backlog) {
        return Native.libsocket().listen(fd, backlog);
    }

    static int bind(int fd, SockAddrUnix addr2, int len) {
        return Native.libsocket().bind(fd, addr2, len);
    }

    static int accept(int fd, SockAddrUnix addr2, IntByReference len) {
        return Native.libsocket().accept(fd, addr2, len);
    }

    static int connect(int fd, SockAddrUnix addr2, int len) {
        return Native.libsocket().connect(fd, addr2, len);
    }

    static String getLastErrorString() {
        return Native.strerror(LastError.getLastError(Runtime.getSystemRuntime()));
    }

    static String strerror(int error2) {
        return Native.libc().strerror(error2);
    }

    public static void setBlocking(int fd, boolean block) {
        int flags2 = Native.libc().fcntl(fd, LibC.F_GETFL, 0);
        flags2 = block ? (flags2 &= ~LibC.O_NONBLOCK) : (flags2 |= LibC.O_NONBLOCK);
        Native.libc().fcntl(fd, LibC.F_SETFL, flags2);
    }

    public static int setsockopt(int s2, SocketLevel level2, SocketOption optname2, boolean optval) {
        return Native.setsockopt(s2, level2, optname2, optval ? 1 : 0);
    }

    public static int setsockopt(int s2, SocketLevel level2, SocketOption optname2, int optval) {
        if (optname2 == SocketOption.SO_RCVTIMEO) {
            DefaultNativeTimeval t = new DefaultNativeTimeval(Runtime.getSystemRuntime());
            t.setTime(new long[]{optval / 1000, optval % 1000 * 1000});
            return Native.libsocket().setsockopt(s2, level2.intValue(), optname2.intValue(), t, DefaultNativeTimeval.size(t));
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(optval).flip();
        return Native.libsocket().setsockopt(s2, level2.intValue(), optname2.intValue(), buf, buf.remaining());
    }

    public static int getsockopt(int s2, SocketLevel level2, int optname2) {
        if (optname2 == SocketOption.SO_RCVTIMEO.intValue()) {
            DefaultNativeTimeval t = new DefaultNativeTimeval(Runtime.getSystemRuntime());
            IntByReference ref = new IntByReference(DefaultNativeTimeval.size(t));
            Native.libsocket().getsockopt(s2, level2.intValue(), optname2, t, ref);
            return t.tv_sec.intValue() * 1000 + t.tv_usec.intValue() / 1000;
        }
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        IntByReference ref = new IntByReference(4);
        Native.libsocket().getsockopt(s2, level2.intValue(), optname2, buf, ref);
        return buf.getInt();
    }

    public static int getsockopt(int s2, SocketLevel level2, SocketOption optname2, Struct data2) {
        Pointer struct_ptr = Struct.getMemory(data2);
        IntByReference ref = new IntByReference(Struct.size(data2));
        ByteBuffer buf = ByteBuffer.wrap((byte[])struct_ptr.array());
        return Native.libsocket().getsockopt(s2, level2.intValue(), optname2.intValue(), buf, ref);
    }

    public static boolean getboolsockopt(int s2, SocketLevel level2, int optname2) {
        return Native.getsockopt(s2, level2, optname2) != 0;
    }

    static {
        String[] stringArray;
        if (Platform.getNativePlatform().getOS() == Platform.OS.SOLARIS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "socket";
            stringArray2[1] = "nsl";
            stringArray = stringArray2;
            stringArray2[2] = Platform.getNativePlatform().getStandardCLibraryName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = Platform.getNativePlatform().getStandardCLibraryName();
        }
        libnames = stringArray;
        LibraryLoader<LibC> loader = LibraryLoader.create(LibC.class);
        for (String libraryName : libnames) {
            loader.library(libraryName);
        }
        INSTANCE = loader.load();
    }

    public static interface LibC {
        public static final int F_GETFL = Fcntl.F_GETFL.intValue();
        public static final int F_SETFL = Fcntl.F_SETFL.intValue();
        public static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.intValue();

        public int socket(int var1, int var2, int var3);

        public int listen(int var1, int var2);

        public int bind(int var1, @In @Out @Transient SockAddrUnix var2, int var3);

        public int accept(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int connect(int var1, @In @Transient SockAddrUnix var2, int var3);

        public int getsockname(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int getpeername(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int socketpair(int var1, int var2, int var3, @Out int[] var4);

        public int fcntl(int var1, int var2, int var3);

        public int getsockopt(int var1, int var2, int var3, @Out ByteBuffer var4, @In @Out IntByReference var5);

        public int getsockopt(int var1, int var2, int var3, @Out Timeval var4, @In @Out IntByReference var5);

        public int setsockopt(int var1, int var2, int var3, @In ByteBuffer var4, int var5);

        public int setsockopt(int var1, int var2, int var3, @In Timeval var4, int var5);

        public String strerror(int var1);
    }
}

