/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jnr.posix.FileStat;
import org.jruby.util.AbstractFileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.JarCache;
import org.jruby.util.JarDirectoryResource;
import org.jruby.util.JarFileResource;
import org.jruby.util.JarFileStat;

abstract class JarResource
extends AbstractFileResource {
    private static Pattern PREFIX_MATCH = Pattern.compile("^(?:jar:)?(?:file:)?(.*)$");
    private static final JarCache jarCache = new JarCache();
    private final String jarPrefix;
    private final JarFileStat fileStat;

    public static JarResource create(String pathname2) {
        JarResource resource2;
        if (!pathname2.contains("!")) {
            return null;
        }
        Matcher matcher = PREFIX_MATCH.matcher(pathname2);
        String sanitized = matcher.matches() ? matcher.group(1) : pathname2;
        int bang = sanitized.indexOf(33);
        String jarPath = sanitized.substring(0, bang);
        String entryPath = sanitized.substring(bang + 1);
        if (entryPath.startsWith("//")) {
            entryPath = entryPath.substring(1);
        }
        if ((resource2 = JarResource.createJarResource(jarPath, entryPath, false)) == null && entryPath.startsWith("/")) {
            resource2 = JarResource.createJarResource(jarPath, entryPath.substring(1), true);
        }
        return resource2;
    }

    private static JarResource createJarResource(String jarPath, String entryPath, boolean rootSlashPrefix) {
        String[] entries2;
        JarCache.JarIndex index2 = jarCache.getIndex(jarPath);
        if (index2 == null) {
            try {
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
                entryPath = URLDecoder.decode(entryPath, "UTF-8");
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("hmm - system does not know UTF-8 string encoding :(");
            }
            index2 = jarCache.getIndex(jarPath);
            if (index2 == null) {
                return null;
            }
        }
        if ((entries2 = index2.getDirEntries(entryPath)) != null) {
            return new JarDirectoryResource(jarPath, rootSlashPrefix, entryPath, entries2);
        }
        JarEntry jarEntry = index2.getJarEntry(entryPath);
        if (jarEntry != null) {
            return new JarFileResource(jarPath, rootSlashPrefix, index2, jarEntry);
        }
        return null;
    }

    protected JarResource(String jarPath, boolean rootSlashPrefix) {
        this.jarPrefix = rootSlashPrefix ? jarPath + "!/" : jarPath + "!";
        this.fileStat = new JarFileStat(this);
    }

    @Override
    public String absolutePath() {
        return this.jarPrefix + this.entryName();
    }

    @Override
    public String canonicalPath() {
        return this.absolutePath();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat() {
        return this.fileStat;
    }

    @Override
    public FileStat lstat() {
        return this.stat();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return JRubyFile.DUMMY;
    }

    protected abstract String entryName();
}

