/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.cast.ToEncodingNode;
import org.jruby.truffle.core.cast.ToStrNode;
import org.jruby.truffle.core.cast.ToStrNodeGen;
import org.jruby.truffle.core.encoding.EncodingNodesFactory;
import org.jruby.truffle.core.encoding.EncodingOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.util.ByteList;

@CoreClass(value="Encoding")
public abstract class EncodingNodes {

    @NodeChildren(value={@NodeChild(value="first"), @NodeChild(value="second")})
    public static abstract class CheckEncodingNode
    extends RubyNode {
        @Node.Child
        private CompatibleQueryNode compatibleQueryNode;
        @Node.Child
        private ToEncodingNode toEncodingNode;

        public CheckEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compatibleQueryNode = EncodingNodesFactory.CompatibleQueryNodeFactory.create(context, sourceSection, new RubyNode[0]);
            this.toEncodingNode = ToEncodingNode.create();
        }

        public abstract Encoding executeCheckEncoding(Object var1, Object var2);

        @Specialization
        public Encoding checkEncoding(Object first, Object second, @Cached(value="create()") BranchProfile errorProfile) {
            DynamicObject rubyEncoding = this.compatibleQueryNode.executeCompatibleQuery(first, second);
            if (rubyEncoding == this.nil()) {
                errorProfile.enter();
                throw new RaiseException(this.getContext().getCoreExceptions().encodingCompatibilityErrorIncompatible(this.toEncodingNode.executeToEncoding(first), this.toEncodingNode.executeToEncoding(second), this));
            }
            return this.toEncodingNode.executeToEncoding(rubyEncoding);
        }
    }

    @Primitive(name="encoding_get_encoding_by_index", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingByIndexNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject encodingGetObjectEncodingByIndex(int index) {
            return this.getContext().getEncodingManager().getRubyEncoding(index);
        }
    }

    @Primitive(name="encoding_replicate")
    public static abstract class EncodingReplicateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(nameObject)"})
        public DynamicObject encodingReplicate(VirtualFrame frame, DynamicObject self, DynamicObject nameObject, @Cached(value="new()") SnippetNode snippetNode) {
            String name = StringOperations.getString(nameObject);
            Encoding encoding = EncodingOperations.getEncoding(self);
            DynamicObject newEncoding = this.getContext().getEncodingManager().replicateEncoding(encoding, name);
            if (newEncoding == null) {
                throw new RaiseException(this.coreExceptions().argumentErrorEncodingAlreadyRegistered(name, this));
            }
            EncodingDB.Entry entry = (EncodingDB.Entry)EncodingDB.getEncodings().get(name.getBytes());
            snippetNode.execute(frame, "Encoding::EncodingMap[enc.name.upcase.to_sym] = [nil, index]", "enc", newEncoding, "index", entry.getIndex());
            return newEncoding;
        }
    }

    @Primitive(name="encoding_get_object_encoding", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject encodingGetObjectEncodingString(DynamicObject string) {
            return this.getContext().getEncodingManager().getRubyEncoding(Layouts.STRING.getRope(string).getEncoding());
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public DynamicObject encodingGetObjectEncodingSymbol(DynamicObject symbol) {
            return this.getContext().getEncodingManager().getRubyEncoding(Layouts.SYMBOL.getRope(symbol).getEncoding());
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject encodingGetObjectEncoding(DynamicObject encoding) {
            return encoding;
        }

        @Specialization(guards={"isRubyRegexp(regexp)"})
        public DynamicObject encodingGetObjectEncodingRegexp(DynamicObject regexp) {
            return this.getContext().getEncodingManager().getRubyEncoding(Layouts.REGEXP.getSource(regexp).getEncoding());
        }

        @Specialization(guards={"!isRubyString(object)", "!isRubySymbol(object)", "!isRubyEncoding(object)", "!isRubyRegexp(object)"})
        public DynamicObject encodingGetObjectEncodingNil(DynamicObject object) {
            return this.nil();
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toS(DynamicObject encoding) {
            return Layouts.ENCODING.getName(encoding);
        }
    }

    @CoreMethod(names={"get_default_encoding"}, onSingleton=true, visibility=Visibility.PRIVATE, required=1)
    public static abstract class GetDefaultEncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(name)"})
        public DynamicObject getDefaultEncoding(DynamicObject name) {
            Encoding encoding = this.getEncoding(StringOperations.getString(name));
            if (encoding == null) {
                return this.nil();
            }
            return this.getContext().getEncodingManager().getRubyEncoding(encoding);
        }

        @CompilerDirectives.TruffleBoundary
        private Encoding getEncoding(String name) {
            switch (name) {
                case "internal": {
                    return this.getContext().getJRubyRuntime().getDefaultInternalEncoding();
                }
                case "external": {
                    return this.getContext().getJRubyRuntime().getDefaultExternalEncoding();
                }
                case "locale": 
                case "filesystem": {
                    return this.getContext().getEncodingManager().getLocaleEncoding();
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"each_alias"}, onSingleton=true, visibility=Visibility.PRIVATE, needsBlock=true)
    public static abstract class EachAliasNode
    extends YieldingCoreMethodNode {
        @Specialization
        public DynamicObject eachAlias(VirtualFrame frame, DynamicObject block) {
            CompilerAsserts.neverPartOfCompilation();
            for (Hash.HashEntry entry : EncodingDB.getAliases().entryIterator()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)entry;
                ByteList aliasName = new ByteList(e.bytes, e.p, e.end - e.p, (Encoding)USASCIIEncoding.INSTANCE, false);
                this.yield(frame, block, this.createString(aliasName), ((EncodingDB.Entry)entry.value).getIndex());
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"encoding == cachedEncoding"}, limit="getCacheLimit()")
        public boolean isDummyCached(DynamicObject encoding, @Cached(value="encoding") DynamicObject cachedEncoding, @Cached(value="isDummy(cachedEncoding)") boolean isDummy) {
            return isDummy;
        }

        @Specialization(contains={"isDummyCached"})
        public boolean isDummyUncached(DynamicObject encoding) {
            return DummyNode.isDummy(encoding);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_LOADED_CLASSES_CACHE;
        }

        protected static boolean isDummy(DynamicObject encoding) {
            assert (RubyGuards.isRubyEncoding(encoding));
            return Layouts.ENCODING.getDummy(encoding);
        }
    }

    @CoreMethod(names={"locale_charmap"}, onSingleton=true)
    public static abstract class LocaleCharacterMapNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject localeCharacterMap() {
            DynamicObject rubyEncoding = this.getContext().getEncodingManager().getRubyEncoding(this.getContext().getEncodingManager().getLocaleEncoding());
            return Layouts.ENCODING.getName(rubyEncoding);
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject list() {
            Object[] encodingsList = this.getContext().getEncodingManager().getEncodingList();
            return this.createArray(encodingsList, encodingsList.length);
        }
    }

    @CoreMethod(names={"default_internal_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultInternal(DynamicObject encoding) {
            this.getContext().getJRubyRuntime().setDefaultInternalEncoding(EncodingOperations.getEncoding(encoding));
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(encoding)"})
        public DynamicObject defaultInternal(Object encoding) {
            this.getContext().getJRubyRuntime().setDefaultInternalEncoding(null);
            return this.nil();
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isNil(encoding)"})
        public DynamicObject defaultInternal(VirtualFrame frame, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), null, null));
            }
            DynamicObject encodingName = this.toStrNode.executeToStr(frame, encoding);
            this.getContext().getJRubyRuntime().setDefaultInternalEncoding(EncodingOperations.getEncoding(this.getContext().getEncodingManager().getRubyEncoding(encodingName.toString())));
            return encodingName;
        }
    }

    @CoreMethod(names={"default_external_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultExternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultExternalEncoding(DynamicObject encoding) {
            this.getContext().getJRubyRuntime().setDefaultExternalEncoding(EncodingOperations.getEncoding(encoding));
            return encoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(encodingString)"})
        public DynamicObject defaultExternal(DynamicObject encodingString) {
            DynamicObject rubyEncoding = this.getContext().getEncodingManager().getRubyEncoding(encodingString.toString());
            this.getContext().getJRubyRuntime().setDefaultExternalEncoding(EncodingOperations.getEncoding(rubyEncoding));
            return rubyEncoding;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(nil)"})
        public DynamicObject defaultExternal(Object nil) {
            throw new RaiseException(this.coreExceptions().argumentError("default external can not be nil", this));
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isRubyString(encoding)", "!isNil(encoding)"})
        public DynamicObject defaultExternal(VirtualFrame frame, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), null, null));
            }
            return this.defaultExternal(this.toStrNode.executeToStr(frame, encoding));
        }
    }

    @CoreMethod(names={"compatible?"}, onSingleton=true, required=2)
    public static abstract class CompatibleQueryNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToEncodingNode toEncodingNode = ToEncodingNode.create();

        public CompatibleQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract DynamicObject executeCompatibleQuery(Object var1, Object var2);

        @Specialization(guards={"getEncoding(first) == getEncoding(second)", "getEncoding(first) == cachedEncoding"}, limit="getCacheLimit()")
        public DynamicObject isCompatibleCached(Object first, Object second, @Cached(value="getEncoding(first)") Encoding cachedEncoding, @Cached(value="getRubyEncoding(cachedEncoding)") DynamicObject result) {
            return result;
        }

        @Specialization(guards={"getEncoding(first) == getEncoding(second)"}, contains={"isCompatibleCached"})
        public DynamicObject isCompatibleUncached(Object first, Object second) {
            return this.getRubyEncoding(this.getEncoding(first));
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "isRubyString(first)", "isRubyString(second)", "isEmpty(first) == isFirstEmpty", "isEmpty(second) == isSecondEmpty", "getCodeRange(first) == firstCodeRange", "getCodeRange(second) == secondCodeRange", "getEncoding(first) == firstEncoding", "getEncoding(second) == secondEncoding"}, limit="getCacheLimit()")
        public DynamicObject isCompatibleStringStringCached(DynamicObject first, DynamicObject second, @Cached(value="getEncoding(first)") Encoding firstEncoding, @Cached(value="getEncoding(second)") Encoding secondEncoding, @Cached(value="isEmpty(first)") boolean isFirstEmpty, @Cached(value="isEmpty(second)") boolean isSecondEmpty, @Cached(value="getCodeRange(first)") CodeRange firstCodeRange, @Cached(value="getCodeRange(second)") CodeRange secondCodeRange, @Cached(value="isCompatibleStringStringUncached(first, second)") DynamicObject rubyEncoding) {
            return rubyEncoding;
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "isRubyString(first)", "isRubyString(second)"}, contains={"isCompatibleStringStringCached"})
        public DynamicObject isCompatibleStringStringUncached(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = CompatibleQueryNode.compatibleEncodingForStrings(first, second);
            if (compatibleEncoding != null) {
                return this.getContext().getEncodingManager().getRubyEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "isRubyString(first)", "!isRubyString(second)", "getCodeRange(first) == codeRange", "getEncoding(first) == firstEncoding", "getEncoding(second) == secondEncoding"}, limit="getCacheLimit()")
        public DynamicObject isCompatibleStringObjectCached(DynamicObject first, Object second, @Cached(value="getEncoding(first)") Encoding firstEncoding, @Cached(value="getEncoding(second)") Encoding secondEncoding, @Cached(value="getCodeRange(first)") CodeRange codeRange, @Cached(value="isCompatibleStringObjectUncached(first, second)") DynamicObject result) {
            return result;
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "isRubyString(first)", "!isRubyString(second)"}, contains={"isCompatibleStringObjectCached"})
        public DynamicObject isCompatibleStringObjectUncached(DynamicObject first, Object second) {
            Encoding firstEncoding = this.getEncoding(first);
            Encoding secondEncoding = this.getEncoding(second);
            if (secondEncoding == null) {
                return this.nil();
            }
            if (!firstEncoding.isAsciiCompatible() || !secondEncoding.isAsciiCompatible()) {
                return this.nil();
            }
            if (secondEncoding == USASCIIEncoding.INSTANCE) {
                return this.getContext().getEncodingManager().getRubyEncoding(firstEncoding);
            }
            if (this.getCodeRange(first) == CodeRange.CR_7BIT) {
                return this.getContext().getEncodingManager().getRubyEncoding(secondEncoding);
            }
            return this.nil();
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "!isRubyString(first)", "isRubyString(second)"})
        public DynamicObject isCompatibleObjectString(Object first, DynamicObject second) {
            return this.isCompatibleStringObjectUncached(second, first);
        }

        @Specialization(guards={"firstEncoding != secondEncoding", "!isRubyString(first)", "!isRubyString(second)", "firstEncoding != null", "secondEncoding != null", "getEncoding(first) == firstEncoding", "getEncoding(second) == secondEncoding"}, limit="getCacheLimit()")
        public DynamicObject isCompatibleObjectObjectCached(Object first, Object second, @Cached(value="getEncoding(first)") Encoding firstEncoding, @Cached(value="getEncoding(second)") Encoding secondEncoding, @Cached(value="getCompatibleEncoding(getContext(), firstEncoding, secondEncoding)") DynamicObject result) {
            return result;
        }

        @Specialization(guards={"getEncoding(first) != getEncoding(second)", "!isRubyString(first)", "!isRubyString(second)"}, contains={"isCompatibleObjectObjectCached"})
        public DynamicObject isCompatibleObjectObjectUncached(Object first, Object second) {
            Encoding firstEncoding = this.getEncoding(first);
            Encoding secondEncoding = this.getEncoding(second);
            return CompatibleQueryNode.getCompatibleEncoding(this.getContext(), firstEncoding, secondEncoding);
        }

        private static Encoding compatibleEncodingForStrings(DynamicObject first, DynamicObject second) {
            assert (RubyGuards.isRubyString(first));
            assert (RubyGuards.isRubyString(second));
            Rope firstRope = StringOperations.rope(first);
            Rope secondRope = StringOperations.rope(second);
            return CompatibleQueryNode.compatibleEncodingForRopes(firstRope, secondRope);
        }

        @CompilerDirectives.TruffleBoundary
        private static Encoding compatibleEncodingForRopes(Rope firstRope, Rope secondRope) {
            Encoding firstEncoding = firstRope.getEncoding();
            Encoding secondEncoding = secondRope.getEncoding();
            if (secondRope.isEmpty()) {
                return firstEncoding;
            }
            if (firstRope.isEmpty()) {
                return firstEncoding.isAsciiCompatible() && secondRope.getCodeRange() == CodeRange.CR_7BIT ? firstEncoding : secondEncoding;
            }
            if (!firstEncoding.isAsciiCompatible() || !secondEncoding.isAsciiCompatible()) {
                return null;
            }
            if (firstRope.getCodeRange() != secondRope.getCodeRange()) {
                if (firstRope.getCodeRange() == CodeRange.CR_7BIT) {
                    return secondEncoding;
                }
                if (secondRope.getCodeRange() == CodeRange.CR_7BIT) {
                    return firstEncoding;
                }
            }
            if (secondRope.getCodeRange() == CodeRange.CR_7BIT) {
                return firstEncoding;
            }
            if (firstRope.getCodeRange() == CodeRange.CR_7BIT) {
                return secondEncoding;
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static Encoding areCompatible(Encoding enc1, Encoding enc2) {
            assert (enc1 != enc2);
            if (enc1 == null || enc2 == null) {
                return null;
            }
            if (!enc1.isAsciiCompatible() || !enc2.isAsciiCompatible()) {
                return null;
            }
            if (enc2 instanceof USASCIIEncoding) {
                return enc1;
            }
            if (enc1 instanceof USASCIIEncoding) {
                return enc2;
            }
            return null;
        }

        protected static DynamicObject getCompatibleEncoding(RubyContext context, Encoding first, Encoding second) {
            Encoding compatibleEncoding = CompatibleQueryNode.areCompatible(first, second);
            if (compatibleEncoding != null) {
                return context.getEncodingManager().getRubyEncoding(compatibleEncoding);
            }
            return context.getCoreLibrary().getNilObject();
        }

        protected boolean isEmpty(Object string) {
            if (RubyGuards.isRubyString(string)) {
                return StringOperations.rope((DynamicObject)string).isEmpty();
            }
            return false;
        }

        protected CodeRange getCodeRange(Object string) {
            if (RubyGuards.isRubyString(string)) {
                return StringOperations.rope((DynamicObject)string).getCodeRange();
            }
            return CodeRange.CR_UNKNOWN;
        }

        protected Encoding getEncoding(Object value) {
            return this.toEncodingNode.executeToEncoding(value);
        }

        protected DynamicObject getRubyEncoding(Encoding value) {
            if (value == null) {
                return this.nil();
            }
            return this.getContext().getEncodingManager().getRubyEncoding(value);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_COMPATIBILE_QUERY_CACHE;
        }
    }

    @CoreMethod(names={"ascii_compatible?"})
    public static abstract class AsciiCompatibleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"encoding == cachedEncoding"}, limit="getCacheLimit()")
        public boolean isAsciiCompatibleCached(DynamicObject encoding, @Cached(value="encoding") DynamicObject cachedEncoding, @Cached(value="isAsciiCompatible(cachedEncoding)") boolean isAsciiCompatible) {
            return isAsciiCompatible;
        }

        @Specialization(contains={"isAsciiCompatibleCached"})
        public boolean isAsciiCompatibleUncached(DynamicObject encoding) {
            return AsciiCompatibleNode.isAsciiCompatible(encoding);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().ENCODING_LOADED_CLASSES_CACHE;
        }

        protected static boolean isAsciiCompatible(DynamicObject encoding) {
            assert (RubyGuards.isRubyEncoding(encoding));
            return EncodingOperations.getEncoding(encoding).isAsciiCompatible();
        }
    }
}

