;;;
;;; gauche.cgen.standalone - Create standalone binary
;;;
;;;   Copyright (c) 2014-2016  Shiro Kawai  <shiro@acm.org>
;;;
;;;   Redistribution and use in source and binary forms, with or without
;;;   modification, are permitted provided that the following conditions
;;;   are met:
;;;
;;;   1. Redistributions of source code must retain the above copyright
;;;      notice, this list of conditions and the following disclaimer.
;;;
;;;   2. Redistributions in binary form must reproduce the above copyright
;;;      notice, this list of conditions and the following disclaimer in the
;;;      documentation and/or other materials provided with the distribution.
;;;
;;;   3. Neither the name of the authors nor the names of its contributors
;;;      may be used to endorse or promote products derived from this
;;;      software without specific prior written permission.
;;;
;;;   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
;;;   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
;;;   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
;;;   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
;;;   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
;;;   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
;;;   TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
;;;   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
;;;   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;;   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;;   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;;;

(define-module gauche.cgen.standalone
  (use gauche.cgen)
  (use gauche.config)
  (use gauche.parameter)
  (use gauche.process)
  (use srfi-13)
  (use file.util)
  (export build-standalone)
  )
(select-module gauche.cgen.standalone)

(define (build-standalone srcfile :key (outfile #f)
                                       (include-dirs '())
                                       (library-dirs '()))
  (compile-c-file (generate-c-file srcfile)
                  (or outfile (path-sans-extension srcfile))
                  (map (^d #"-I\"~|d|\"") include-dirs)
                  (map (^d #"-L\"~|d|\"") library-dirs)))

(define (generate-c-file file)
  (parameterize ([cgen-current-unit
                  (make <cgen-unit>
                    :name (path-sans-extension file)
                    :preamble "/* Generated by make-standalone */"
                    :init-prologue "int main (int argc, const char *argv[]) {"
                    :init-epilogue "}")])
    (cgen-decl "#include <gauche.h>"
               "#include <gauche/static.h>")
    (cgen-decl (format "const char *main_script = ~a;"
                       (cgen-safe-string (file->string file))))
    (cgen-init "SCM_INIT_STATIC();"
               "Scm_SimpleMain(argc, argv, main_script, 0);")
    (cgen-emit-c (cgen-current-unit)))
  (path-swap-extension file "c"))

(define (compile-c-file c-file outfile xincdirs xlibdirs)
  ;; TODO: We wish we could use gauche.package.compile, but currently it is
  ;; specialized to compile extension modules.  Eventually we will modify
  ;; the module so that this function can be just a one-liner
  (let ([cc (gauche-config "--cc")]
        [cflags (gauche-config "--so-cflags")]
        [incdirs (string-join `(,@xincdirs ,(gauche-config "-I")) " ")]
        [libdirs (string-join `(,@xlibdirs ,(gauche-config "-L")) " ")]
        [libs    (gauche-config "--static-libs")])
    (let1 cmd #"~cc ~cflags ~incdirs -o ~outfile ~c-file ~libdirs ~libs"
      (print cmd)
      (sys-system cmd))))
