/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.JHotDrawRuntimeException;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.framework.ToolListener;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteIcon;
import CH.ifa.draw.util.PaletteListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.EventObject;
import javax.swing.ImageIcon;

public class ToolButton
extends PaletteButton
implements ToolListener {
    private String fName;
    private Tool fTool;
    private PaletteIcon fIcon;

    public ToolButton(PaletteListener listener, String iconName, String name, Tool tool) {
        super(listener);
        tool.addToolListener(this);
        this.setEnabled(tool.isUsable());
        Iconkit kit = Iconkit.instance();
        if (kit == null) {
            throw new JHotDrawRuntimeException("Iconkit instance isn't set");
        }
        Image[] im = new Image[]{kit.loadImageResource(iconName + "1.gif"), kit.loadImageResource(iconName + "2.gif"), kit.loadImageResource(iconName + "3.gif")};
        MediaTracker tracker = new MediaTracker(this);
        for (int i = 0; i < 3; ++i) {
            tracker.addImage(im[i], i);
        }
        try {
            tracker.waitForAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fIcon = new PaletteIcon(new Dimension(24, 24), im[0], im[1], im[2]);
        this.fTool = tool;
        this.fName = name;
        this.setIcon(new ImageIcon(im[0]));
        this.setPressedIcon(new ImageIcon(im[1]));
        this.setSelectedIcon(new ImageIcon(im[2]));
        this.setToolTipText(name);
    }

    public Tool tool() {
        return this.fTool;
    }

    public String name() {
        return this.fName;
    }

    public Object attributeValue() {
        return this.tool();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.fIcon.getWidth(), this.fIcon.getHeight());
    }

    public void paintSelected(Graphics g) {
        if (this.fIcon.selected() != null) {
            g.drawImage(this.fIcon.selected(), 0, 0, this);
        }
    }

    public void paint(Graphics g) {
        if (this.isSelected()) {
            this.paintSelected(g);
        } else {
            super.paint(g);
        }
    }

    public void toolUsable(EventObject toolEvent) {
        this.setEnabled(true);
    }

    public void toolUnusable(EventObject toolEvent) {
        this.setEnabled(false);
        this.setSelected(false);
    }

    public void toolActivated(EventObject toolEvent) {
    }

    public void toolDeactivated(EventObject toolEvent) {
    }

    public void toolEnabled(EventObject toolEvent) {
        this.setEnabled(true);
    }

    public void toolDisabled(EventObject toolEvent) {
        this.setEnabled(false);
    }
}

