/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyPolyline
extends EMFTag {
    private Rectangle bounds;
    private int start;
    private int end;
    private int[] numberOfPoints;
    private Point[][] points;

    PolyPolyline() {
        super(7, 1);
    }

    public PolyPolyline(Rectangle bounds, int start, int end, int[] numberOfPoints, Point[][] points) {
        this();
        this.bounds = bounds;
        this.start = start;
        this.end = Math.min(end, numberOfPoints.length - 1);
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int i;
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        int totalNumberOfPoints = emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        for (i = 0; i < np; ++i) {
            pc[i] = emf.readDWORD();
            points[i] = new Point[pc[i]];
        }
        for (i = 0; i < np; ++i) {
            points[i] = emf.readPOINTL(pc[i]);
        }
        PolyPolyline tag = new PolyPolyline(bounds, 0, np - 1, pc, points);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        int i;
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.end - this.start + 1);
        int c = 0;
        for (i = this.start; i < this.end + 1; ++i) {
            c += this.numberOfPoints[i];
        }
        emf.writeDWORD(c);
        for (i = this.start; i < this.end + 1; ++i) {
            emf.writeDWORD(this.numberOfPoints[i]);
        }
        for (i = this.start; i < this.end + 1; ++i) {
            emf.writePOINTL(this.numberOfPoints[i], this.points[i]);
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #polys: " + (this.end - this.start);
    }
}

