/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javajs.J2SIgnoreImport;
import javajs.api.BytePoster;
import javajs.api.GenericOutputChannel;
import javajs.api.JmolObjectInterface;
import javajs.util.Base64;
import javajs.util.SB;

@J2SIgnoreImport(value={FileOutputStream.class})
public class OC
extends OutputStream
implements GenericOutputChannel {
    private BytePoster bytePoster;
    private String fileName;
    private BufferedWriter bw;
    private boolean isLocalFile;
    private int byteCount;
    private boolean isCanceled;
    private boolean closed;
    private OutputStream os;
    private SB sb;
    private String type;
    private boolean isBase64;
    private OutputStream os0;
    private byte[] bytes;
    public static final String[] urlPrefixes = new String[]{"http:", "https:", "sftp:", "ftp:", "file:"};
    public static final int URL_LOCAL = 4;

    public OC setParams(BytePoster bytePoster, String string, boolean bl, OutputStream outputStream) {
        this.bytePoster = bytePoster;
        this.fileName = string;
        this.isBase64 = ";base64,".equals(string);
        if (this.isBase64) {
            string = null;
            this.os0 = outputStream;
            outputStream = null;
        }
        this.os = outputStream;
        boolean bl2 = this.isLocalFile = string != null && !OC.isRemote(string);
        if (bl && !this.isBase64 && outputStream != null) {
            this.bw = new BufferedWriter(new OutputStreamWriter(outputStream));
        }
        return this;
    }

    public OC setBytes(byte[] byArray) {
        this.bytes = byArray;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getName() {
        return this.fileName == null ? null : this.fileName.substring(this.fileName.lastIndexOf("/") + 1);
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public OC append(String string) {
        block5: {
            try {
                if (this.bw != null) {
                    this.bw.write(string);
                    break block5;
                }
                if (this.os == null) {
                    if (this.sb == null) {
                        this.sb = new SB();
                    }
                    this.sb.append(string);
                    break block5;
                }
                byte[] byArray = string.getBytes();
                this.os.write(byArray, 0, byArray.length);
                this.byteCount += byArray.length;
                return this;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.byteCount += string.length();
        return this;
    }

    @Override
    public void reset() {
        this.sb = null;
        this.initOS();
    }

    private void initOS() {
        if (this.sb != null) {
            String string = this.sb.toString();
            this.reset();
            this.append(string);
            return;
        }
        try {
            if (this.os instanceof FileOutputStream) {
                this.os.close();
                this.os = new FileOutputStream(this.fileName);
            } else {
                this.os = null;
            }
            if (this.os == null) {
                this.os = new ByteArrayOutputStream();
            }
            if (this.bw != null) {
                this.bw.close();
                this.bw = new BufferedWriter(new OutputStreamWriter(this.os));
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        this.byteCount = 0;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (this.os == null) {
            this.initOS();
        }
        try {
            this.os.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.byteCount += n2;
    }

    @Override
    public void writeByteAsInt(int n) {
        if (this.os == null) {
            this.initOS();
        }
        try {
            this.os.write(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.byteCount;
    }

    @Override
    @Deprecated
    public void write(int n) {
        if (this.os == null) {
            this.initOS();
        }
        try {
            this.os.write(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ++this.byteCount;
    }

    public void cancel() {
        this.isCanceled = true;
        this.closeChannel();
    }

    @Override
    public String closeChannel() {
        if (this.closed) {
            return null;
        }
        try {
            if (this.bw != null) {
                this.bw.flush();
                this.bw.close();
            } else if (this.os != null) {
                this.os.flush();
                this.os.close();
            }
            if (this.os0 != null && this.isCanceled) {
                this.os0.flush();
                this.os0.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isCanceled) {
            this.closed = true;
            return null;
        }
        if (this.fileName == null) {
            if (this.isBase64) {
                String string = this.getBase64();
                if (this.os0 != null) {
                    this.os = this.os0;
                    this.append(string);
                }
                this.sb = new SB();
                this.sb.append(string);
                this.isBase64 = false;
                return this.closeChannel();
            }
            return this.sb == null ? null : this.sb.toString();
        }
        this.closed = true;
        JmolObjectInterface jmolObjectInterface = null;
        Object var2_4 = null;
        if (!this.isLocalFile) {
            String string = this.postByteArray();
            if (string.startsWith("java.net")) {
                this.byteCount = -1;
            }
            return string;
        }
        if (jmolObjectInterface != null) {
            Object object;
            Object object2 = object = this.sb == null ? this.toByteArray() : (Object)this.sb.toString();
            if (var2_4 == null) {
                jmolObjectInterface._doAjax(this.fileName, null, object);
            } else {
                jmolObjectInterface._apply(this.fileName, object);
            }
        }
        return null;
    }

    public boolean isBase64() {
        return this.isBase64;
    }

    public String getBase64() {
        return Base64.getBase64(this.toByteArray()).toString();
    }

    public byte[] toByteArray() {
        return this.bytes != null ? this.bytes : (byte[])(this.os instanceof ByteArrayOutputStream ? ((ByteArrayOutputStream)this.os).toByteArray() : null);
    }

    @Override
    @Deprecated
    public void close() {
        this.closeChannel();
    }

    public String toString() {
        if (this.bw != null) {
            try {
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.sb != null) {
            return this.closeChannel();
        }
        return this.byteCount + " bytes";
    }

    private String postByteArray() {
        byte[] byArray = this.sb == null ? this.toByteArray() : this.sb.toString().getBytes();
        return this.bytePoster.postByteArray(this.fileName, byArray);
    }

    public static boolean isRemote(String string) {
        if (string == null) {
            return false;
        }
        int n = OC.urlTypeIndex(string);
        return n >= 0 && n != 4;
    }

    public static boolean isLocal(String string) {
        if (string == null) {
            return false;
        }
        int n = OC.urlTypeIndex(string);
        return n < 0 || n == 4;
    }

    public static int urlTypeIndex(String string) {
        if (string == null) {
            return -2;
        }
        for (int i = 0; i < urlPrefixes.length; ++i) {
            if (!string.startsWith(urlPrefixes[i])) continue;
            return i;
        }
        return -1;
    }
}

