/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import java.text.NumberFormat;
import java.util.Locale;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.util.ByteList;
import org.jruby.util.Sprintf;

@NodeChildren(value={@NodeChild(value="width", type=FormatNode.class), @NodeChild(value="precision", type=FormatNode.class), @NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatFloatNode
extends FormatNode {
    private static final byte[] NAN_VALUE = new byte[]{78, 97, 78};
    private static final byte[] INFINITY_VALUE = new byte[]{73, 110, 102};
    private final char format;
    private final boolean hasSpaceFlag;
    private final boolean hasZeroFlag;
    private final boolean hasPlusFlag;
    private final boolean hasMinusFlag;
    private final boolean hasFSharpFlag;

    public FormatFloatNode(RubyContext context, char format, boolean hasSpaceFlag, boolean hasZeroFlag, boolean hasPlusFlag, boolean hasMinusFlag, boolean hasFSharpFlag) {
        super(context);
        this.format = format;
        this.hasSpaceFlag = hasSpaceFlag;
        this.hasZeroFlag = hasZeroFlag;
        this.hasPlusFlag = hasPlusFlag;
        this.hasMinusFlag = hasMinusFlag;
        this.hasFSharpFlag = hasFSharpFlag;
    }

    /*
     * Enabled aggressive block sorting
     */
    @CompilerDirectives.TruffleBoundary
    @Specialization
    public byte[] formatInfinite(int width, int precision, double dval) {
        byte expChar;
        byte signChar;
        byte ival;
        boolean hasPrecisionFlag = precision != -1;
        char fchar = this.format;
        boolean nan = dval != dval;
        boolean inf = dval == Double.POSITIVE_INFINITY || dval == Double.NEGATIVE_INFINITY;
        boolean negative = dval < 0.0 || dval == 0.0 && new Float(dval).equals(new Float(-0.0));
        int nDigits = 0;
        int exponent = 0;
        int len = 0;
        ByteList buf = new ByteList();
        if (nan || inf) {
            byte signChar2;
            byte[] digits;
            if (nan) {
                digits = NAN_VALUE;
                len = NAN_VALUE.length;
            } else {
                digits = INFINITY_VALUE;
                len = INFINITY_VALUE.length;
            }
            if (negative) {
                signChar2 = 45;
                --width;
            } else if (this.hasPlusFlag) {
                signChar2 = 43;
                --width;
            } else if (this.hasSpaceFlag) {
                signChar2 = 32;
                --width;
            } else {
                signChar2 = 0;
            }
            if ((width -= len) > 0 && !this.hasZeroFlag && !this.hasMinusFlag) {
                buf.fill(32, width);
                width = 0;
            }
            if (signChar2 != 0) {
                buf.append(signChar2);
            }
            if (width > 0 && !this.hasMinusFlag) {
                buf.fill(48, width);
                width = 0;
            }
            buf.append(digits);
            if (width <= 0) return buf.bytes();
            buf.fill(32, width);
            return buf.bytes();
        }
        Locale locale = Locale.ENGLISH;
        NumberFormat nf = Sprintf.getNumberFormat((Locale)locale);
        nf.setMaximumFractionDigits(Integer.MAX_VALUE);
        String str = nf.format(dval);
        int strlen = str.length();
        byte[] digits = new byte[strlen];
        int nTrailingZeroes = 0;
        int i = negative ? 1 : 0;
        int decPos = 0;
        block19: while (i < strlen) {
            ival = (byte)str.charAt(i++);
            switch (ival) {
                case 48: {
                    if (nDigits <= 0) break;
                    ++nTrailingZeroes;
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (nTrailingZeroes > 0) {
                        digits[nDigits++] = 48;
                        --nTrailingZeroes;
                    }
                    digits[nDigits++] = ival;
                    break;
                }
                case 46: {
                    break block19;
                }
            }
        }
        decPos = nDigits + nTrailingZeroes;
        block21: while (i < strlen) {
            ival = (byte)str.charAt(i++);
            switch (ival) {
                case 48: {
                    if (nDigits > 0) {
                        ++nTrailingZeroes;
                        break;
                    }
                    --exponent;
                    break;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    while (nTrailingZeroes > 0) {
                        digits[nDigits++] = 48;
                        --nTrailingZeroes;
                    }
                    digits[nDigits++] = ival;
                    break;
                }
                case 69: {
                    break block21;
                }
            }
        }
        if (i < strlen) {
            int expSign;
            int expVal = 0;
            if (str.charAt(i) == '-') {
                expSign = -1;
                ++i;
            } else {
                expSign = 1;
            }
            while (i < strlen) {
                expVal = expVal * 10 + (str.charAt(i++) - 48);
            }
            exponent += expVal * expSign;
        }
        exponent += decPos - nDigits;
        if (nDigits == 0) {
            digits[0] = 48;
            nDigits = 1;
            exponent = 0;
        }
        if (negative) {
            signChar = 45;
            --width;
        } else if (this.hasPlusFlag) {
            signChar = 43;
            --width;
        } else if (this.hasSpaceFlag) {
            signChar = 32;
            --width;
        } else {
            signChar = 0;
        }
        if (!hasPrecisionFlag) {
            precision = 6;
        }
        switch (fchar) {
            case 'E': 
            case 'G': {
                expChar = 69;
                break;
            }
            case 'e': 
            case 'g': {
                expChar = 101;
                break;
            }
            default: {
                expChar = 0;
            }
        }
        byte decimalSeparator = (byte)Sprintf.getDecimalFormat((Locale)locale).getDecimalSeparator();
        switch (fchar) {
            case 'G': 
            case 'g': {
                boolean expForm;
                boolean bl = exponent + nDigits - 1 < -4 || exponent + nDigits > (precision == 0 ? 1 : precision) ? true : (expForm = false);
                if (expForm) {
                    boolean dotToPrint;
                    int decDigits = nDigits - 1;
                    if ((precision = Math.max(0, precision - 1)) < decDigits) {
                        int n = FormatFloatNode.round(digits, nDigits, precision, precision != 0);
                        if (n > nDigits) {
                            nDigits = n;
                        }
                        decDigits = Math.min(nDigits - 1, precision);
                    }
                    boolean isSharp = this.hasFSharpFlag;
                    ++len;
                    len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                    if (isSharp) {
                        ++len;
                    }
                    if (precision > 0) {
                        if (!isSharp) {
                            for (int j = decDigits; j >= 1 && digits[j] == 48; --decDigits, --j) {
                            }
                            if (decDigits > 0) {
                                ++len;
                                len += decDigits;
                            }
                        } else {
                            len += precision;
                        }
                    }
                    if ((width -= len) > 0 && !this.hasZeroFlag && !this.hasMinusFlag) {
                        buf.fill(32, width);
                        width = 0;
                    }
                    if (signChar != 0) {
                        buf.append(signChar);
                    }
                    if (width > 0 && !this.hasMinusFlag) {
                        buf.fill(48, width);
                        width = 0;
                    }
                    buf.append(digits[0]);
                    boolean bl2 = dotToPrint = isSharp || precision > 0 && decDigits > 0;
                    if (dotToPrint) {
                        buf.append(decimalSeparator);
                    }
                    if (precision > 0 && decDigits > 0) {
                        buf.append(digits, 1, decDigits);
                        precision -= decDigits;
                    }
                    if (precision > 0 && isSharp) {
                        buf.fill(48, precision);
                    }
                    FormatFloatNode.writeExp(buf, exponent, expChar);
                    if (width <= 0) return buf.bytes();
                    buf.fill(32, width);
                    return buf.bytes();
                }
                int intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                int intZeroes = Math.max(0, exponent);
                int intLength = intDigits + intZeroes;
                int decDigits = nDigits - intDigits;
                int decZeroes = Math.max(0, -(decDigits + exponent));
                int decLength = decZeroes + decDigits;
                if ((precision = Math.max(0, precision - intLength)) < decDigits) {
                    int n = FormatFloatNode.round(digits, nDigits, intDigits + precision - 1, precision != 0);
                    if (n > nDigits) {
                        nDigits = n;
                        intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                        intLength = intDigits + intZeroes;
                        decDigits = nDigits - intDigits;
                        decZeroes = Math.max(0, -(decDigits + exponent));
                        precision = Math.max(0, precision - 1);
                    }
                    decDigits = precision;
                    decLength = decZeroes + decDigits;
                }
                len += intLength;
                if (decLength > 0) {
                    len += decLength + 1;
                } else if (this.hasFSharpFlag) {
                    ++len;
                    if (precision > 0) {
                        len += precision;
                    }
                }
                if ((width -= len) > 0 && !this.hasZeroFlag && !this.hasMinusFlag) {
                    buf.fill(32, width);
                    width = 0;
                }
                if (signChar != 0) {
                    buf.append(signChar);
                }
                if (width > 0 && !this.hasMinusFlag) {
                    buf.fill(48, width);
                    width = 0;
                }
                if (intLength > 0) {
                    if (intDigits > 0) {
                        buf.append(digits, 0, intDigits);
                    }
                    if (intZeroes > 0) {
                        buf.fill(48, intZeroes);
                    }
                } else {
                    buf.append(48);
                }
                if (decLength > 0 || this.hasFSharpFlag) {
                    buf.append(decimalSeparator);
                }
                if (decLength > 0) {
                    if (decZeroes > 0) {
                        buf.fill(48, decZeroes);
                        precision -= decZeroes;
                    }
                    if (decDigits > 0) {
                        buf.append(digits, intDigits, decDigits);
                        precision -= decDigits;
                    }
                    if (this.hasFSharpFlag && precision > 0) {
                        buf.fill(48, precision);
                    }
                }
                if (this.hasFSharpFlag && precision > 0) {
                    buf.fill(48, precision);
                }
                if (width <= 0) return buf.bytes();
                buf.fill(32, width);
                return buf.bytes();
            }
            case 'f': {
                int intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                int intZeroes = Math.max(0, exponent);
                int intLength = intDigits + intZeroes;
                int decDigits = nDigits - intDigits;
                int decZeroes = Math.max(0, -(decDigits + exponent));
                int decLength = decZeroes + decDigits;
                if (precision < decLength) {
                    if (precision < decZeroes) {
                        decDigits = 0;
                        decZeroes = precision;
                    } else {
                        int n = FormatFloatNode.round(digits, nDigits, intDigits + precision - decZeroes - 1, false);
                        if (n > nDigits) {
                            nDigits = n;
                            intDigits = Math.max(0, Math.min(nDigits + exponent, nDigits));
                            intLength = intDigits + intZeroes;
                            decDigits = nDigits - intDigits;
                            decZeroes = Math.max(0, -(decDigits + exponent));
                            decLength = decZeroes + decDigits;
                        }
                        decDigits = precision - decZeroes;
                    }
                    decLength = decZeroes + decDigits;
                }
                if (precision > 0) {
                    len += Math.max(1, intLength) + 1 + precision;
                } else {
                    len += Math.max(1, intLength);
                    if (this.hasFSharpFlag) {
                        ++len;
                    }
                }
                if ((width -= len) > 0 && !this.hasZeroFlag && !this.hasMinusFlag) {
                    buf.fill(32, width);
                    width = 0;
                }
                if (signChar != 0) {
                    buf.append(signChar);
                }
                if (width > 0 && !this.hasMinusFlag) {
                    buf.fill(48, width);
                    width = 0;
                }
                if (intLength > 0) {
                    if (intDigits > 0) {
                        buf.append(digits, 0, intDigits);
                    }
                    if (intZeroes > 0) {
                        buf.fill(48, intZeroes);
                    }
                } else {
                    buf.append(48);
                }
                if (precision > 0 || this.hasFSharpFlag) {
                    buf.append(decimalSeparator);
                }
                if (precision > 0) {
                    if (decZeroes > 0) {
                        buf.fill(48, decZeroes);
                        precision -= decZeroes;
                    }
                    if (decDigits > 0) {
                        buf.append(digits, intDigits, decDigits);
                        precision -= decDigits;
                    }
                    if (precision > 0) {
                        buf.fill(48, precision);
                    }
                }
                if (width <= 0) return buf.bytes();
                buf.fill(32, width);
                return buf.bytes();
            }
            case 'E': 
            case 'e': {
                int decDigits = nDigits - 1;
                if (precision < decDigits) {
                    int n = FormatFloatNode.round(digits, nDigits, precision, precision != 0);
                    if (n > nDigits) {
                        nDigits = n;
                    }
                    decDigits = Math.min(nDigits - 1, precision);
                }
                boolean isSharp = this.hasFSharpFlag;
                ++len;
                len = (exponent += nDigits - 1) > 99 ? (len += 5) : (len += 4);
                if (precision > 0) {
                    len += 1 + precision;
                } else if (isSharp) {
                    ++len;
                }
                if ((width -= len) > 0 && !this.hasZeroFlag && !this.hasMinusFlag) {
                    buf.fill(32, width);
                    width = 0;
                }
                if (signChar != 0) {
                    buf.append(signChar);
                }
                if (width > 0 && !this.hasMinusFlag) {
                    buf.fill(48, width);
                    width = 0;
                }
                buf.append(digits[0]);
                if (precision > 0) {
                    buf.append(decimalSeparator);
                    if (decDigits > 0) {
                        buf.append(digits, 1, decDigits);
                        precision -= decDigits;
                    }
                    if (precision > 0) {
                        buf.fill(48, precision);
                    }
                } else if (this.hasFSharpFlag) {
                    buf.append(decimalSeparator);
                }
                FormatFloatNode.writeExp(buf, exponent, expChar);
                if (width <= 0) return buf.bytes();
                buf.fill(32, width);
                return buf.bytes();
            }
        }
        return buf.bytes();
    }

    private static int round(byte[] bytes, int nDigits, int roundPos, boolean roundDown) {
        int next = roundPos + 1;
        if (next >= nDigits || bytes[next] < 53 || roundDown && bytes[next] == 53 && next == nDigits - 1) {
            return nDigits;
        }
        if (roundPos < 0) {
            System.arraycopy(bytes, 0, bytes, 1, nDigits);
            bytes[0] = 49;
            return nDigits + 1;
        }
        int n = roundPos;
        bytes[n] = (byte)(bytes[n] + 1);
        while (bytes[roundPos] > 57) {
            bytes[roundPos] = 48;
            if (--roundPos >= 0) {
                int n2 = roundPos;
                bytes[n2] = (byte)(bytes[n2] + 1);
                continue;
            }
            System.arraycopy(bytes, 0, bytes, 1, nDigits);
            bytes[0] = 49;
            return nDigits + 1;
        }
        return nDigits;
    }

    private static void writeExp(ByteList buf, int exponent, byte expChar) {
        buf.append(expChar);
        buf.append(exponent >= 0 ? 43 : 45);
        if (exponent < 0) {
            exponent = -exponent;
        }
        if (exponent > 99) {
            buf.append(exponent / 100 + 48);
            buf.append(exponent % 100 / 10 + 48);
        } else {
            buf.append(exponent / 10 + 48);
        }
        buf.append(exponent % 10 + 48);
    }
}

