/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Set;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.objects.ObjectGraph;

@CoreClass(value="Truffle::ObjSpace")
public abstract class ObjSpaceNodes {

    @CoreMethod(names={"trace_allocations_stop"}, isModuleFunction=true)
    public static abstract class TraceAllocationsStopNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject traceAllocationsStop() {
            this.getContext().getObjectSpaceManager().traceAllocationsStop();
            return this.nil();
        }
    }

    @CoreMethod(names={"trace_allocations_start"}, isModuleFunction=true)
    public static abstract class TraceAllocationsStartNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject traceAllocationsStart() {
            this.getContext().getObjectSpaceManager().traceAllocationsStart();
            return this.nil();
        }
    }

    @CoreMethod(names={"root_objects"}, isModuleFunction=true)
    public static abstract class RootObjectsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject rootObjects() {
            Set<DynamicObject> objects = ObjectGraph.stopAndGetRootObjects(this, this.getContext());
            return this.createArray(objects.toArray(), objects.size());
        }
    }

    @CoreMethod(names={"adjacent_objects"}, isModuleFunction=true, required=1)
    public static abstract class AdjacentObjectsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject adjacentObjects(DynamicObject object) {
            Set<DynamicObject> objects = ObjectGraph.getAdjacentObjects(object);
            return this.createArray(objects.toArray(), objects.size());
        }
    }

    @CoreMethod(names={"memsize_of"}, isModuleFunction=true, required=1)
    public static abstract class MemsizeOfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyArray(object)"})
        public int memsizeOfArray(DynamicObject object) {
            return this.memsizeOfObject(object) + Layouts.ARRAY.getSize(object);
        }

        @Specialization(guards={"isRubyHash(object)"})
        public int memsizeOfHash(DynamicObject object) {
            return this.memsizeOfObject(object) + Layouts.HASH.getSize(object);
        }

        @Specialization(guards={"isRubyString(object)"})
        public int memsizeOfString(DynamicObject object) {
            return this.memsizeOfObject(object) + StringOperations.rope(object).byteLength();
        }

        @Specialization(guards={"isRubyMatchData(object)"})
        public int memsizeOfMatchData(DynamicObject object) {
            return this.memsizeOfObject(object) + Layouts.MATCH_DATA.getValues(object).length;
        }

        @Specialization(guards={"!isNil(object)", "!isRubyArray(object)", "!isRubyHash(object)", "!isRubyString(object)", "!isRubyMatchData(object)"})
        public int memsizeOfObject(DynamicObject object) {
            return 1 + object.getShape().getPropertyListInternal(false).size();
        }

        @Specialization(guards={"!isDynamicObject(object)"})
        public int memsize(Object object) {
            return 0;
        }
    }
}

