/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class MediaListImpl
implements MediaList {
    protected final long peer;

    MediaListImpl(long peer) {
        this.peer = peer;
        Disposer.addRecord(this, new SelfDisposer(peer));
    }

    static MediaList create(long peer) {
        if (peer == 0L) {
            return null;
        }
        return new MediaListImpl(peer);
    }

    public boolean equals(Object that) {
        return that instanceof MediaListImpl && this.peer == ((MediaListImpl)that).peer;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    long getPeer() {
        return this.peer;
    }

    static long getPeer(MediaList arg) {
        return arg == null ? 0L : ((MediaListImpl)arg).getPeer();
    }

    private static native void dispose(long var0);

    static MediaList getImpl(long peer) {
        return MediaListImpl.create(peer);
    }

    @Override
    public String getMediaText() {
        return MediaListImpl.getMediaTextImpl(this.getPeer());
    }

    static native String getMediaTextImpl(long var0);

    @Override
    public void setMediaText(String value) throws DOMException {
        MediaListImpl.setMediaTextImpl(this.getPeer(), value);
    }

    static native void setMediaTextImpl(long var0, String var2);

    @Override
    public int getLength() {
        return MediaListImpl.getLengthImpl(this.getPeer());
    }

    static native int getLengthImpl(long var0);

    @Override
    public String item(int index) {
        return MediaListImpl.itemImpl(this.getPeer(), index);
    }

    static native String itemImpl(long var0, int var2);

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        MediaListImpl.deleteMediumImpl(this.getPeer(), oldMedium);
    }

    static native void deleteMediumImpl(long var0, String var2);

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        MediaListImpl.appendMediumImpl(this.getPeer(), newMedium);
    }

    static native void appendMediumImpl(long var0, String var2);

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long peer) {
            this.peer = peer;
        }

        @Override
        public void dispose() {
            MediaListImpl.dispose(this.peer);
        }
    }
}

