/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.daemon.common.FileSystem$WhenMappings;
import org.jetbrains.kotlin.daemon.common.FileSystemUtilsKt;
import org.jetbrains.kotlin.daemon.common.OSKind;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\r\u001a\u00020\u00042\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u000f\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/daemon/common/FileSystem;", "", "()V", "logFilesPath", "", "getLogFilesPath", "()Ljava/lang/String;", "runtimeStateFilesBasePath", "getRuntimeStateFilesBasePath", "tempPath", "getTempPath", "userHomePath", "getUserHomePath", "getRuntimeStateFilesPath", "names", "", "([Ljava/lang/String;)Ljava/lang/String;", "kotlin-compiler"})
public final class FileSystem {
    public static final FileSystem INSTANCE;

    @NotNull
    public final String getUserHomePath() {
        String string = System.getProperty("user.home");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"user.home\")");
        return string;
    }

    @NotNull
    public final String getTempPath() {
        String string = System.getProperty("java.io.tmpdir");
        Intrinsics.checkExpressionValueIsNotNull(string, "System.getProperty(\"java.io.tmpdir\")");
        return string;
    }

    @NotNull
    public final String getLogFilesPath() {
        return this.getTempPath();
    }

    @NotNull
    public final String getRuntimeStateFilesBasePath() {
        String string;
        switch (FileSystem$WhenMappings.$EnumSwitchMapping$0[OSKind.Companion.getCurrent().ordinal()]) {
            case 1: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("LOCALAPPDATA"), this.getTempPath());
                break;
            }
            case 2: {
                string = this.getUserHomePath() + "/Library/Application Support";
                break;
            }
            case 3: {
                string = FileSystemUtilsKt.access$orDefault(System.getenv("XDG_DATA_HOME"), this.getUserHomePath() + "/.local/share");
                break;
            }
            case 4: {
                string = this.getTempPath();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getRuntimeStateFilesPath(String ... names2) {
        String string;
        File dir;
        File file2;
        Object r;
        Iterable $receiver$iv;
        Object accumulator$iv;
        Intrinsics.checkParameterIsNotNull(names2, "names");
        boolean bl = ArraysKt.any((Object[])names2);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        File base = new File(this.getRuntimeStateFilesBasePath());
        if (base.exists() && base.isDirectory()) {
            Object[] objectArray = names2;
            accumulator$iv = base;
            for (int i = 0; i < ((Iterable)$receiver$iv).length; ++i) {
                void v;
                Iterable element$iv = $receiver$iv[i];
                String string3 = (String)((Object)element$iv);
                r = (File)accumulator$iv;
                accumulator$iv = new File((File)r, (String)v);
            }
            file2 = (File)accumulator$iv;
        } else {
            void initial$iv;
            File file3;
            $receiver$iv = ArraysKt.drop((Object[])names2, 1);
            accumulator$iv = ArraysKt.first((Object[])names2);
            String string4 = this.getUserHomePath();
            File file4 = file3;
            File file5 = file3;
            String it = (String)accumulator$iv;
            String string5 = StringsKt.startsWith$default(it, ".", false, 2, null) ? it : "." + it;
            file4(string4, string5);
            accumulator$iv = file5;
            File accumulator$iv2 = initial$iv;
            for (Object element$iv : $receiver$iv) {
                void v;
                r = (String)element$iv;
                File r2 = accumulator$iv2;
                accumulator$iv2 = new File(r2, (String)v);
            }
            file2 = dir = (File)accumulator$iv2;
        }
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            String string6 = dir.getAbsolutePath();
            string = string6;
            Intrinsics.checkExpressionValueIsNotNull(string6, "dir.absolutePath");
        } else {
            string = this.getTempPath();
        }
        return string;
    }

    private FileSystem() {
        INSTANCE = this;
    }

    static {
        new FileSystem();
    }
}

