/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import java.net.URI;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.caching.BuildCache;
import org.gradle.caching.http.internal.HttpBuildCache;
import org.gradle.caching.internal.BuildCacheFactory;

public class HttpBuildCacheFactory
implements BuildCacheFactory {
    private static final String HTTP_URI_PROPERTY = "org.gradle.cache.tasks.http.uri";
    private final URI root;

    public HttpBuildCacheFactory() {
        String uri = System.getProperty(HTTP_URI_PROPERTY);
        if (uri == null) {
            throw new GradleException(String.format("Must specify HTTP cache backend URI via '%s' system property", HTTP_URI_PROPERTY));
        }
        this.root = URI.create(uri);
    }

    public HttpBuildCacheFactory(URI root) {
        this.root = root;
    }

    public BuildCache createCache(StartParameter startParameter) {
        return new HttpBuildCache(this.root);
    }
}

