/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.attributes.DefaultArtifactAttributes;
import org.gradle.api.internal.artifacts.ivyservice.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultResolvedArtifact
implements ResolvedArtifact,
Buildable {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final TaskDependency buildDependencies;
    private final AttributeContainer attributes;
    private Factory<File> artifactSource;
    private File file;

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependency buildDependencies, Factory<File> artifactSource) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = buildDependencies;
        this.artifactSource = artifactSource;
        this.attributes = DefaultArtifactAttributes.forIvyArtifactName(artifact);
    }

    public DefaultResolvedArtifact(ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, TaskDependency buildDependencies, File artifactFile) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.buildDependencies = buildDependencies;
        this.attributes = DefaultArtifactAttributes.forIvyArtifactName(artifact);
        this.file = artifactFile;
    }

    public TaskDependency getBuildDependencies() {
        return this.buildDependencies;
    }

    public ResolvedModuleVersion getModuleVersion() {
        return new DefaultResolvedModuleVersion(this.owner);
    }

    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    public String toString() {
        return this.artifactId.getDisplayName();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultResolvedArtifact other = (DefaultResolvedArtifact)obj;
        return other.owner.equals(this.owner) && other.artifactId.equals(this.artifactId);
    }

    public int hashCode() {
        return this.owner.hashCode() ^ this.artifactId.hashCode();
    }

    public String getName() {
        return this.artifact.getName();
    }

    public String getType() {
        return this.artifact.getType();
    }

    public String getExtension() {
        return this.artifact.getExtension();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    public File getFile() {
        if (this.file == null) {
            this.file = (File)this.artifactSource.create();
            this.artifactSource = null;
        }
        return this.file;
    }
}

