/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.LoggerInfoStream;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DeleteVersionValue;
import org.elasticsearch.index.engine.ElasticsearchConcurrentMergeScheduler;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.EngineSearcherFactory;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.LiveVersionMap;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.engine.VersionValue;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.OnGoingMerge;
import org.elasticsearch.index.shard.ElasticsearchMergePolicy;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.TranslogRecoveryPerformer;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogConfig;
import org.elasticsearch.index.translog.TranslogCorruptedException;

public class InternalEngine
extends Engine {
    private volatile long lastDeleteVersionPruneTimeMSec;
    private final Translog translog;
    private final ElasticsearchConcurrentMergeScheduler mergeScheduler;
    private final IndexWriter indexWriter;
    private final SearcherFactory searcherFactory;
    private final SearcherManager searcherManager;
    private final Lock flushLock;
    private final ReentrantLock optimizeLock;
    private final LiveVersionMap versionMap;
    private final KeyedLock<BytesRef> keyedLock;
    private final AtomicBoolean versionMapRefreshPending;
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final Engine.IndexThrottle throttle;
    private final AtomicInteger throttleRequestCount;
    private final EngineConfig.OpenMode openMode;
    private final AtomicBoolean pendingTranslogRecovery;
    private final AtomicLong maxUnsafeAutoIdTimestamp;
    private final CounterMetric numVersionLookups;
    private final CounterMetric numIndexVersionsLookups;
    private static VersionValueSupplier NEW_VERSION_VALUE = (u, t) -> new VersionValue(u);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InternalEngine(EngineConfig engineConfig) throws EngineException {
        block14: {
            super(engineConfig);
            this.flushLock = new ReentrantLock();
            this.optimizeLock = new ReentrantLock();
            this.keyedLock = new KeyedLock();
            this.versionMapRefreshPending = new AtomicBoolean();
            this.throttleRequestCount = new AtomicInteger();
            this.pendingTranslogRecovery = new AtomicBoolean(false);
            this.maxUnsafeAutoIdTimestamp = new AtomicLong(-1L);
            this.numVersionLookups = new CounterMetric();
            this.numIndexVersionsLookups = new CounterMetric();
            this.openMode = engineConfig.getOpenMode();
            if (engineConfig.getIndexSettings().getIndexVersionCreated().before(Version.V_5_0_0_beta1)) {
                this.maxUnsafeAutoIdTimestamp.set(Long.MAX_VALUE);
            } else {
                this.maxUnsafeAutoIdTimestamp.set(engineConfig.getMaxUnsafeAutoIdTimestamp());
            }
            this.versionMap = new LiveVersionMap();
            this.store.incRef();
            IndexWriter writer = null;
            Translog translog = null;
            SearcherManager manager = null;
            EngineMergeScheduler scheduler = null;
            boolean success = false;
            try {
                this.lastDeleteVersionPruneTimeMSec = engineConfig.getThreadPool().estimatedTimeInMillis();
                scheduler = new EngineMergeScheduler(engineConfig.getShardId(), engineConfig.getIndexSettings());
                this.mergeScheduler = scheduler;
                this.throttle = new Engine.IndexThrottle();
                this.searcherFactory = new SearchFactory(this.logger, this.isClosed, engineConfig);
                try {
                    this.indexWriter = writer = this.createWriter(this.openMode == EngineConfig.OpenMode.CREATE_INDEX_AND_TRANSLOG);
                    translog = this.openTranslog(engineConfig, writer);
                    assert (translog.getGeneration() != null);
                }
                catch (IOException | TranslogCorruptedException e) {
                    throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
                }
                catch (AssertionError e) {
                    if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.lucene.index.IndexWriter.filesExist")) {
                        throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)((Object)e));
                    }
                    throw e;
                }
                this.translog = translog;
                this.searcherManager = manager = this.createSearcherManager();
                this.versionMap.setManager((ReferenceManager<?>)this.searcherManager);
                assert (!this.pendingTranslogRecovery.get()) : "translog recovery can't be pending before we set it";
                this.pendingTranslogRecovery.set(this.openMode == EngineConfig.OpenMode.OPEN_INDEX_AND_TRANSLOG);
                if (engineConfig.getRefreshListeners() != null) {
                    this.searcherManager.addListener(engineConfig.getRefreshListeners());
                }
                if (success = true) break block14;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, manager, scheduler});
                    this.versionMap.clear();
                    if (!this.isClosed.get()) {
                        this.store.decRef();
                    }
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{writer, translog, manager, scheduler});
            this.versionMap.clear();
            if (!this.isClosed.get()) {
                this.store.decRef();
            }
        }
        this.logger.trace("created new InternalEngine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalEngine recoverFromTranslog() throws IOException {
        this.flushLock.lock();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (this.openMode != EngineConfig.OpenMode.OPEN_INDEX_AND_TRANSLOG) {
                throw new IllegalStateException("Can't recover from translog with open mode: " + (Object)((Object)this.openMode));
            }
            if (!this.pendingTranslogRecovery.get()) {
                throw new IllegalStateException("Engine has already been recovered");
            }
            try {
                this.recoverFromTranslog(this.engineConfig.getTranslogRecoveryPerformer());
            }
            catch (Exception e) {
                try {
                    this.pendingTranslogRecovery.set(true);
                    this.failEngine("failed to recover from translog", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
        }
        finally {
            this.flushLock.unlock();
        }
        return this;
    }

    private void recoverFromTranslog(TranslogRecoveryPerformer handler) throws IOException {
        int opsRecovered;
        Translog.TranslogGeneration translogGeneration = this.translog.getGeneration();
        try {
            Translog.Snapshot snapshot = this.translog.newSnapshot();
            opsRecovered = handler.recoveryFromSnapshot(this, snapshot);
        }
        catch (Exception e) {
            throw new EngineException(this.shardId, "failed to recover from translog", e, new Object[0]);
        }
        assert (this.pendingTranslogRecovery.get()) : "translogRecovery is not pending but should be";
        this.pendingTranslogRecovery.set(false);
        if (opsRecovered > 0) {
            this.logger.trace("flushing post recovery from translog. ops recovered [{}]. committed translog id [{}]. current id [{}]", (Object)opsRecovered, (Object)(translogGeneration == null ? null : Long.valueOf(translogGeneration.translogFileGeneration)), (Object)this.translog.currentFileGeneration());
            this.flush(true, true);
        } else if (!this.translog.isCurrent(translogGeneration)) {
            this.commitIndexWriter(this.indexWriter, this.translog, (String)this.lastCommittedSegmentInfos.getUserData().get("sync_id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Translog openTranslog(EngineConfig engineConfig, IndexWriter writer) throws IOException {
        TranslogConfig translogConfig = engineConfig.getTranslogConfig();
        Translog.TranslogGeneration generation = null;
        if (this.openMode == EngineConfig.OpenMode.OPEN_INDEX_AND_TRANSLOG) {
            generation = this.loadTranslogIdFromCommit(writer);
            if (generation == null) {
                throw new IllegalStateException("no translog generation present in commit data but translog is expected to exist");
            }
            if (generation != null && generation.translogUUID == null) {
                throw new IndexFormatTooOldException("trasnlog", "translog has no generation nor a UUID - this might be an index from a previous version consider upgrading to N-1 first");
            }
        }
        Translog translog = new Translog(translogConfig, generation);
        if (generation != null && generation.translogUUID != null) return translog;
        assert (this.openMode != EngineConfig.OpenMode.OPEN_INDEX_AND_TRANSLOG) : "OpenMode must not be " + (Object)((Object)EngineConfig.OpenMode.OPEN_INDEX_AND_TRANSLOG);
        if (generation == null) {
            this.logger.debug("no translog ID present in the current generation - creating one");
        } else if (generation.translogUUID == null) {
            this.logger.debug("upgraded translog to pre 2.0 format, associating translog with index - writing translog UUID");
        }
        boolean success = false;
        try {
            this.commitIndexWriter(writer, translog, this.openMode == EngineConfig.OpenMode.OPEN_INDEX_CREATE_TRANSLOG ? (String)writer.getCommitData().get("sync_id") : null);
            return translog;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{translog});
            throw throwable;
        }
    }

    @Override
    public Translog getTranslog() {
        this.ensureOpen();
        return this.translog;
    }

    @Nullable
    private Translog.TranslogGeneration loadTranslogIdFromCommit(IndexWriter writer) throws IOException {
        Map commitUserData = writer.getCommitData();
        if (commitUserData.containsKey("translog_id")) {
            assert (!commitUserData.containsKey("translog_uuid")) : "legacy commit contains translog UUID";
            return new Translog.TranslogGeneration(null, Long.parseLong((String)commitUserData.get("translog_id")));
        }
        if (commitUserData.containsKey("translog_generation")) {
            if (!commitUserData.containsKey("translog_uuid")) {
                throw new IllegalStateException("commit doesn't contain translog UUID");
            }
            String translogUUID = (String)commitUserData.get("translog_uuid");
            long translogGen = Long.parseLong((String)commitUserData.get("translog_generation"));
            return new Translog.TranslogGeneration(translogUUID, translogGen);
        }
        return null;
    }

    private SearcherManager createSearcherManager() throws EngineException {
        SearcherManager searcherManager;
        block7: {
            boolean success = false;
            SearcherManager searcherManager2 = null;
            try {
                ElasticsearchDirectoryReader directoryReader = ElasticsearchDirectoryReader.wrap(DirectoryReader.open((IndexWriter)this.indexWriter), this.shardId);
                searcherManager2 = new SearcherManager((DirectoryReader)directoryReader, this.searcherFactory);
                this.lastCommittedSegmentInfos = InternalEngine.readLastCommittedSegmentInfos(searcherManager2, this.store);
                success = true;
                searcherManager = searcherManager2;
                if (success) break block7;
            }
            catch (IOException e) {
                try {
                    this.maybeFailEngine("start", e);
                    try {
                        this.indexWriter.rollback();
                    }
                    catch (IOException inner) {
                        e.addSuppressed(inner);
                    }
                    throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", e);
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searcherManager2, this.indexWriter});
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{searcherManager2, this.indexWriter});
        }
        return searcherManager;
    }

    @Override
    public Engine.GetResult get(Engine.Get get, Function<String, Engine.Searcher> searcherFactory) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            VersionValue versionValue;
            this.ensureOpen();
            if (get.realtime() && (versionValue = this.versionMap.getUnderLock(get.uid())) != null) {
                if (versionValue.delete()) {
                    Engine.GetResult getResult = Engine.GetResult.NOT_EXISTS;
                    return getResult;
                }
                if (get.versionType().isVersionConflictForReads(versionValue.version(), get.version())) {
                    Uid uid = Uid.createUid(get.uid().text());
                    throw new VersionConflictEngineException(this.shardId, uid.type(), uid.id(), get.versionType().explainConflictForReads(versionValue.version(), get.version()));
                }
                this.refresh("realtime_get");
            }
            Engine.GetResult getResult = this.getFromSearcher(get, searcherFactory);
            return getResult;
        }
    }

    private boolean checkVersionConflict(Engine.Operation op, long currentVersion, long expectedVersion, boolean deleted) {
        if (op.versionType().isVersionConflictForWrites(currentVersion, expectedVersion, deleted)) {
            if (op.origin().isRecovery()) {
                return true;
            }
            throw new VersionConflictEngineException(this.shardId, op.type(), op.id(), op.versionType().explainConflictForWrites(currentVersion, expectedVersion, deleted));
        }
        return false;
    }

    private long checkDeletedAndGCed(VersionValue versionValue) {
        long currentVersion = this.engineConfig.isEnableGcDeletes() && versionValue.delete() && this.engineConfig.getThreadPool().estimatedTimeInMillis() - versionValue.time() > this.getGcDeletesInMillis() ? -1L : versionValue.version();
        return currentVersion;
    }

    private <T extends Engine.Operation> void maybeAddToTranslog(T op, long updatedVersion, Function<T, Translog.Operation> toTranslogOp, VersionValueSupplier toVersionValue) throws IOException {
        if (op.origin() != Engine.Operation.Origin.LOCAL_TRANSLOG_RECOVERY) {
            Translog.Location translogLocation = this.translog.add(toTranslogOp.apply(op));
            op.setTranslogLocation(translogLocation);
        }
        this.versionMap.putUnderLock(op.uid().bytes(), toVersionValue.apply(updatedVersion, this.engineConfig.getThreadPool().estimatedTimeInMillis()));
    }

    @Override
    public void index(Engine.Index index) {
        block29: {
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                if (index.origin().isRecovery()) {
                    this.innerIndex(index);
                    break block29;
                }
                try (Releasable r = this.throttle.acquireThrottle();){
                    this.innerIndex(index);
                }
            }
            catch (IOException | IllegalStateException e) {
                try {
                    this.maybeFailEngine("index", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new IndexFailedEngineException(this.shardId, index.type(), index.id(), e);
            }
        }
    }

    private boolean canOptimizeAddDocument(Engine.Index index) {
        if (index.getAutoGeneratedIdTimestamp() != -1L) {
            assert (index.getAutoGeneratedIdTimestamp() >= 0L) : "autoGeneratedIdTimestamp must be positive but was: " + index.getAutoGeneratedIdTimestamp();
            switch (index.origin()) {
                case PRIMARY: {
                    assert (index.version() == -3L && index.versionType() == VersionType.INTERNAL) : "version: " + index.version() + " type: " + index.versionType();
                    return true;
                }
                case PEER_RECOVERY: 
                case REPLICA: {
                    assert (index.version() == 1L && index.versionType() == VersionType.EXTERNAL) : "version: " + index.version() + " type: " + index.versionType();
                    return true;
                }
                case LOCAL_TRANSLOG_RECOVERY: {
                    assert (index.isRetry());
                    return false;
                }
            }
            throw new IllegalArgumentException("unknown origin " + (Object)((Object)index.origin()));
        }
        return false;
    }

    private void innerIndex(Engine.Index index) throws IOException {
        try (Releasable ignored = this.acquireLock(index.uid());){
            boolean deleted;
            long currentVersion;
            boolean forceUpdateDocument;
            this.lastWriteNanos = index.startTime();
            boolean canOptimizeAddDocument = this.canOptimizeAddDocument(index);
            if (canOptimizeAddDocument) {
                long deOptimizeTimestamp = this.maxUnsafeAutoIdTimestamp.get();
                if (index.isRetry()) {
                    forceUpdateDocument = true;
                    while ((deOptimizeTimestamp = this.maxUnsafeAutoIdTimestamp.get()) < index.getAutoGeneratedIdTimestamp() && !this.maxUnsafeAutoIdTimestamp.compareAndSet(deOptimizeTimestamp, index.getAutoGeneratedIdTimestamp())) {
                    }
                    assert (this.maxUnsafeAutoIdTimestamp.get() >= index.getAutoGeneratedIdTimestamp());
                } else {
                    forceUpdateDocument = deOptimizeTimestamp >= index.getAutoGeneratedIdTimestamp();
                }
                currentVersion = -1L;
                deleted = true;
            } else {
                forceUpdateDocument = false;
                VersionValue versionValue = this.versionMap.getUnderLock(index.uid());
                assert (this.incrementVersionLookup());
                if (versionValue == null) {
                    currentVersion = this.loadCurrentVersionFromIndex(index.uid());
                    deleted = currentVersion == -1L;
                } else {
                    currentVersion = this.checkDeletedAndGCed(versionValue);
                    deleted = versionValue.delete();
                }
            }
            long expectedVersion = index.version();
            if (this.checkVersionConflict(index, currentVersion, expectedVersion, deleted)) {
                index.setCreated(false);
                return;
            }
            long updatedVersion = this.updateVersion(index, currentVersion, expectedVersion);
            index.setCreated(deleted);
            if (currentVersion == -1L && !forceUpdateDocument) {
                assert (this.assertDocDoesNotExist(index, !canOptimizeAddDocument));
                InternalEngine.index(index, this.indexWriter);
            } else {
                InternalEngine.update(index, this.indexWriter);
            }
            this.maybeAddToTranslog(index, updatedVersion, Translog.Index::new, NEW_VERSION_VALUE);
        }
    }

    private boolean assertDocDoesNotExist(Engine.Index index, boolean allowDeleted) throws IOException {
        VersionValue versionValue = this.versionMap.getUnderLock(index.uid());
        if (versionValue != null) {
            if (!versionValue.delete() || !allowDeleted) {
                throw new AssertionError((Object)("doc [" + index.type() + "][" + index.id() + "] exists in version map (version " + versionValue + ")"));
            }
        } else {
            try (Engine.Searcher searcher = this.acquireSearcher("assert doc doesn't exist");){
                long docsWithId = searcher.searcher().count((Query)new TermQuery(index.uid()));
                if (docsWithId > 0L) {
                    throw new AssertionError((Object)("doc [" + index.type() + "][" + index.id() + "] exists [" + docsWithId + "] times in index"));
                }
            }
        }
        return true;
    }

    private long updateVersion(Engine.Operation op, long currentVersion, long expectedVersion) {
        long updatedVersion = op.versionType().updateVersion(currentVersion, expectedVersion);
        op.updateVersion(updatedVersion);
        return updatedVersion;
    }

    private static void index(Engine.Index index, IndexWriter indexWriter) throws IOException {
        if (index.docs().size() > 1) {
            indexWriter.addDocuments(index.docs());
        } else {
            indexWriter.addDocument((Iterable)index.docs().get(0));
        }
    }

    private static void update(Engine.Index index, IndexWriter indexWriter) throws IOException {
        if (index.docs().size() > 1) {
            indexWriter.updateDocuments(index.uid(), index.docs());
        } else {
            indexWriter.updateDocument(index.uid(), (Iterable)index.docs().get(0));
        }
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.innerDelete(delete);
        }
        catch (IOException | IllegalStateException e) {
            try {
                this.maybeFailEngine("delete", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new DeleteFailedEngineException(this.shardId, delete, e);
        }
        this.maybePruneDeletedTombstones();
    }

    private void maybePruneDeletedTombstones() {
        if (this.engineConfig.isEnableGcDeletes() && (double)(this.engineConfig.getThreadPool().estimatedTimeInMillis() - this.lastDeleteVersionPruneTimeMSec) > (double)this.getGcDeletesInMillis() * 0.25) {
            this.pruneDeletedTombstones();
        }
    }

    private void innerDelete(Engine.Delete delete) throws IOException {
        try (Releasable ignored = this.acquireLock(delete.uid());){
            boolean deleted;
            long currentVersion;
            this.lastWriteNanos = delete.startTime();
            VersionValue versionValue = this.versionMap.getUnderLock(delete.uid());
            assert (this.incrementVersionLookup());
            if (versionValue == null) {
                currentVersion = this.loadCurrentVersionFromIndex(delete.uid());
                deleted = currentVersion == -1L;
            } else {
                currentVersion = this.checkDeletedAndGCed(versionValue);
                deleted = versionValue.delete();
            }
            long expectedVersion = delete.version();
            if (this.checkVersionConflict(delete, currentVersion, expectedVersion, deleted)) {
                return;
            }
            long updatedVersion = this.updateVersion(delete, currentVersion, expectedVersion);
            boolean found = this.deleteIfFound(delete, currentVersion, deleted, versionValue);
            delete.updateVersion(updatedVersion, found);
            this.maybeAddToTranslog(delete, updatedVersion, Translog.Delete::new, DeleteVersionValue::new);
        }
    }

    private boolean deleteIfFound(Engine.Delete delete, long currentVersion, boolean deleted, VersionValue versionValue) throws IOException {
        boolean found;
        if (currentVersion == -1L) {
            found = false;
        } else if (versionValue != null && deleted) {
            found = false;
        } else {
            this.indexWriter.deleteDocuments(new Term[]{delete.uid()});
            found = true;
        }
        return found;
    }

    @Override
    public void refresh(String source) throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.searcherManager.maybeRefreshBlocking();
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (EngineClosedException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("refresh failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
        }
        this.maybePruneDeletedTombstones();
        this.versionMapRefreshPending.set(false);
        this.mergeScheduler.refreshConfig();
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean useRefresh;
            this.ensureOpen();
            long versionMapBytes = this.versionMap.ramBytesUsedForRefresh();
            long indexingBufferBytes = this.indexWriter.ramBytesUsed();
            boolean bl = useRefresh = this.versionMapRefreshPending.get() || indexingBufferBytes / 4L < versionMapBytes;
            if (useRefresh) {
                this.logger.debug("use refresh to write indexing buffer (heap size=[{}]), to also clear version map (heap size=[{}])", (Object)new ByteSizeValue(indexingBufferBytes), (Object)new ByteSizeValue(versionMapBytes));
                this.refresh("write indexing buffer");
            } else {
                this.logger.debug("use IndexWriter.flush to write indexing buffer (heap size=[{}]) since version map is small (heap size=[{}])", (Object)new ByteSizeValue(indexingBufferBytes), (Object)new ByteSizeValue(versionMapBytes));
                this.indexWriter.flush();
            }
        }
        catch (AlreadyClosedException e) {
            this.failOnTragicEvent(e);
            throw e;
        }
        catch (EngineClosedException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                this.failEngine("writeIndexingBuffer failed", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.SyncedFlushResult syncFlush(String syncId, Engine.CommitId expectedCommitId) throws EngineException {
        this.ensureOpen();
        if (this.indexWriter.hasUncommittedChanges()) {
            this.logger.trace("can't sync commit [{}]. have pending changes", (Object)syncId);
            return Engine.SyncedFlushResult.PENDING_OPERATIONS;
        }
        if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
            this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", (Object)syncId);
            return Engine.SyncedFlushResult.COMMIT_MISMATCH;
        }
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            this.ensureCanFlush();
            if (this.indexWriter.hasUncommittedChanges()) {
                this.logger.trace("can't sync commit [{}]. have pending changes", (Object)syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.PENDING_OPERATIONS;
                return syncedFlushResult;
            }
            if (!expectedCommitId.idsEqual(this.lastCommittedSegmentInfos.getId())) {
                this.logger.trace("can't sync commit [{}]. current commit id is not equal to expected.", (Object)syncId);
                Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.COMMIT_MISMATCH;
                return syncedFlushResult;
            }
            this.logger.trace("starting sync commit [{}]", (Object)syncId);
            this.commitIndexWriter(this.indexWriter, this.translog, syncId);
            this.logger.debug("successfully sync committed. sync id [{}].", (Object)syncId);
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            Engine.SyncedFlushResult syncedFlushResult = Engine.SyncedFlushResult.SUCCESS;
            return syncedFlushResult;
        }
        catch (IOException ex) {
            this.maybeFailEngine("sync commit", ex);
            throw new EngineException(this.shardId, "failed to sync commit", ex, new Object[0]);
        }
    }

    final boolean tryRenewSyncCommit() {
        boolean renewed = false;
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            this.ensureCanFlush();
            String syncId = (String)this.lastCommittedSegmentInfos.getUserData().get("sync_id");
            if (syncId != null && this.translog.totalOperations() == 0 && this.indexWriter.hasUncommittedChanges()) {
                this.logger.trace("start renewing sync commit [{}]", (Object)syncId);
                this.commitIndexWriter(this.indexWriter, this.translog, syncId);
                this.logger.debug("successfully sync committed. sync id [{}].", (Object)syncId);
                this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                renewed = true;
            }
        }
        catch (IOException ex) {
            this.maybeFailEngine("renew sync commit", ex);
            throw new EngineException(this.shardId, "failed to renew sync commit", ex, new Object[0]);
        }
        if (renewed) {
            this.refresh("renew sync commit");
        }
        return renewed;
    }

    @Override
    public Engine.CommitId flush() throws EngineException {
        return this.flush(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Engine.CommitId flush(boolean force, boolean waitIfOngoing) throws EngineException {
        byte[] newCommitId;
        this.ensureOpen();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.flushLock.tryLock()) {
                if (!waitIfOngoing) {
                    Engine.CommitId commitId = new Engine.CommitId(this.lastCommittedSegmentInfos.getId());
                    return commitId;
                }
                this.logger.trace("waiting for in-flight flush to finish");
                this.flushLock.lock();
                this.logger.trace("acquired flush lock after blocking");
            } else {
                this.logger.trace("acquired flush lock immediately");
            }
            try {
                block34: {
                    if (this.indexWriter.hasUncommittedChanges() || force) {
                        this.ensureCanFlush();
                        try {
                            this.translog.prepareCommit();
                            this.logger.trace("starting commit for flush; commitTranslog=true");
                            this.commitIndexWriter(this.indexWriter, this.translog, null);
                            this.logger.trace("finished commit for flush");
                            this.refresh("version_table_flush");
                            this.translog.commit();
                        }
                        catch (Exception e) {
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        this.store.incRef();
                        try {
                            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
                        }
                        catch (Exception e) {
                            if (this.isClosed.get()) break block34;
                            try {
                                this.logger.warn("failed to read latest segment infos on flush", (Throwable)e);
                            }
                            catch (Exception inner) {
                                e.addSuppressed(inner);
                            }
                            if (Lucene.isCorruptionException(e)) {
                                throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                            }
                        }
                        finally {
                            this.store.decRef();
                        }
                    }
                }
                newCommitId = this.lastCommittedSegmentInfos.getId();
            }
            catch (FlushFailedEngineException ex) {
                this.maybeFailEngine("flush", ex);
                throw ex;
            }
            finally {
                this.flushLock.unlock();
            }
        }
        if (!this.engineConfig.isEnableGcDeletes()) return new Engine.CommitId(newCommitId);
        this.pruneDeletedTombstones();
        return new Engine.CommitId(newCommitId);
    }

    private void pruneDeletedTombstones() {
        long timeMSec = this.engineConfig.getThreadPool().estimatedTimeInMillis();
        for (Map.Entry<BytesRef, VersionValue> entry : this.versionMap.getAllTombstones()) {
            BytesRef uid = entry.getKey();
            Releasable ignored = this.acquireLock(uid);
            Throwable throwable = null;
            try {
                VersionValue versionValue = this.versionMap.getTombstoneUnderLock(uid);
                if (versionValue == null || timeMSec - versionValue.time() <= this.getGcDeletesInMillis()) continue;
                this.versionMap.removeTombstoneUnderLock(uid);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        this.lastDeleteVersionPruneTimeMSec = timeMSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments) throws EngineException, EngineClosedException, IOException {
        assert (this.indexWriter.getConfig().getMergePolicy() instanceof ElasticsearchMergePolicy) : "MergePolicy is " + this.indexWriter.getConfig().getMergePolicy().getClass().getName();
        ElasticsearchMergePolicy mp = (ElasticsearchMergePolicy)this.indexWriter.getConfig().getMergePolicy();
        this.optimizeLock.lock();
        try {
            this.ensureOpen();
            if (upgrade) {
                this.logger.info("starting segment upgrade upgradeOnlyAncientSegments={}", (Object)upgradeOnlyAncientSegments);
                mp.setUpgradeInProgress(true, upgradeOnlyAncientSegments);
            }
            this.store.incRef();
            try {
                if (onlyExpungeDeletes) {
                    assert (!upgrade);
                    this.indexWriter.forceMergeDeletes(true);
                } else if (maxNumSegments <= 0) {
                    assert (!upgrade);
                    this.indexWriter.maybeMerge();
                } else {
                    this.indexWriter.forceMerge(maxNumSegments, true);
                }
                if (flush && !this.tryRenewSyncCommit()) {
                    this.flush(false, true);
                }
                if (upgrade) {
                    this.logger.info("finished segment upgrade");
                }
            }
            finally {
                this.store.decRef();
            }
        }
        catch (AlreadyClosedException ex) {
            this.ensureOpen();
            this.failOnTragicEvent(ex);
            throw ex;
        }
        catch (Exception e) {
            try {
                this.maybeFailEngine("force merge", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw e;
        }
        finally {
            try {
                mp.setUpgradeInProgress(false, false);
            }
            finally {
                this.optimizeLock.unlock();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexCommit acquireIndexCommit(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.logger.trace("start flush for snapshot");
            this.flush(false, true);
            this.logger.trace("finish flush for snapshot");
        }
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            this.logger.trace("pulling snapshot");
            IndexCommit indexCommit = this.deletionPolicy.snapshot();
            return indexCommit;
        }
        catch (IOException e) {
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
    }

    private void failOnTragicEvent(AlreadyClosedException ex) {
        if (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() != null) {
            if (this.indexWriter.getTragicException() instanceof Error) {
                try {
                    this.logger.error("tragic event in index writer", (Throwable)ex);
                }
                finally {
                    throw (Error)this.indexWriter.getTragicException();
                }
            }
            this.failEngine("already closed by tragic event on the index writer", (Exception)this.indexWriter.getTragicException());
        } else if (!this.translog.isOpen() && this.translog.getTragicException() != null) {
            this.failEngine("already closed by tragic event on the translog", this.translog.getTragicException());
        } else if (this.failedEngine.get() == null) {
            throw new AssertionError("Unexpected AlreadyClosedException", ex);
        }
    }

    @Override
    protected boolean maybeFailEngine(String source, Exception e) {
        boolean shouldFail = super.maybeFailEngine(source, e);
        if (shouldFail) {
            return true;
        }
        if (e instanceof AlreadyClosedException) {
            this.failOnTragicEvent((AlreadyClosedException)((Object)e));
            return true;
        }
        if (e != null && (!this.indexWriter.isOpen() && this.indexWriter.getTragicException() == e || !this.translog.isOpen() && this.translog.getTragicException() == e)) {
            this.failEngine(source, e);
            return true;
        }
        return false;
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected final void writerSegmentStats(SegmentsStats stats) {
        stats.addVersionMapMemoryInBytes(this.versionMap.ramBytesUsed());
        stats.addIndexWriterMemoryInBytes(this.indexWriter.ramBytesUsed());
        stats.updateMaxUnsafeAutoIdTimestamp(this.maxUnsafeAutoIdTimestamp.get());
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return this.indexWriter.ramBytesUsed() + this.versionMap.ramBytesUsedForRefresh();
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        try (ReleasableLock lock = this.readLock.acquire();){
            Segment[] segmentsArr = this.getSegmentInfo(this.lastCommittedSegmentInfos, verbose);
            Set<OnGoingMerge> onGoingMerges = this.mergeScheduler.onGoingMerges();
            for (OnGoingMerge onGoingMerge : onGoingMerges) {
                block10: for (SegmentCommitInfo segmentInfoPerCommit : onGoingMerge.getMergedSegments()) {
                    for (Segment segment : segmentsArr) {
                        if (!segment.getName().equals(segmentInfoPerCommit.info.name)) continue;
                        segment.mergeId = onGoingMerge.getId();
                        continue block10;
                    }
                }
            }
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
    }

    @Override
    protected final void closeNoLock(String reason) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                this.versionMap.clear();
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.searcherManager});
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close SearcherManager", (Throwable)e);
                }
                try {
                    IOUtils.close((Closeable[])new Closeable[]{this.translog});
                }
                catch (Exception e) {
                    this.logger.warn("Failed to close translog", (Throwable)e);
                }
                this.logger.trace("rollback indexWriter");
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException ex) {
                    this.failOnTragicEvent(ex);
                    throw ex;
                }
                this.logger.trace("rollback indexWriter done");
            }
            catch (Exception e) {
                this.logger.warn("failed to rollback writer on close", (Throwable)e);
            }
            finally {
                this.store.decRef();
                this.logger.debug("engine closed [{}]", (Object)reason);
            }
        }
    }

    @Override
    protected SearcherManager getSearcherManager() {
        return this.searcherManager;
    }

    private Releasable acquireLock(BytesRef uid) {
        return this.keyedLock.acquire(uid);
    }

    private Releasable acquireLock(Term uid) {
        return this.acquireLock(uid.bytes());
    }

    private long loadCurrentVersionFromIndex(Term uid) throws IOException {
        assert (this.incrementIndexVersionLookup());
        try (Engine.Searcher searcher = this.acquireSearcher("load_version");){
            long l = Versions.loadVersion(searcher.reader(), uid);
            return l;
        }
    }

    private IndexWriter createWriter(boolean create) throws IOException {
        try {
            IndexWriterConfig iwc = new IndexWriterConfig(this.engineConfig.getAnalyzer());
            iwc.setCommitOnClose(false);
            iwc.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            iwc.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            boolean verbose = false;
            try {
                verbose = Boolean.parseBoolean(System.getProperty("tests.verbose"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            iwc.setInfoStream((InfoStream)(verbose ? InfoStream.getDefault() : new LoggerInfoStream(this.logger)));
            iwc.setMergeScheduler((MergeScheduler)this.mergeScheduler);
            MergePolicy mergePolicy = this.config().getMergePolicy();
            mergePolicy = new ElasticsearchMergePolicy(mergePolicy);
            iwc.setMergePolicy(mergePolicy);
            iwc.setSimilarity(this.engineConfig.getSimilarity());
            iwc.setRAMBufferSizeMB(this.engineConfig.getIndexingBufferSize().getMbFrac());
            iwc.setCodec(this.engineConfig.getCodec());
            iwc.setUseCompoundFile(true);
            return new IndexWriter(this.store.directory(), iwc);
        }
        catch (LockObtainFailedException ex) {
            this.logger.warn("could not lock IndexWriter", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void activateThrottling() {
        int count = this.throttleRequestCount.incrementAndGet();
        assert (count >= 1) : "invalid post-increment throttleRequestCount=" + count;
        if (count == 1) {
            this.throttle.activate();
        }
    }

    @Override
    public void deactivateThrottling() {
        int count = this.throttleRequestCount.decrementAndGet();
        assert (count >= 0) : "invalid post-decrement throttleRequestCount=" + count;
        if (count == 0) {
            this.throttle.deactivate();
        }
    }

    @Override
    public boolean isThrottled() {
        return this.throttle.isThrottled();
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return this.throttle.getThrottleTimeInMillis();
    }

    long getGcDeletesInMillis() {
        return this.engineConfig.getIndexSettings().getGcDeletesInMillis();
    }

    LiveIndexWriterConfig getCurrentIndexWriterConfig() {
        return this.indexWriter.getConfig();
    }

    private void commitIndexWriter(IndexWriter writer, Translog translog, String syncId) throws IOException {
        this.ensureCanFlush();
        try {
            Translog.TranslogGeneration translogGeneration = translog.getGeneration();
            this.logger.trace("committing writer with translog id [{}]  and sync id [{}] ", (Object)translogGeneration.translogFileGeneration, (Object)syncId);
            HashMap<String, String> commitData = new HashMap<String, String>(2);
            commitData.put("translog_generation", Long.toString(translogGeneration.translogFileGeneration));
            commitData.put("translog_uuid", translogGeneration.translogUUID);
            if (syncId != null) {
                commitData.put("sync_id", syncId);
            }
            this.indexWriter.setCommitData(commitData);
            writer.commit();
        }
        catch (Exception ex) {
            try {
                this.failEngine("lucene commit failed", ex);
            }
            catch (Exception inner) {
                ex.addSuppressed(inner);
            }
            throw ex;
        }
        catch (AssertionError e) {
            if (ExceptionsHelper.stackTrace((Throwable)((Object)e)).contains("org.apache.lucene.index.IndexWriter.filesExist")) {
                EngineException engineException = new EngineException(this.shardId, "failed to commit engine", (Throwable)((Object)e), new Object[0]);
                try {
                    this.failEngine("lucene commit failed", engineException);
                }
                catch (Exception inner) {
                    engineException.addSuppressed(inner);
                }
                throw engineException;
            }
            throw e;
        }
    }

    private void ensureCanFlush() {
        if (this.pendingTranslogRecovery.get()) {
            throw new IllegalStateException(this.shardId.toString() + " flushes are disabled - pending translog recovery");
        }
    }

    @Override
    public void onSettingsChanged() {
        this.mergeScheduler.refreshConfig();
        this.maybePruneDeletedTombstones();
        if (this.engineConfig.getMaxUnsafeAutoIdTimestamp() == Long.MAX_VALUE) {
            this.maxUnsafeAutoIdTimestamp.set(Long.MAX_VALUE);
        }
    }

    @Override
    public MergeStats getMergeStats() {
        return this.mergeScheduler.stats();
    }

    long getNumIndexVersionsLookups() {
        return this.numIndexVersionsLookups.count();
    }

    long getNumVersionLookups() {
        return this.numVersionLookups.count();
    }

    private boolean incrementVersionLookup() {
        this.numVersionLookups.inc();
        return true;
    }

    private boolean incrementIndexVersionLookup() {
        this.numIndexVersionsLookups.inc();
        return true;
    }

    boolean indexWriterHasDeletions() {
        return this.indexWriter.hasDeletions();
    }

    @Override
    public boolean isRecovering() {
        return this.pendingTranslogRecovery.get();
    }

    private final class EngineMergeScheduler
    extends ElasticsearchConcurrentMergeScheduler {
        private final AtomicInteger numMergesInFlight;
        private final AtomicBoolean isThrottling;

        EngineMergeScheduler(ShardId shardId, IndexSettings indexSettings) {
            super(shardId, indexSettings);
            this.numMergesInFlight = new AtomicInteger(0);
            this.isThrottling = new AtomicBoolean();
        }

        @Override
        public synchronized void beforeMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.incrementAndGet() > maxNumMerges && !this.isThrottling.getAndSet(true)) {
                this.logger.info("now throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.activateThrottling();
            }
        }

        @Override
        public synchronized void afterMerge(OnGoingMerge merge) {
            int maxNumMerges = InternalEngine.this.mergeScheduler.getMaxMergeCount();
            if (this.numMergesInFlight.decrementAndGet() < maxNumMerges && this.isThrottling.getAndSet(false)) {
                this.logger.info("stop throttling indexing: numMergesInFlight={}, maxNumMerges={}", (Object)this.numMergesInFlight, (Object)maxNumMerges);
                InternalEngine.this.deactivateThrottling();
            }
            if (!InternalEngine.this.indexWriter.hasPendingMerges() && System.nanoTime() - InternalEngine.this.lastWriteNanos >= InternalEngine.this.engineConfig.getFlushMergesAfter().nanos()) {
                InternalEngine.this.engineConfig.getThreadPool().executor("flush").execute(new AbstractRunnable(){

                    @Override
                    public void onFailure(Exception e) {
                        if (!InternalEngine.this.isClosed.get()) {
                            EngineMergeScheduler.this.logger.warn("failed to flush after merge has finished");
                        }
                    }

                    @Override
                    protected void doRun() throws Exception {
                        if (!InternalEngine.this.tryRenewSyncCommit()) {
                            InternalEngine.this.flush();
                        }
                    }
                });
            }
        }

        protected void handleMergeException(final Directory dir, final Throwable exc) {
            this.logger.error("failed to merge", exc);
            InternalEngine.this.engineConfig.getThreadPool().generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Exception e) {
                    EngineMergeScheduler.this.logger.debug("merge failure action rejected", (Throwable)e);
                }

                @Override
                protected void doRun() throws Exception {
                    MergePolicy.MergeException e = new MergePolicy.MergeException(exc, dir);
                    InternalEngine.this.failEngine("merge failed", (Exception)e);
                }
            });
        }
    }

    static final class SearchFactory
    extends EngineSearcherFactory {
        private final Engine.Warmer warmer;
        private final Logger logger;
        private final AtomicBoolean isEngineClosed;

        SearchFactory(Logger logger, AtomicBoolean isEngineClosed, EngineConfig engineConfig) {
            super(engineConfig);
            this.warmer = engineConfig.getWarmer();
            this.logger = logger;
            this.isEngineClosed = isEngineClosed;
        }

        @Override
        public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) throws IOException {
            IndexSearcher searcher;
            block5: {
                searcher = super.newSearcher(reader, previousReader);
                if (reader instanceof LeafReader && Engine.isMergedSegment((LeafReader)reader)) {
                    return searcher;
                }
                if (this.warmer != null) {
                    try {
                        assert (searcher.getIndexReader() instanceof ElasticsearchDirectoryReader) : "this class needs an ElasticsearchDirectoryReader but got: " + searcher.getIndexReader().getClass();
                        this.warmer.warm(new Engine.Searcher("top_reader_warming", searcher));
                    }
                    catch (Exception e) {
                        if (this.isEngineClosed.get()) break block5;
                        this.logger.warn("failed to prepare/warm", (Throwable)e);
                    }
                }
            }
            return searcher;
        }
    }

    @FunctionalInterface
    private static interface VersionValueSupplier {
        public VersionValue apply(long var1, long var3);
    }
}

