/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.search.lookup.SourceLookup;

public class GetResult
implements Streamable,
Iterable<GetField>,
ToXContent {
    private String index;
    private String type;
    private String id;
    private long version;
    private boolean exists;
    private Map<String, GetField> fields;
    private Map<String, Object> sourceAsMap;
    private BytesReference source;
    private byte[] sourceAsBytes;

    GetResult() {
    }

    public GetResult(String index, String type, String id, long version, boolean exists, BytesReference source, Map<String, GetField> fields) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.version = version;
        this.exists = exists;
        this.source = source;
        this.fields = fields;
        if (this.fields == null) {
            this.fields = Collections.emptyMap();
        }
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public byte[] source() {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsBytes != null) {
            return this.sourceAsBytes;
        }
        this.sourceAsBytes = BytesReference.toBytes(this.sourceRef());
        return this.sourceAsBytes;
    }

    public BytesReference sourceRef() {
        try {
            this.source = CompressorFactory.uncompressIfNeeded(this.source);
            return this.source;
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to decompress source", (Throwable)e, new Object[0]);
        }
    }

    public BytesReference internalSourceRef() {
        return this.source;
    }

    public boolean isSourceEmpty() {
        return this.source == null;
    }

    public String sourceAsString() {
        if (this.source == null) {
            return null;
        }
        BytesReference source = this.sourceRef();
        try {
            return XContentHelper.convertToJson(source, false);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("failed to convert source to a json string", new Object[0]);
        }
    }

    public Map<String, Object> sourceAsMap() throws ElasticsearchParseException {
        if (this.source == null) {
            return null;
        }
        if (this.sourceAsMap != null) {
            return this.sourceAsMap;
        }
        this.sourceAsMap = SourceLookup.sourceAsMap(this.source);
        return this.sourceAsMap;
    }

    public Map<String, Object> getSource() {
        return this.sourceAsMap();
    }

    public Map<String, GetField> getFields() {
        return this.fields;
    }

    public GetField field(String name) {
        return this.fields.get(name);
    }

    @Override
    public Iterator<GetField> iterator() {
        if (this.fields == null) {
            return Collections.emptyIterator();
        }
        return this.fields.values().iterator();
    }

    public XContentBuilder toXContentEmbedded(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ArrayList<GetField> metaFields = new ArrayList<GetField>();
        ArrayList<GetField> otherFields = new ArrayList<GetField>();
        if (this.fields != null && !this.fields.isEmpty()) {
            for (GetField field : this.fields.values()) {
                if (field.getValues().isEmpty()) continue;
                if (field.isMetadataField()) {
                    metaFields.add(field);
                    continue;
                }
                otherFields.add(field);
            }
        }
        for (GetField field : metaFields) {
            builder.field(field.getName(), field.getValue());
        }
        builder.field("found", this.exists);
        if (this.source != null) {
            XContentHelper.writeRawField("_source", this.source, builder, params);
        }
        if (!otherFields.isEmpty()) {
            builder.startObject("fields");
            for (GetField field : otherFields) {
                builder.startArray(field.getName());
                for (Object value : field.getValues()) {
                    builder.value(value);
                }
                builder.endArray();
            }
            builder.endObject();
        }
        return builder;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.isExists()) {
            builder.field("_index", this.index);
            builder.field("_type", this.type);
            builder.field("_id", this.id);
            builder.field("found", false);
        } else {
            builder.field("_index", this.index);
            builder.field("_type", this.type);
            builder.field("_id", this.id);
            if (this.version != -1L) {
                builder.field("_version", this.version);
            }
            this.toXContentEmbedded(builder, params);
        }
        return builder;
    }

    public static GetResult readGetResult(StreamInput in) throws IOException {
        GetResult result = new GetResult();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readString();
        this.type = in.readOptionalString();
        this.id = in.readString();
        this.version = in.readLong();
        this.exists = in.readBoolean();
        if (this.exists) {
            int size;
            this.source = in.readBytesReference();
            if (this.source.length() == 0) {
                this.source = null;
            }
            if ((size = in.readVInt()) == 0) {
                this.fields = Collections.emptyMap();
            } else {
                this.fields = new HashMap<String, GetField>(size);
                for (int i = 0; i < size; ++i) {
                    GetField field = GetField.readGetField(in);
                    this.fields.put(field.getName(), field);
                }
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index);
        out.writeOptionalString(this.type);
        out.writeString(this.id);
        out.writeLong(this.version);
        out.writeBoolean(this.exists);
        if (this.exists) {
            out.writeBytesReference(this.source);
            if (this.fields == null) {
                out.writeVInt(0);
            } else {
                out.writeVInt(this.fields.size());
                for (GetField field : this.fields.values()) {
                    field.writeTo(out);
                }
            }
        }
    }

    static final class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String _VERSION = "_version";
        static final String FOUND = "found";
        static final String FIELDS = "fields";

        Fields() {
        }
    }
}

