/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.MovAvgPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModelBuilder;

public class HoltLinearModel
extends MovAvgModel {
    public static final String NAME = "holt";
    public static final double DEFAULT_ALPHA = 0.3;
    public static final double DEFAULT_BETA = 0.1;
    private final double alpha;
    private final double beta;
    public static final MovAvgModel.AbstractModelParser PARSER = new MovAvgModel.AbstractModelParser(){

        @Override
        public MovAvgModel parse(@Nullable Map<String, Object> settings, String pipelineName, int windowSize, ParseFieldMatcher parseFieldMatcher) throws ParseException {
            double alpha = this.parseDoubleParam(settings, "alpha", 0.3);
            double beta = this.parseDoubleParam(settings, "beta", 0.1);
            this.checkUnrecognizedParams(settings);
            return new HoltLinearModel(alpha, beta);
        }
    };

    public HoltLinearModel() {
        this(0.3, 0.1);
    }

    public HoltLinearModel(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    public HoltLinearModel(StreamInput in) throws IOException {
        this.alpha = in.readDouble();
        this.beta = in.readDouble();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.alpha);
        out.writeDouble(this.beta);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean canBeMinimized() {
        return true;
    }

    @Override
    public MovAvgModel neighboringModel() {
        double newValue = Math.random();
        switch ((int)(Math.random() * 2.0)) {
            case 0: {
                return new HoltLinearModel(newValue, this.beta);
            }
            case 1: {
                return new HoltLinearModel(this.alpha, newValue);
            }
        }
        assert (false) : "Random value fell outside of range [0-1]";
        return new HoltLinearModel(newValue, this.beta);
    }

    @Override
    public MovAvgModel clone() {
        return new HoltLinearModel(this.alpha, this.beta);
    }

    @Override
    protected <T extends Number> double[] doPredict(Collection<T> values, int numPredictions) {
        return this.next(values, numPredictions);
    }

    @Override
    public <T extends Number> double next(Collection<T> values) {
        return this.next(values, 1)[0];
    }

    public <T extends Number> double[] next(Collection<T> values, int numForecasts) {
        if (values.size() == 0) {
            return this.emptyPredictions(numForecasts);
        }
        double s = 0.0;
        double last_s = 0.0;
        double b = 0.0;
        double last_b = 0.0;
        int counter = 0;
        Iterator<T> iterator = values.iterator();
        while (iterator.hasNext()) {
            Number v;
            Number last = v = (Number)iterator.next();
            if (counter == 1) {
                s = v.doubleValue();
                b = v.doubleValue() - last.doubleValue();
            } else {
                s = this.alpha * v.doubleValue() + (1.0 - this.alpha) * (last_s + last_b);
                b = this.beta * (s - last_s) + (1.0 - this.beta) * last_b;
            }
            ++counter;
            last_s = s;
            last_b = b;
        }
        double[] forecastValues = new double[numForecasts];
        for (int i = 0; i < numForecasts; ++i) {
            forecastValues[i] = s + (double)i * b;
        }
        return forecastValues;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), NAME);
        builder.startObject(MovAvgPipelineAggregationBuilder.SETTINGS.getPreferredName());
        builder.field("alpha", this.alpha);
        builder.field("beta", this.beta);
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alpha, this.beta);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HoltLinearModel other = (HoltLinearModel)obj;
        return Objects.equals(this.alpha, other.alpha) && Objects.equals(this.beta, other.beta);
    }

    public static class HoltLinearModelBuilder
    implements MovAvgModelBuilder {
        private double alpha = 0.3;
        private double beta = 0.1;

        public HoltLinearModelBuilder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public HoltLinearModelBuilder beta(double beta) {
            this.beta = beta;
            return this;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MovAvgPipelineAggregationBuilder.MODEL.getPreferredName(), HoltLinearModel.NAME);
            builder.startObject(MovAvgPipelineAggregationBuilder.SETTINGS.getPreferredName());
            builder.field("alpha", this.alpha);
            builder.field("beta", this.beta);
            builder.endObject();
            return builder;
        }

        @Override
        public MovAvgModel build() {
            return new HoltLinearModel(this.alpha, this.beta);
        }
    }
}

