/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.validation.validators;

import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidator;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;

public class RequiredValidator
implements ConstraintValidator<Required> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private Required annotation;

    @Override
    public void initialize(Required anAnnotation) {
        this.annotation = anAnnotation;
    }

    @Override
    public boolean isValid(String name, Object value) {
        if (value == null) {
            return this.err(name);
        }
        if (value instanceof CharSequence) {
            CharSequence sequence = (CharSequence)value;
            return sequence.length() != 0 || this.err(name);
        }
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            Object[] array = (Object[])value;
            return array.length != 0 || this.err(name);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)value;
            return collection.size() != 0 || this.err(name);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Map map = (Map)value;
            return map.size() != 0 || this.err(name);
        }
        return true;
    }

    private boolean err(String name) {
        LOGGER.error(this.annotation.message() + ": " + name);
        return false;
    }
}

