/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;
import org.mozilla.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    protected final int length;
    private static final int Id_constructor = 1;
    private static final int Id_get = 2;
    private static final int Id_set = 3;
    private static final int Id_subarray = 4;
    protected static final int MAX_PROTOTYPE_ID = 4;
    private static final int Id_length = 10;
    private static final int Id_BYTES_PER_ELEMENT = 11;
    private static final int MAX_INSTANCE_ID = 11;

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer nativeArrayBuffer, int n, int n2, int n3) {
        super(nativeArrayBuffer, n, n3);
        this.length = n2;
    }

    @Override
    public Object get(int n, Scriptable scriptable) {
        return this.js_get(n);
    }

    @Override
    public boolean has(int n, Scriptable scriptable) {
        return n > 0 && n < this.length;
    }

    @Override
    public void put(int n, Scriptable scriptable, Object object) {
        this.js_set(n, object);
    }

    @Override
    public void delete(int n) {
    }

    @Override
    public Object[] getIds() {
        Object[] objectArray = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = i;
        }
        return objectArray;
    }

    protected boolean checkIndex(int n) {
        return n < 0 || n >= this.length;
    }

    public abstract int getBytesPerElement();

    protected abstract NativeTypedArrayView construct(NativeArrayBuffer var1, int var2, int var3);

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    protected abstract NativeTypedArrayView realThis(Scriptable var1, IdFunctionObject var2);

    private NativeArrayBuffer makeArrayBuffer(Context context, Scriptable scriptable, int n) {
        return (NativeArrayBuffer)context.newObject(scriptable, "ArrayBuffer", new Object[]{n});
    }

    private NativeTypedArrayView js_constructor(Context context, Scriptable scriptable, Object[] objectArray) {
        if (!NativeTypedArrayView.isArg(objectArray, 0)) {
            return this.construct(NativeArrayBuffer.EMPTY_BUFFER, 0, 0);
        }
        if (objectArray[0] instanceof Number || objectArray[0] instanceof String) {
            int n = ScriptRuntime.toInt32(objectArray[0]);
            NativeArrayBuffer nativeArrayBuffer = this.makeArrayBuffer(context, scriptable, n * this.getBytesPerElement());
            return this.construct(nativeArrayBuffer, 0, n);
        }
        if (objectArray[0] instanceof NativeTypedArrayView) {
            NativeTypedArrayView nativeTypedArrayView = (NativeTypedArrayView)objectArray[0];
            NativeArrayBuffer nativeArrayBuffer = this.makeArrayBuffer(context, scriptable, nativeTypedArrayView.length * this.getBytesPerElement());
            NativeTypedArrayView nativeTypedArrayView2 = this.construct(nativeArrayBuffer, 0, nativeTypedArrayView.length);
            for (int i = 0; i < nativeTypedArrayView.length; ++i) {
                nativeTypedArrayView2.js_set(i, nativeTypedArrayView.js_get(i));
            }
            return nativeTypedArrayView2;
        }
        if (objectArray[0] instanceof NativeArrayBuffer) {
            NativeArrayBuffer nativeArrayBuffer = (NativeArrayBuffer)objectArray[0];
            int n = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
            int n2 = NativeTypedArrayView.isArg(objectArray, 2) ? ScriptRuntime.toInt32(objectArray[2]) * this.getBytesPerElement() : nativeArrayBuffer.getLength() - n;
            if (n < 0 || n > nativeArrayBuffer.buffer.length) {
                throw ScriptRuntime.constructError("RangeError", "offset out of range");
            }
            if (n2 < 0 || n + n2 > nativeArrayBuffer.buffer.length) {
                throw ScriptRuntime.constructError("RangeError", "length out of range");
            }
            if (n % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.constructError("RangeError", "offset must be a multiple of the byte size");
            }
            if (n2 % this.getBytesPerElement() != 0) {
                throw ScriptRuntime.constructError("RangeError", "offset and buffer must be a multiple of the byte size");
            }
            return this.construct(nativeArrayBuffer, n, n2 / this.getBytesPerElement());
        }
        if (objectArray[0] instanceof NativeArray) {
            List list = (List)objectArray[0];
            NativeArrayBuffer nativeArrayBuffer = this.makeArrayBuffer(context, scriptable, list.size() * this.getBytesPerElement());
            NativeTypedArrayView nativeTypedArrayView = this.construct(nativeArrayBuffer, 0, list.size());
            int n = 0;
            for (Object e : list) {
                nativeTypedArrayView.js_set(n, e);
                ++n;
            }
            return nativeTypedArrayView;
        }
        throw ScriptRuntime.constructError("Error", "invalid argument");
    }

    private void setRange(NativeTypedArrayView nativeTypedArrayView, int n) {
        if (n >= this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        if (nativeTypedArrayView.length > this.length - n) {
            throw ScriptRuntime.constructError("RangeError", "source array too long");
        }
        if (nativeTypedArrayView.arrayBuffer == this.arrayBuffer) {
            int n2;
            Object[] objectArray = new Object[nativeTypedArrayView.length];
            for (n2 = 0; n2 < nativeTypedArrayView.length; ++n2) {
                objectArray[n2] = nativeTypedArrayView.js_get(n2);
            }
            for (n2 = 0; n2 < nativeTypedArrayView.length; ++n2) {
                this.js_set(n2 + n, objectArray[n2]);
            }
        } else {
            for (int i = 0; i < nativeTypedArrayView.length; ++i) {
                this.js_set(i + n, nativeTypedArrayView.js_get(i));
            }
        }
    }

    private void setRange(NativeArray nativeArray, int n) {
        if (n > this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset out of range");
        }
        if (n + nativeArray.size() > this.length) {
            throw ScriptRuntime.constructError("RangeError", "offset + length out of range");
        }
        int n2 = n;
        for (Object e : nativeArray) {
            this.js_set(n2, e);
            ++n2;
        }
    }

    private Object js_subarray(Context context, Scriptable scriptable, int n, int n2) {
        int n3 = n < 0 ? this.length + n : n;
        int n4 = n2 < 0 ? this.length + n2 : n2;
        n3 = Math.max(0, n3);
        n4 = Math.min(this.length, n4);
        int n5 = Math.max(0, n4 - n3);
        int n6 = Math.min(n3 * this.getBytesPerElement(), this.arrayBuffer.getLength());
        return context.newObject(scriptable, this.getClassName(), new Object[]{this.arrayBuffer, n6, n5});
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(this.getClassName())) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.js_constructor(context, scriptable, objectArray);
            }
            case 2: {
                if (objectArray.length > 0) {
                    return this.realThis(scriptable2, idFunctionObject).js_get(ScriptRuntime.toInt32(objectArray[0]));
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 3: {
                if (objectArray.length > 0) {
                    NativeTypedArrayView nativeTypedArrayView = this.realThis(scriptable2, idFunctionObject);
                    if (objectArray[0] instanceof NativeTypedArrayView) {
                        int n2 = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
                        nativeTypedArrayView.setRange((NativeTypedArrayView)objectArray[0], n2);
                        return Undefined.instance;
                    }
                    if (objectArray[0] instanceof NativeArray) {
                        int n3 = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : 0;
                        nativeTypedArrayView.setRange((NativeArray)objectArray[0], n3);
                        return Undefined.instance;
                    }
                    if (objectArray[0] instanceof Scriptable) {
                        return Undefined.instance;
                    }
                    if (NativeTypedArrayView.isArg(objectArray, 2)) {
                        return nativeTypedArrayView.js_set(ScriptRuntime.toInt32(objectArray[0]), objectArray[1]);
                    }
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
            case 4: {
                if (objectArray.length > 0) {
                    NativeTypedArrayView nativeTypedArrayView = this.realThis(scriptable2, idFunctionObject);
                    int n4 = ScriptRuntime.toInt32(objectArray[0]);
                    int n5 = NativeTypedArrayView.isArg(objectArray, 1) ? ScriptRuntime.toInt32(objectArray[1]) : nativeTypedArrayView.length;
                    return nativeTypedArrayView.js_subarray(context, scriptable, n4, n5);
                }
                throw ScriptRuntime.constructError("Error", "invalid arguments");
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 1;
                string = "get";
                break;
            }
            case 3: {
                n2 = 2;
                string = "set";
                break;
            }
            case 4: {
                n2 = 2;
                string = "subarray";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(this.getClassName(), n, string, n2);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block6: {
            String string2;
            block5: {
                int n2;
                block3: {
                    char c;
                    block4: {
                        n = 0;
                        string2 = null;
                        n2 = string.length();
                        if (n2 != 3) break block3;
                        c = string.charAt(0);
                        if (c != 'g') break block4;
                        if (string.charAt(2) != 't' || string.charAt(1) != 'e') break block5;
                        n = 2;
                        break block6;
                    }
                    if (c != 's' || string.charAt(2) != 't' || string.charAt(1) != 'e') break block5;
                    n = 3;
                    break block6;
                }
                if (n2 == 8) {
                    string2 = "subarray";
                    n = 4;
                } else if (n2 == 11) {
                    string2 = "constructor";
                    n = 1;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block6;
            n = 0;
        }
        return n;
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        idFunctionObject.put("BYTES_PER_ELEMENT", (Scriptable)idFunctionObject, (Object)ScriptRuntime.wrapInt(this.getBytesPerElement()));
    }

    @Override
    protected int getMaxInstanceId() {
        return 11;
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 10: {
                return "length";
            }
            case 11: {
                return "BYTES_PER_ELEMENT";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 10: {
                return ScriptRuntime.wrapInt(this.length);
            }
            case 11: {
                return ScriptRuntime.wrapInt(this.getBytesPerElement());
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 6) {
            string2 = "length";
            n = 10;
        } else if (n2 == 17) {
            string2 = "BYTES_PER_ELEMENT";
            n = 11;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n == 0) {
            return super.findInstanceIdInfo(string);
        }
        return NativeTypedArrayView.instanceIdInfo(5, n);
    }

    @Override
    public Object getArrayElement(int n) {
        return this.js_get(n);
    }

    @Override
    public void setArrayElement(int n, Object object) {
        this.js_set(n, object);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object object) {
        for (int i = 0; i < this.length; ++i) {
            if (!object.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!object.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            objectArray[i] = this.js_get(i);
        }
        return objectArray;
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        Object[] objectArray = UArray.length >= this.length ? UArray : (Object[])Array.newInstance(UArray.getClass().getComponentType(), this.length);
        for (int i = 0; i < this.length; ++i) {
            try {
                objectArray[i] = this.js_get(i);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new ArrayStoreException();
            }
        }
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        try {
            NativeTypedArrayView nativeTypedArrayView = (NativeTypedArrayView)object;
            if (this.length != nativeTypedArrayView.length) {
                return false;
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.js_get(i).equals(nativeTypedArrayView.js_get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.length; ++i) {
            n += this.js_get(i).hashCode();
        }
        return 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        if (this.checkIndex(n)) {
            throw new IndexOutOfBoundsException();
        }
        return new NativeTypedArrayIterator(this, n);
    }

    @Override
    public List<T> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int n, T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }
}

