/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.scope;

import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.NoVarsDynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;

public class OneVarDynamicScope
extends NoVarsDynamicScope {
    private static final int SIZE = 1;
    private static final String SIZE_ERROR = "OneVarDynamicScope only supports scopes with one variable";
    private static final String GROW_ERROR = "OneVarDynamicScope cannot be grown; use ManyVarsDynamicScope";
    protected IRubyObject variableValueZero;

    public OneVarDynamicScope(StaticScope staticScope, DynamicScope parent) {
        super(staticScope, parent);
    }

    public OneVarDynamicScope(StaticScope staticScope) {
        super(staticScope);
    }

    @Override
    public void growIfNeeded() {
        this.growIfNeeded(1, GROW_ERROR);
    }

    @Override
    public DynamicScope cloneScope() {
        return new OneVarDynamicScope(this.staticScope, this.parent);
    }

    @Override
    public IRubyObject[] getValues() {
        return new IRubyObject[]{this.variableValueZero};
    }

    @Override
    public IRubyObject getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        assert (offset < 1) : "OneVarDynamicScope only supports scopes with one variable";
        return this.variableValueZero;
    }

    @Override
    public IRubyObject getValueOrNil(int offset, int depth, IRubyObject nil) {
        if (depth > 0) {
            return this.parent.getValueOrNil(offset, depth - 1, nil);
        }
        return this.getValueDepthZeroOrNil(offset, nil);
    }

    @Override
    public IRubyObject getValueDepthZeroOrNil(int offset, IRubyObject nil) {
        IRubyObject value = this.variableValueZero;
        if (value == null) {
            this.variableValueZero = nil;
            return this.variableValueZero;
        }
        return value;
    }

    @Override
    public IRubyObject getValueZeroDepthZeroOrNil(IRubyObject nil) {
        IRubyObject value = this.variableValueZero;
        if (value == null) {
            this.variableValueZero = nil;
            return this.variableValueZero;
        }
        return value;
    }

    @Override
    public IRubyObject setValue(int offset, IRubyObject value, int depth) {
        if (depth > 0) {
            return this.parent.setValue(offset, value, depth - 1);
        }
        this.variableValueZero = value;
        return this.variableValueZero;
    }

    @Override
    public IRubyObject setValueDepthZero(IRubyObject value, int offset) {
        this.variableValueZero = value;
        return this.variableValueZero;
    }

    @Override
    public IRubyObject setValueZeroDepthZero(IRubyObject value) {
        this.variableValueZero = value;
        return this.variableValueZero;
    }
}

