/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.datatransfer.data.OsmLayerTransferData;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTagTransferData;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.datatransfer.data.TagTransferData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class PrimitiveTransferable
implements Transferable {
    private static final List<DataFlavor> PRIMITIVE_FLAVORS = Arrays.asList(PrimitiveTransferData.DATA_FLAVOR, TagTransferData.FLAVOR, DataFlavor.stringFlavor);
    private final PrimitiveTransferData primitives;
    private OsmDataLayer sourceLayer;

    public PrimitiveTransferable(PrimitiveTransferData primitiveTransferData) {
        this(primitiveTransferData, null);
    }

    public PrimitiveTransferable(PrimitiveTransferData primitiveTransferData, OsmDataLayer osmDataLayer) {
        this.primitives = primitiveTransferData;
        this.sourceLayer = osmDataLayer;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(PRIMITIVE_FLAVORS);
        if (this.sourceLayer != null) {
            arrayList.addAll(OsmLayerTransferData.FLAVORS);
        }
        return arrayList.toArray(new DataFlavor[arrayList.size()]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        DataFlavor[] dataFlavorArray;
        for (DataFlavor dataFlavor2 : dataFlavorArray = this.getTransferDataFlavors()) {
            if (!dataFlavor.equals(dataFlavor2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getStringData();
        }
        if (PrimitiveTransferData.DATA_FLAVOR.equals(dataFlavor)) {
            return this.primitives;
        }
        if (PrimitiveTagTransferData.FLAVOR.equals(dataFlavor)) {
            return new PrimitiveTagTransferData(this.primitives);
        }
        if (TagTransferData.FLAVOR.equals(dataFlavor)) {
            return new TagTransferData(this.primitives.getDirectlyAdded());
        }
        if (this.sourceLayer != null && OsmLayerTransferData.FLAVORS.contains(dataFlavor)) {
            return new OsmLayerTransferData(null, this.sourceLayer);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    protected String getStringData() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PrimitiveData primitiveData : this.primitives.getDirectlyAdded()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(OsmPrimitiveType.from(primitiveData).getAPIName()).append(' ').append(primitiveData.getId());
        }
        return stringBuilder.toString().replace("\u200e", "").replace("\u200f", "");
    }
}

