/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFObject;

public class PDFOutputIntent
extends PDFObject {
    public static final String GTS_PDFX = "GTS_PDFX";
    public static final String GTS_PDFA1 = "GTS_PDFA1";
    private String subtype;
    private String outputCondition;
    private String outputConditionIdentifier;
    private String registryName;
    private String info;
    private PDFICCStream destOutputProfile;

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public String getOutputCondition() {
        return this.outputCondition;
    }

    public void setOutputCondition(String outputCondition) {
        this.outputCondition = outputCondition;
    }

    public String getOutputConditionIdentifier() {
        return this.outputConditionIdentifier;
    }

    public void setOutputConditionIdentifier(String outputConditionIdentifier) {
        this.outputConditionIdentifier = outputConditionIdentifier;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = registryName;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public PDFICCStream getDestOutputProfile() {
        return this.destOutputProfile;
    }

    public void setDestOutputProfile(PDFICCStream destOutputProfile) {
        this.destOutputProfile = destOutputProfile;
    }

    public byte[] toPDF() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(128);
        try {
            bout.write(PDFOutputIntent.encode("<<\n"));
            bout.write(PDFOutputIntent.encode("/Type /OutputIntent\n"));
            bout.write(PDFOutputIntent.encode("/S /"));
            bout.write(PDFOutputIntent.encode(this.subtype));
            bout.write(PDFOutputIntent.encode("\n"));
            if (this.outputCondition != null) {
                bout.write(PDFOutputIntent.encode("/OutputCondition "));
                bout.write(this.encodeText(this.outputCondition));
                bout.write(PDFOutputIntent.encode("\n"));
            }
            bout.write(PDFOutputIntent.encode("/OutputConditionIdentifier "));
            bout.write(this.encodeText(this.outputConditionIdentifier));
            bout.write(PDFOutputIntent.encode("\n"));
            if (this.registryName != null) {
                bout.write(PDFOutputIntent.encode("/RegistryName "));
                bout.write(this.encodeText(this.registryName));
                bout.write(PDFOutputIntent.encode("\n"));
            }
            if (this.info != null) {
                bout.write(PDFOutputIntent.encode("/Info "));
                bout.write(this.encodeText(this.info));
                bout.write(PDFOutputIntent.encode("\n"));
            }
            if (this.destOutputProfile != null) {
                bout.write(PDFOutputIntent.encode("/DestOutputProfile " + this.destOutputProfile.referencePDF() + "\n"));
            }
            bout.write(PDFOutputIntent.encode(">>"));
        }
        catch (IOException ioe) {
            log.error((Object)"Ignored I/O exception", (Throwable)ioe);
        }
        byte[] bytes = bout.toByteArray();
        IOUtils.closeQuietly((OutputStream)bout);
        return bytes;
    }
}

