/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.annotation.Nullable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.gui.ColorWellButton;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.FilteredListModel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.ThreadUtilities;

public class LogViewer
extends JPanel
implements DefaultFocusComponent {
    private final ColorizerCellRenderer cellRenderer;
    private ListHandler listHandler;
    private final FilteredListModel<ListModel> listModel;
    private final JList list;
    private final JButton copy;
    private final JCheckBox tail;
    private final JTextField filter;
    private boolean tailIsOn;
    private static boolean showDebug = jEdit.getBooleanProperty("log-viewer.message.debug", true);
    private static boolean showMessage = jEdit.getBooleanProperty("log-viewer.message.message", true);
    private static boolean showNotice = jEdit.getBooleanProperty("log-viewer.message.notice", true);
    private static boolean showWarning = jEdit.getBooleanProperty("log-viewer.message.warning", true);
    private static boolean showError = jEdit.getBooleanProperty("log-viewer.message.error", true);

    public LogViewer() {
        super(new BorderLayout());
        Object object;
        Object object2;
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(6, 0, 6, 0));
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            object2 = new String[]{MiscUtilities.constructPath(string, "activity.log")};
            object = new JLabel(jEdit.getProperty("log-viewer.caption", (Object[])object2));
            jPanel.add((Component)object);
        }
        jPanel.add(Box.createHorizontalGlue());
        this.tailIsOn = jEdit.getBooleanProperty("log-viewer.tail", false);
        this.tail = new JCheckBox(jEdit.getProperty("log-viewer.tail.label"), this.tailIsOn);
        this.tail.addActionListener(new ActionHandler());
        this.filter = new JTextField();
        this.filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                LogViewer.this.setFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                LogViewer.this.setFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                LogViewer.this.setFilter();
            }
        });
        jPanel.add(this.filter);
        jPanel.add(this.tail);
        jPanel.add(Box.createHorizontalStrut(12));
        this.copy = new JButton(jEdit.getProperty("log-viewer.copy"));
        this.copy.addActionListener(new ActionHandler());
        jPanel.add(this.copy);
        jPanel.add(Box.createHorizontalStrut(6));
        object2 = new JButton(jEdit.getProperty("log-viewer.settings.label"));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new LogSettings();
            }
        });
        jPanel.add((Component)object2);
        object = Log.getLogListModel();
        this.listModel = new MyFilteredListModel((ListModel)object);
        object.removeListDataListener(this.listModel);
        this.list = new LogList(this.listModel);
        this.listModel.setList(this.list);
        this.cellRenderer = new ColorizerCellRenderer();
        this.list.setCellRenderer(this.cellRenderer);
        this.setFilter();
        this.add("North", jPanel);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        Dimension dimension = jScrollPane.getPreferredSize();
        dimension.width = Math.min(600, dimension.width);
        jScrollPane.setPreferredSize(dimension);
        this.add("Center", jScrollPane);
        this.propertiesChanged();
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.scrollLaterIfRequired();
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        this.propertiesChanged();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.cellRenderer.updateColors();
        ListModel listModel = Log.getLogListModel();
        listModel.addListDataListener(this.listModel);
        this.listHandler = new ListHandler();
        listModel.addListDataListener(this.listHandler);
        if (this.tailIsOn) {
            this.scrollToTail();
        }
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ListModel listModel = Log.getLogListModel();
        listModel.removeListDataListener(this.listModel);
        listModel.removeListDataListener(this.listHandler);
        this.listHandler = null;
        EditBus.removeFromBus(this);
    }

    @Override
    public void focusOnDefaultComponent() {
        this.list.requestFocus();
    }

    private void setFilter() {
        String string = this.filter.getText();
        this.listModel.setFilter(string.length() == 0 ? " " : string);
        this.scrollLaterIfRequired();
    }

    private void propertiesChanged() {
        this.cellRenderer.updateColors();
        this.list.setFont(jEdit.getFontProperty("view.font"));
        this.list.setFixedCellHeight(this.list.getFontMetrics(this.list.getFont()).getHeight());
    }

    private void scrollToTail() {
        int n = this.list.getModel().getSize();
        if (n != 0) {
            this.list.ensureIndexIsVisible(n - 1);
        }
    }

    private void scrollLaterIfRequired() {
        if (this.tailIsOn) {
            ThreadUtilities.runInDispatchThread(new Runnable(){

                @Override
                public void run() {
                    LogViewer.this.scrollToTail();
                }
            });
        }
    }

    private class LogSettings
    extends JDialog {
        private JSpinner maxLines;
        private JCheckBox debug;
        private JCheckBox message;
        private JCheckBox notice;
        private JCheckBox warning;
        private JCheckBox error;
        private ColorWellButton debugColor;
        private ColorWellButton messageColor;
        private ColorWellButton noticeColor;
        private ColorWellButton warningColor;
        private ColorWellButton errorColor;
        private JCheckBox beep;

        LogSettings() {
            super((Frame)jEdit.getActiveView(), jEdit.getProperty("log-viewer.dialog.title"));
            AbstractOptionPane abstractOptionPane = new AbstractOptionPane(jEdit.getProperty("log-viewer.settings.label")){

                @Override
                protected void _init() {
                    this.setBorder(BorderFactory.createEmptyBorder(11, 11, 12, 12));
                    LogSettings.this.maxLines = new JSpinner(new SpinnerNumberModel(jEdit.getIntegerProperty("log-viewer.maxlines", 500), 500, Integer.MAX_VALUE, 1));
                    this.addComponent(jEdit.getProperty("log-viewer.maxlines.label", "Max lines"), (Component)LogSettings.this.maxLines, 0);
                    this.addComponent(Box.createVerticalStrut(11));
                    LogSettings.this.debug = new JCheckBox(jEdit.getProperty("log-viewer.message.debug.label", "Debug"), jEdit.getBooleanProperty("log-viewer.message.debug", true));
                    LogSettings.this.message = new JCheckBox(jEdit.getProperty("log-viewer.message.message.label", "Message"), jEdit.getBooleanProperty("log-viewer.message.message", true));
                    LogSettings.this.notice = new JCheckBox(jEdit.getProperty("log-viewer.message.notice.label", "Notice"), jEdit.getBooleanProperty("log-viewer.message.notice", true));
                    LogSettings.this.warning = new JCheckBox(jEdit.getProperty("log-viewer.message.warning.label", "Warning"), jEdit.getBooleanProperty("log-viewer.message.warning", true));
                    LogSettings.this.error = new JCheckBox(jEdit.getProperty("log-viewer.message.error.label", "Error"), jEdit.getBooleanProperty("log-viewer.message.error", true));
                    this.addComponent(new JLabel(jEdit.getProperty("log-viewer.message.label", "Message Display:")));
                    this.addComponent(LogSettings.this.debug, (Component)(LogSettings.this.debugColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.debug.color", Color.BLUE))), 0);
                    this.addComponent(LogSettings.this.message, (Component)(LogSettings.this.messageColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.message.color", Color.GREEN))), 0);
                    this.addComponent(LogSettings.this.notice, (Component)(LogSettings.this.noticeColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.notice.color", Color.GREEN))), 0);
                    this.addComponent(LogSettings.this.warning, (Component)(LogSettings.this.warningColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.warning.color", Color.ORANGE))), 0);
                    this.addComponent(LogSettings.this.error, (Component)(LogSettings.this.errorColor = new ColorWellButton(jEdit.getColorProperty("log-viewer.message.error.color", Color.RED))), 0);
                    this.addComponent(Box.createVerticalStrut(11));
                    LogSettings.this.beep = new JCheckBox(jEdit.getProperty("debug.beepOnOutput.label"), jEdit.getBooleanProperty("debug.beepOnOutput", false));
                    this.addComponent(LogSettings.this.beep);
                    this.addComponent(Box.createVerticalStrut(11));
                    JPanel jPanel = new JPanel(new FlowLayout(1));
                    JButton jButton = new JButton(jEdit.getProperty("common.ok"));
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            this.save();
                            LogSettings.this.setVisible(false);
                            LogSettings.this.dispose();
                        }
                    });
                    JButton jButton2 = new JButton(jEdit.getProperty("common.cancel"));
                    jButton2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            LogSettings.this.setVisible(false);
                            LogSettings.this.dispose();
                        }
                    });
                    jPanel.add(jButton);
                    jPanel.add(jButton2);
                    this.addComponent((Component)jPanel, 2);
                }

                @Override
                protected void _save() {
                    jEdit.setIntegerProperty("log-viewer.maxlines", ((SpinnerNumberModel)LogSettings.this.maxLines.getModel()).getNumber().intValue());
                    showDebug = LogSettings.this.debug.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.debug", showDebug);
                    showMessage = LogSettings.this.message.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.message", showMessage);
                    showNotice = LogSettings.this.notice.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.notice", showNotice);
                    showWarning = LogSettings.this.warning.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.warning", showWarning);
                    showError = LogSettings.this.error.isSelected();
                    jEdit.setBooleanProperty("log-viewer.message.error", showError);
                    jEdit.setColorProperty("log-viewer.message.debug.color", LogSettings.this.debugColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.message.color", LogSettings.this.messageColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.notice.color", LogSettings.this.noticeColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.warning.color", LogSettings.this.warningColor.getSelectedColor());
                    jEdit.setColorProperty("log-viewer.message.error.color", LogSettings.this.errorColor.getSelectedColor());
                    jEdit.setBooleanProperty("debug.beepOnOutput", LogSettings.this.beep.isSelected());
                    LogViewer.this.setFilter();
                    Log.setBeepOnOutput(LogSettings.this.beep.isSelected());
                }
            };
            this.setContentPane(abstractOptionPane);
            abstractOptionPane.init();
            this.pack();
            this.setLocationRelativeTo(LogViewer.this);
            this.setVisible(true);
        }
    }

    private static class MyFilteredListModel
    extends FilteredListModel<ListModel> {
        MyFilteredListModel(ListModel listModel) {
            super(listModel);
        }

        @Override
        public String prepareFilter(String string) {
            return string.toLowerCase();
        }

        @Override
        public boolean passFilter(int n, @Nullable String string) {
            if (string == null || string.isEmpty()) {
                return true;
            }
            String string2 = this.delegated.getElementAt(n).toString().toLowerCase();
            if (!showDebug && string2.contains("[debug]")) {
                return false;
            }
            if (!showMessage && string2.contains("[message]")) {
                return false;
            }
            if (!showNotice && string2.contains("[notice]")) {
                return false;
            }
            if (!showWarning && string2.contains("[warning]")) {
                return false;
            }
            if (!showError && string2.contains("[error]")) {
                return false;
            }
            return string2.contains(string);
        }
    }

    private static class ColorizerCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static Color debugColor;
        private static Color messageColor;
        private static Color noticeColor;
        private static Color warningColor;
        private static Color errorColor;

        private ColorizerCellRenderer() {
            this.updateColors();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                Color color = jList.getForeground();
                if (string.contains("[debug]")) {
                    color = debugColor;
                } else if (string.contains("[message]")) {
                    color = messageColor;
                } else if (string.contains("[notice]")) {
                    color = noticeColor;
                } else if (string.contains("[warning]")) {
                    color = warningColor;
                } else if (string.contains("[error]")) {
                    color = errorColor;
                }
                this.setForeground(color);
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }

        public void updateColors() {
            debugColor = jEdit.getColorProperty("log-viewer.message.debug.color", Color.BLUE);
            messageColor = jEdit.getColorProperty("log-viewer.message.message.color", Color.BLACK);
            noticeColor = jEdit.getColorProperty("log-viewer.message.notice.color", Color.GREEN);
            warningColor = jEdit.getColorProperty("log-viewer.message.warning.color", Color.ORANGE);
            errorColor = jEdit.getColorProperty("log-viewer.message.error.color", Color.RED);
        }
    }

    private class LogList
    extends JList {
        private int startIndex;

        LogList(ListModel listModel) {
            super(listModel);
            this.setVisibleRowCount(24);
            this.getSelectionModel().setSelectionMode(1);
            this.setAutoscrolls(true);
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                this.startIndex = LogViewer.this.list.locationToIndex(mouseEvent.getPoint());
            }
            super.processMouseEvent(mouseEvent);
        }

        @Override
        public void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                int n = LogViewer.this.list.locationToIndex(mouseEvent.getPoint());
                if (n != -1) {
                    if (this.startIndex == -1) {
                        LogViewer.this.list.setSelectionInterval(n, n);
                        this.startIndex = n;
                    } else {
                        LogViewer.this.list.setSelectionInterval(this.startIndex, n);
                    }
                    LogViewer.this.list.ensureIndexIsVisible(n);
                    mouseEvent.consume();
                }
            } else {
                super.processMouseMotionEvent(mouseEvent);
            }
        }
    }

    private class ListHandler
    implements ListDataListener {
        private ListHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.contentsChanged(listDataEvent);
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            LogViewer.this.scrollLaterIfRequired();
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == LogViewer.this.tail) {
                LogViewer.this.tailIsOn = !LogViewer.this.tailIsOn;
                jEdit.setBooleanProperty("log-viewer.tail", LogViewer.this.tailIsOn);
                if (LogViewer.this.tailIsOn) {
                    LogViewer.this.scrollToTail();
                }
            } else if (object == LogViewer.this.copy) {
                StringBuilder stringBuilder = new StringBuilder();
                Object[] objectArray = LogViewer.this.list.getSelectedValues();
                if (objectArray != null && objectArray.length != 0) {
                    for (Object object2 : objectArray) {
                        stringBuilder.append(object2);
                        stringBuilder.append('\n');
                    }
                } else {
                    ListModel listModel = LogViewer.this.list.getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        stringBuilder.append(listModel.getElementAt(i));
                        stringBuilder.append('\n');
                    }
                }
                Registers.setRegister('$', stringBuilder.toString());
            }
        }
    }
}

