/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.TaskId;

public class BaseTasksResponse
extends ActionResponse {
    private List<TaskOperationFailure> taskFailures;
    private List<FailedNodeException> nodeFailures;

    public BaseTasksResponse() {
    }

    public BaseTasksResponse(List<TaskOperationFailure> taskFailures, List<? extends FailedNodeException> nodeFailures) {
        this.taskFailures = taskFailures == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<TaskOperationFailure>(taskFailures));
        this.nodeFailures = nodeFailures == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<FailedNodeException>(nodeFailures));
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public List<FailedNodeException> getNodeFailures() {
        return this.nodeFailures;
    }

    public void rethrowFailures(String operationName) {
        ExceptionsHelper.rethrowAndSuppress(Stream.concat(this.getNodeFailures().stream(), this.getTaskFailures().stream().map(f -> new ElasticsearchException("{} of [{}] failed", f.getCause(), operationName, new TaskId(f.getNodeId(), f.getTaskId())))).collect(Collectors.toList()));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ArrayList<TaskOperationFailure> taskFailures = new ArrayList<TaskOperationFailure>();
        for (int i = 0; i < size; ++i) {
            taskFailures.add(new TaskOperationFailure(in));
        }
        size = in.readVInt();
        this.taskFailures = Collections.unmodifiableList(taskFailures);
        ArrayList<FailedNodeException> nodeFailures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < size; ++i) {
            nodeFailures.add(new FailedNodeException(in));
        }
        this.nodeFailures = Collections.unmodifiableList(nodeFailures);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.taskFailures.size());
        for (TaskOperationFailure taskOperationFailure : this.taskFailures) {
            taskOperationFailure.writeTo(out);
        }
        out.writeVInt(this.nodeFailures.size());
        for (FailedNodeException failedNodeException : this.nodeFailures) {
            failedNodeException.writeTo(out);
        }
    }
}

