/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.PropertyPlaceholder;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.settings.loader.SettingsLoaderFactory;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.MemorySizeValue;
import org.elasticsearch.common.unit.RatioValue;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class Settings
implements ToXContent {
    public static final Settings EMPTY = new Builder().build();
    private static final Pattern ARRAY_PATTERN = Pattern.compile("(.*)\\.\\d+$");
    private SortedMap<String, String> settings;
    public static final Set<String> FORMAT_PARAMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("settings_filter", "flat_settings")));

    Settings(Map<String, String> settings) {
        this.settings = Collections.unmodifiableSortedMap(new TreeMap<String, String>(settings));
    }

    public Map<String, String> getAsMap() {
        return Collections.unmodifiableMap(this.settings);
    }

    public Map<String, Object> getAsStructuredMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            this.processSetting(map, "", entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)((Object)entry.getValue());
            entry.setValue((String)this.convertMapsToArrays(valMap));
        }
        return map;
    }

    private void processSetting(Map<String, Object> map, String prefix, String setting, String value) {
        int prefixLength = setting.indexOf(46);
        if (prefixLength == -1) {
            Map innerMap = (Map)map.get(prefix + setting);
            if (innerMap != null) {
                for (Map.Entry entry : innerMap.entrySet()) {
                    map.put(prefix + setting + "." + (String)entry.getKey(), entry.getValue());
                }
            }
            map.put(prefix + setting, value);
        } else {
            String key = setting.substring(0, prefixLength);
            String rest = setting.substring(prefixLength + 1);
            Object existingValue = map.get(prefix + key);
            if (existingValue == null) {
                HashMap<String, Object> newMap = new HashMap<String, Object>(2);
                this.processSetting(newMap, "", rest, value);
                map.put(key, newMap);
            } else if (existingValue instanceof Map) {
                Map innerMap = (Map)existingValue;
                this.processSetting(innerMap, "", rest, value);
                map.put(key, innerMap);
            } else {
                this.processSetting(map, prefix + key + ".", rest, value);
            }
        }
    }

    private Object convertMapsToArrays(Map<String, Object> map) {
        if (map.isEmpty()) {
            return map;
        }
        boolean isArray = true;
        int maxIndex = -1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isArray) {
                try {
                    int index = Integer.parseInt(entry.getKey());
                    if (index >= 0) {
                        maxIndex = Math.max(maxIndex, index);
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException ex) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        if (isArray && maxIndex + 1 == map.size()) {
            ArrayList<Object> newValue = new ArrayList<Object>(maxIndex + 1);
            for (int i = 0; i <= maxIndex; ++i) {
                Object obj = map.get(Integer.toString(i));
                if (obj == null) {
                    return map;
                }
                newValue.add(obj);
            }
            return newValue;
        }
        return map;
    }

    public Settings getByPrefix(String prefix) {
        Builder builder = new Builder();
        for (Map.Entry<String, String> entry : this.getAsMap().entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() < prefix.length()) continue;
            builder.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return builder.build();
    }

    public Settings filter(Predicate<String> predicate) {
        Builder builder = new Builder();
        for (Map.Entry<String, String> entry : this.getAsMap().entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public Settings getAsSettings(String setting) {
        return this.getByPrefix(setting + ".");
    }

    public String get(String setting) {
        return (String)this.settings.get(setting);
    }

    public String get(String setting, String defaultValue) {
        String retVal = this.get(setting);
        return retVal == null ? defaultValue : retVal;
    }

    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return Booleans.parseBoolean(this.get(setting), defaultValue);
    }

    public TimeValue getAsTime(String setting, TimeValue defaultValue) {
        return TimeValue.parseTimeValue(this.get(setting), defaultValue, setting);
    }

    public ByteSizeValue getAsBytesSize(String setting, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(setting), defaultValue, setting);
    }

    public ByteSizeValue getAsMemory(String setting, String defaultValue) throws SettingsException {
        return MemorySizeValue.parseBytesSizeValueOrHeapRatio(this.get(setting, defaultValue), setting);
    }

    public RatioValue getAsRatio(String setting, String defaultValue) throws SettingsException {
        return RatioValue.parseRatioValue(this.get(setting, defaultValue));
    }

    public SizeValue getAsSize(String setting, SizeValue defaultValue) throws SettingsException {
        return SizeValue.parseSizeValue(this.get(setting), defaultValue);
    }

    public String[] getAsArray(String settingPrefix) throws SettingsException {
        return this.getAsArray(settingPrefix, Strings.EMPTY_ARRAY, true);
    }

    public String[] getAsArray(String settingPrefix, String[] defaultArray) throws SettingsException {
        return this.getAsArray(settingPrefix, defaultArray, true);
    }

    public String[] getAsArray(String settingPrefix, String[] defaultArray, Boolean commaDelimited) throws SettingsException {
        String value;
        ArrayList<String> result = new ArrayList<String>();
        if (this.get(settingPrefix) != null) {
            if (commaDelimited.booleanValue()) {
                String[] strings = Strings.splitStringByCommaToArray(this.get(settingPrefix));
                if (strings.length > 0) {
                    for (String string : strings) {
                        result.add(string.trim());
                    }
                }
            } else {
                result.add(this.get(settingPrefix).trim());
            }
        }
        int counter = 0;
        while ((value = this.get(settingPrefix + '.' + counter++)) != null) {
            result.add(value.trim());
        }
        if (result.isEmpty()) {
            return defaultArray;
        }
        return result.toArray(new String[result.size()]);
    }

    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        return this.getGroups(settingPrefix, false);
    }

    public Map<String, Settings> getGroups(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        if (!Strings.hasLength(settingPrefix)) {
            throw new IllegalArgumentException("illegal setting prefix " + settingPrefix);
        }
        if (settingPrefix.charAt(settingPrefix.length() - 1) != '.') {
            settingPrefix = settingPrefix + ".";
        }
        return this.getGroupsInternal(settingPrefix, ignoreNonGrouped);
    }

    private Map<String, Settings> getGroupsInternal(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        LinkedHashMap<String, LinkedHashMap<String, String>> map = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (String o : this.settings.keySet()) {
            String setting = o;
            if (!setting.startsWith(settingPrefix)) continue;
            String nameValue = setting.substring(settingPrefix.length());
            int dotIndex = nameValue.indexOf(46);
            if (dotIndex == -1) {
                if (ignoreNonGrouped) continue;
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + setting + "] because of a missing '.'");
            }
            String name = nameValue.substring(0, dotIndex);
            String value = nameValue.substring(dotIndex + 1);
            LinkedHashMap<String, String> groupSettings = (LinkedHashMap<String, String>)map.get(name);
            if (groupSettings == null) {
                groupSettings = new LinkedHashMap<String, String>();
                map.put(name, groupSettings);
            }
            groupSettings.put(value, this.get(setting));
        }
        LinkedHashMap retVal = new LinkedHashMap();
        for (Map.Entry entry : map.entrySet()) {
            retVal.put(entry.getKey(), new Settings(Collections.unmodifiableMap((Map)entry.getValue())));
        }
        return Collections.unmodifiableMap(retVal);
    }

    public Map<String, Settings> getAsGroups() throws SettingsException {
        return this.getAsGroups(false);
    }

    public Map<String, Settings> getAsGroups(boolean ignoreNonGrouped) throws SettingsException {
        return this.getGroupsInternal("", ignoreNonGrouped);
    }

    public Version getAsVersion(String setting, Version defaultVersion) throws SettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultVersion;
        }
        try {
            return Version.fromId(Integer.parseInt(sValue));
        }
        catch (Exception e) {
            throw new SettingsException("Failed to parse version setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Set<String> names() {
        HashSet<String> names = new HashSet<String>();
        for (String key : this.settings.keySet()) {
            int i = key.indexOf(".");
            if (i < 0) {
                names.add(key);
                continue;
            }
            names.add(key.substring(0, i));
        }
        return names;
    }

    public String toDelimitedString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.settings.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(delimiter);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings that = (Settings)o;
        return !(this.settings != null ? !this.settings.equals(that.settings) : that.settings != null);
    }

    public int hashCode() {
        int result = this.settings != null ? this.settings.hashCode() : 0;
        return result;
    }

    public static Settings readSettingsFromStream(StreamInput in) throws IOException {
        Builder builder = new Builder();
        int numberOfSettings = in.readVInt();
        for (int i = 0; i < numberOfSettings; ++i) {
            builder.put(in.readString(), in.readOptionalString());
        }
        return builder.build();
    }

    public static void writeSettingsToStream(Settings settings, StreamOutput out) throws IOException {
        out.writeVInt(settings.getAsMap().size());
        for (Map.Entry<String, String> entry : settings.getAsMap().entrySet()) {
            out.writeString(entry.getKey());
            out.writeOptionalString(entry.getValue());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Settings settings = SettingsFilter.filterSettings(params, this);
        if (!params.paramAsBoolean("flat_settings", false)) {
            for (Map.Entry<String, Object> entry : settings.getAsStructuredMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : settings.getAsMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public static class Builder {
        public static final Settings EMPTY_SETTINGS = new Builder().build();
        private final Map<String, String> map = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public Map<String, String> internalMap() {
            return this.map;
        }

        public String remove(String key) {
            return this.map.remove(key);
        }

        public String get(String key) {
            return this.map.get(key);
        }

        public Builder put(Object ... settings) {
            if (settings.length == 1) {
                if (settings[0] instanceof Map) {
                    return this.put((Map)settings[0]);
                }
                if (settings[0] instanceof Settings) {
                    return this.put((Settings)settings[0]);
                }
            }
            if (settings.length % 2 != 0) {
                throw new IllegalArgumentException("array settings of key + value order doesn't hold correct number of arguments (" + settings.length + ")");
            }
            for (int i = 0; i < settings.length; ++i) {
                this.put(settings[i++].toString(), settings[i].toString());
            }
            return this;
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder putNull(String key) {
            return this.put(key, (String)null);
        }

        public Builder put(String key, Class clazz) {
            this.map.put(key, clazz.getName());
            return this;
        }

        public Builder put(String setting, boolean value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, int value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, Version version) {
            this.put(setting, version.id);
            return this;
        }

        public Builder put(String setting, long value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, float value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, double value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value, TimeUnit timeUnit) {
            this.put(setting, timeUnit.toMillis(value) + "ms");
            return this;
        }

        public Builder put(String setting, long value, ByteSizeUnit sizeUnit) {
            this.put(setting, sizeUnit.toBytes(value) + "b");
            return this;
        }

        public Builder putArray(String setting, String ... values) {
            return this.putArray(setting, Arrays.asList(values));
        }

        public Builder putArray(String setting, List<String> values) {
            String value;
            this.remove(setting);
            int counter = 0;
            while ((value = this.map.remove(setting + '.' + counter++)) != null) {
            }
            for (int i = 0; i < values.size(); ++i) {
                this.put(setting + "." + i, values.get(i));
            }
            return this;
        }

        public Builder extendArray(String setting, String ... values) {
            String oldSingle = this.remove(setting);
            int counter = 0;
            while (this.map.containsKey(setting + '.' + counter)) {
                ++counter;
            }
            if (oldSingle != null) {
                this.put(setting + '.' + counter++, oldSingle);
            }
            for (String value : values) {
                this.put(setting + '.' + counter++, value);
            }
            return this;
        }

        public Builder put(String settingPrefix, String groupName, String[] settings, String[] values) throws SettingsException {
            if (settings.length != values.length) {
                throw new SettingsException("The settings length must match the value length");
            }
            for (int i = 0; i < settings.length; ++i) {
                if (values[i] == null) continue;
                this.put(settingPrefix + "." + groupName + "." + settings[i], values[i]);
            }
            return this;
        }

        public Builder put(Settings settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings.getAsMap());
            this.map.putAll(settings.getAsMap());
            return this;
        }

        public Builder put(Map<String, String> settings) {
            this.removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(settings);
            this.map.putAll(settings);
            return this;
        }

        private void removeNonArraysFieldsIfNewSettingsContainsFieldAsArray(Map<String, String> settings) {
            ArrayList<String> prefixesToRemove = new ArrayList<String>();
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                Matcher matcher = ARRAY_PATTERN.matcher(entry.getKey());
                if (matcher.matches()) {
                    prefixesToRemove.add(matcher.group(1));
                    continue;
                }
                if (!this.map.keySet().stream().anyMatch(key -> key.startsWith((String)entry.getKey() + "."))) continue;
                prefixesToRemove.add(entry.getKey());
            }
            for (String prefix : prefixesToRemove) {
                Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    if (!entry.getKey().startsWith(prefix + ".") && !entry.getKey().equals(prefix)) continue;
                    iterator.remove();
                }
            }
        }

        public Builder put(Dictionary<Object, Object> properties) {
            for (Object key : Collections.list(properties.keys())) {
                this.map.put(Objects.toString(key), Objects.toString(properties.get(key)));
            }
            return this;
        }

        public Builder loadFromSource(String source) {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromSource(source);
            try {
                Map<String, String> loadedSettings = settingsLoader.load(source);
                this.put(loadedSettings);
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]", e);
            }
            return this;
        }

        public Builder loadFromPath(Path path) throws IOException {
            return this.loadFromStream(path.getFileName().toString(), Files.newInputStream(path, new OpenOption[0]));
        }

        public Builder loadFromStream(String resourceName, InputStream is) throws IOException {
            SettingsLoader settingsLoader = SettingsLoaderFactory.loaderFromResource(resourceName);
            Map<String, String> loadedSettings = settingsLoader.load(Streams.copyToString(new InputStreamReader(is, StandardCharsets.UTF_8)));
            this.put(loadedSettings);
            return this;
        }

        public Builder putProperties(Map<String, String> esSettings, Predicate<String> keyPredicate, Function<String, String> keyFunction) {
            for (Map.Entry<String, String> esSetting : esSettings.entrySet()) {
                String key = esSetting.getKey();
                if (!keyPredicate.test(key)) continue;
                this.map.put(keyFunction.apply(key), esSetting.getValue());
            }
            return this;
        }

        public Builder replacePropertyPlaceholders() {
            return this.replacePropertyPlaceholders(System::getenv);
        }

        Builder replacePropertyPlaceholders(final Function<String, String> getenv) {
            PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder("${", "}", false);
            PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    String value = (String)getenv.apply(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    return (String)map.get(placeholderName);
                }

                @Override
                public boolean shouldIgnoreMissing(String placeholderName) {
                    return placeholderName.startsWith("prompt.");
                }

                @Override
                public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                    return !placeholderName.startsWith("prompt.");
                }
            };
            Iterator<Map.Entry<String, String>> entryItr = this.map.entrySet().iterator();
            while (entryItr.hasNext()) {
                Map.Entry<String, String> entry = entryItr.next();
                if (entry.getValue() == null) continue;
                String value = propertyPlaceholder.replacePlaceholders(entry.getValue(), placeholderResolver);
                if (Strings.hasLength(value)) {
                    entry.setValue(value);
                    continue;
                }
                entryItr.remove();
            }
            return this;
        }

        public Builder normalizePrefix(String prefix) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().startsWith(prefix)) continue;
                replacements.put(prefix + entry.getKey(), entry.getValue());
                iterator.remove();
            }
            this.map.putAll(replacements);
            return this;
        }

        public Settings build() {
            return new Settings(Collections.unmodifiableMap(this.map));
        }
    }
}

