/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginInfo;
import org.elasticsearch.threadpool.ExecutorBuilder;

public class PluginsService
extends AbstractComponent {
    private final List<Tuple<PluginInfo, Plugin>> plugins;
    private final PluginsAndModules info;
    public static final Setting<List<String>> MANDATORY_SETTING = Setting.listSetting("plugin.mandatory", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);

    public List<Setting<?>> getPluginSettings() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettings().stream()).collect(Collectors.toList());
    }

    public List<String> getPluginSettingsFilter() {
        return this.plugins.stream().flatMap(p -> ((Plugin)p.v2()).getSettingsFilter().stream()).collect(Collectors.toList());
    }

    public PluginsService(Settings settings, Path modulesDirectory, Path pluginsDirectory, Collection<Class<? extends Plugin>> classpathPlugins) {
        super(settings);
        Object loaded;
        List<Bundle> bundles;
        ArrayList<Tuple<PluginInfo, Plugin>> pluginsLoaded = new ArrayList<Tuple<PluginInfo, Plugin>>();
        ArrayList<PluginInfo> pluginsList = new ArrayList<PluginInfo>();
        for (Class<? extends Plugin> pluginClass : classpathPlugins) {
            Plugin plugin = this.loadPlugin(pluginClass, settings);
            PluginInfo pluginInfo = new PluginInfo(pluginClass.getName(), "classpath plugin", "NA", pluginClass.getName());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("plugin loaded from classpath [{}]", (Object)pluginInfo);
            }
            pluginsLoaded.add(new Tuple<PluginInfo, Plugin>(pluginInfo, plugin));
            pluginsList.add(pluginInfo);
        }
        ArrayList<PluginInfo> modulesList = new ArrayList<PluginInfo>();
        if (modulesDirectory != null) {
            try {
                bundles = PluginsService.getModuleBundles(modulesDirectory);
                loaded = this.loadBundles(bundles);
                pluginsLoaded.addAll((Collection<Tuple<PluginInfo, Plugin>>)loaded);
                Iterator<Tuple<PluginInfo, Plugin>> iterator = loaded.iterator();
                while (iterator.hasNext()) {
                    Tuple<PluginInfo, Plugin> module = iterator.next();
                    modulesList.add(module.v1());
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize modules", ex);
            }
        }
        if (pluginsDirectory != null) {
            try {
                bundles = PluginsService.getPluginBundles(pluginsDirectory);
                loaded = this.loadBundles(bundles);
                pluginsLoaded.addAll((Collection<Tuple<PluginInfo, Plugin>>)loaded);
                Iterator<Tuple<PluginInfo, Plugin>> iterator = loaded.iterator();
                while (iterator.hasNext()) {
                    Tuple<PluginInfo, Plugin> plugin = iterator.next();
                    pluginsList.add(plugin.v1());
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize plugins", ex);
            }
        }
        this.info = new PluginsAndModules(pluginsList, modulesList);
        this.plugins = Collections.unmodifiableList(pluginsLoaded);
        HashSet<String> pluginsNames = new HashSet<String>();
        for (Tuple tuple : this.plugins) {
            pluginsNames.add(((PluginInfo)tuple.v1()).getName());
        }
        List<String> mandatoryPlugins = MANDATORY_SETTING.get(settings);
        if (!mandatoryPlugins.isEmpty()) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String mandatoryPlugin : mandatoryPlugins) {
                if (pluginsNames.contains(mandatoryPlugin) || hashSet.contains(mandatoryPlugin)) continue;
                hashSet.add(mandatoryPlugin);
            }
            if (!hashSet.isEmpty()) {
                throw new ElasticsearchException("Missing mandatory plugins [" + Strings.collectionToDelimitedString(hashSet, ", ") + "]", new Object[0]);
            }
        }
        PluginsService.logPluginInfo(this.info.getModuleInfos(), "module", this.logger);
        PluginsService.logPluginInfo(this.info.getPluginInfos(), "plugin", this.logger);
    }

    private static void logPluginInfo(List<PluginInfo> pluginInfos, String type, Logger logger) {
        assert (pluginInfos != null);
        if (pluginInfos.isEmpty()) {
            logger.info("no " + type + "s loaded");
        } else {
            for (String name : pluginInfos.stream().map(PluginInfo::getName).sorted().collect(Collectors.toList())) {
                logger.info("loaded " + type + " [" + name + "]");
            }
        }
    }

    public Settings updatedSettings() {
        HashMap<String, String> foundSettings = new HashMap<String, String>();
        Settings.Builder builder = Settings.builder();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            Settings settings = plugin.v2().additionalSettings();
            for (String setting : settings.getAsMap().keySet()) {
                String oldPlugin = foundSettings.put(setting, plugin.v1().getName());
                if (oldPlugin == null) continue;
                throw new IllegalArgumentException("Cannot have additional setting [" + setting + "] in plugin [" + plugin.v1().getName() + "], already added in plugin [" + oldPlugin + "]");
            }
            builder.put(settings);
        }
        return builder.put(this.settings).build();
    }

    public Collection<Module> createGuiceModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            modules.addAll(plugin.v2().createGuiceModules());
        }
        return modules;
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        ArrayList builders = new ArrayList();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            builders.addAll(plugin.v2().getExecutorBuilders(settings));
        }
        return builders;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>();
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            services.addAll(plugin.v2().getGuiceServiceClasses());
        }
        return services;
    }

    public void onIndexModule(IndexModule indexModule) {
        for (Tuple<PluginInfo, Plugin> plugin : this.plugins) {
            plugin.v2().onIndexModule(indexModule);
        }
    }

    public PluginsAndModules info() {
        return this.info;
    }

    static List<Bundle> getModuleBundles(Path modulesDirectory) throws IOException {
        if (Files.notExists(modulesDirectory, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(modulesDirectory);){
            for (Path module : stream) {
                if (FileSystemUtils.isHidden(module)) continue;
                PluginInfo info = PluginInfo.readFromProperties(module);
                Bundle bundle = new Bundle();
                bundle.plugins.add(info);
                try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(module, "*.jar");){
                    for (Path jar : jarStream) {
                        bundle.urls.add(jar.toRealPath(new LinkOption[0]).toUri().toURL());
                    }
                }
                bundles.add(bundle);
            }
        }
        return bundles;
    }

    static List<Bundle> getPluginBundles(Path pluginsDirectory) throws IOException {
        Logger logger = Loggers.getLogger(PluginsService.class);
        if (!FileSystemUtils.isAccessibleDirectory(pluginsDirectory, logger)) {
            return Collections.emptyList();
        }
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(pluginsDirectory);){
            for (Path plugin : stream) {
                PluginInfo info;
                if (FileSystemUtils.isHidden(plugin)) {
                    logger.trace("--- skip hidden plugin file[{}]", (Object)plugin.toAbsolutePath());
                    continue;
                }
                logger.trace("--- adding plugin [{}]", (Object)plugin.toAbsolutePath());
                try {
                    info = PluginInfo.readFromProperties(plugin);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not load plugin descriptor for existing plugin [" + plugin.getFileName() + "]. Was the plugin built before 2.0?", e);
                }
                ArrayList<URL> urls = new ArrayList<URL>();
                try (DirectoryStream<Path> jarStream = Files.newDirectoryStream(plugin, "*.jar");){
                    for (Path jar : jarStream) {
                        urls.add(jar.toRealPath(new LinkOption[0]).toUri().toURL());
                    }
                }
                Bundle bundle = new Bundle();
                bundles.add(bundle);
                bundle.plugins.add(info);
                bundle.urls.addAll(urls);
            }
        }
        return bundles;
    }

    private List<Tuple<PluginInfo, Plugin>> loadBundles(List<Bundle> bundles) {
        ArrayList<Tuple<PluginInfo, Plugin>> plugins = new ArrayList<Tuple<PluginInfo, Plugin>>();
        for (Bundle bundle : bundles) {
            try {
                ArrayList<URL> jars = new ArrayList<URL>();
                jars.addAll(Arrays.asList(JarHell.parseClassPath()));
                jars.addAll(bundle.urls);
                JarHell.checkJarHell(jars.toArray(new URL[0]));
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to load bundle " + bundle.urls + " due to jar hell", e);
            }
            URLClassLoader loader = URLClassLoader.newInstance(bundle.urls.toArray(new URL[0]), this.getClass().getClassLoader());
            for (PluginInfo pluginInfo : bundle.plugins) {
                PluginsService.reloadLuceneSPI(loader);
                Class<? extends Plugin> pluginClass = this.loadPluginClass(pluginInfo.getClassname(), loader);
                Plugin plugin = this.loadPlugin(pluginClass, this.settings);
                plugins.add(new Tuple<PluginInfo, Plugin>(pluginInfo, plugin));
            }
        }
        return Collections.unmodifiableList(plugins);
    }

    static void reloadLuceneSPI(ClassLoader loader) {
        PostingsFormat.reloadPostingsFormats((ClassLoader)loader);
        DocValuesFormat.reloadDocValuesFormats((ClassLoader)loader);
        Codec.reloadCodecs((ClassLoader)loader);
        CharFilterFactory.reloadCharFilters((ClassLoader)loader);
        TokenFilterFactory.reloadTokenFilters((ClassLoader)loader);
        TokenizerFactory.reloadTokenizers((ClassLoader)loader);
    }

    private Class<? extends Plugin> loadPluginClass(String className, ClassLoader loader) {
        try {
            return loader.loadClass(className).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new ElasticsearchException("Could not find plugin class [" + className + "]", (Throwable)e, new Object[0]);
        }
    }

    private Plugin loadPlugin(Class<? extends Plugin> pluginClass, Settings settings) {
        try {
            try {
                return pluginClass.getConstructor(Settings.class).newInstance(settings);
            }
            catch (NoSuchMethodException e) {
                try {
                    return pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw new ElasticsearchException("No constructor for [" + pluginClass + "]. A plugin class must have either an empty default constructor or a single argument constructor accepting a Settings instance", new Object[0]);
                }
            }
        }
        catch (Exception e) {
            throw new ElasticsearchException("Failed to load plugin class [" + pluginClass.getName() + "]", (Throwable)e, new Object[0]);
        }
    }

    public <T> List<T> filterPlugins(Class<T> type) {
        return this.plugins.stream().filter(x -> type.isAssignableFrom(((Plugin)x.v2()).getClass())).map(p -> p.v2()).collect(Collectors.toList());
    }

    static class Bundle {
        List<PluginInfo> plugins = new ArrayList<PluginInfo>();
        List<URL> urls = new ArrayList<URL>();

        Bundle() {
        }
    }
}

