/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;

public class RestTypesExistsAction
extends BaseRestHandler {
    @Inject
    public RestTypesExistsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerWithDeprecatedHandler(RestRequest.Method.HEAD, "/{index}/_mapping/{type}", this, RestRequest.Method.HEAD, "/{index}/{type}", this.deprecationLogger);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        TypesExistsRequest typesExistsRequest = new TypesExistsRequest(Strings.splitStringByCommaToArray(request.param("index")), Strings.splitStringByCommaToArray(request.param("type")));
        typesExistsRequest.local(request.paramAsBoolean("local", typesExistsRequest.local()));
        typesExistsRequest.indicesOptions(IndicesOptions.fromRequest(request, typesExistsRequest.indicesOptions()));
        return channel -> client.admin().indices().typesExists(typesExistsRequest, (ActionListener<TypesExistsResponse>)new RestResponseListener<TypesExistsResponse>(channel){

            @Override
            public RestResponse buildResponse(TypesExistsResponse response) throws Exception {
                if (response.isExists()) {
                    return new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY);
                }
                return new BytesRestResponse(RestStatus.NOT_FOUND, "text/plain; charset=UTF-8", BytesArray.EMPTY);
            }
        });
    }
}

