/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseOptions;

public final class TcpTransportChannel<Channel>
implements TransportChannel {
    private final TcpTransport<Channel> transport;
    protected final Version version;
    protected final String action;
    protected final long requestId;
    private final String profileName;
    private final long reservedBytes;
    private final AtomicBoolean released = new AtomicBoolean();
    private final String channelType;
    private final Channel channel;
    private Exception releaseBy;

    public TcpTransportChannel(TcpTransport<Channel> transport, Channel channel, String channelType, String action, long requestId, Version version, String profileName, long reservedBytes) {
        this.version = version;
        this.channel = channel;
        this.transport = transport;
        this.action = action;
        this.requestId = requestId;
        this.profileName = profileName;
        this.reservedBytes = reservedBytes;
        this.channelType = channelType;
    }

    @Override
    public String getProfileName() {
        return this.profileName;
    }

    @Override
    public String action() {
        return this.action;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        this.sendResponse(response, TransportResponseOptions.EMPTY);
    }

    @Override
    public void sendResponse(TransportResponse response, TransportResponseOptions options) throws IOException {
        try {
            this.transport.sendResponse(this.version, this.channel, response, this.requestId, this.action, options);
        }
        finally {
            this.release(false);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.transport.sendErrorResponse(this.version, this.channel, exception, this.requestId, this.action);
        }
        finally {
            this.release(true);
        }
    }

    private void release(boolean isExceptionResponse) {
        if (this.released.compareAndSet(false, true)) {
            assert ((this.releaseBy = new Exception()) != null);
            this.transport.getInFlightRequestBreaker().addWithoutBreaking(-this.reservedBytes);
        } else if (!isExceptionResponse) {
            throw new IllegalStateException("reserved bytes are already released", this.releaseBy);
        }
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public String getChannelType() {
        return this.channelType;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

