/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.BytesRef;

public class OffsetsEnum
implements Comparable<OffsetsEnum>,
Closeable {
    private final BytesRef term;
    final PostingsEnum postingsEnum;
    float weight;
    private int pos = 0;

    public OffsetsEnum(BytesRef term, PostingsEnum postingsEnum) throws IOException {
        this.term = term;
        this.postingsEnum = Objects.requireNonNull(postingsEnum);
    }

    @Override
    public int compareTo(OffsetsEnum other) {
        try {
            int cmp = Integer.compare(this.startOffset(), other.startOffset());
            if (cmp != 0) {
                return cmp;
            }
            if (this.term == null || other.term == null) {
                if (this.term == null && other.term == null) {
                    return 0;
                }
                if (this.term == null) {
                    return 1;
                }
                return -1;
            }
            return this.term.compareTo(other.term);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    BytesRef getTerm() throws IOException {
        return this.term != null ? this.term : this.postingsEnum.getPayload();
    }

    boolean hasMorePositions() throws IOException {
        return this.pos < this.postingsEnum.freq();
    }

    void nextPosition() throws IOException {
        ++this.pos;
        this.postingsEnum.nextPosition();
    }

    int startOffset() throws IOException {
        return this.postingsEnum.startOffset();
    }

    int endOffset() throws IOException {
        return this.postingsEnum.endOffset();
    }

    @Override
    public void close() throws IOException {
        if (this.postingsEnum instanceof Closeable) {
            ((Closeable)this.postingsEnum).close();
        }
    }
}

