/*
 * Decompiled with CFR 0.152.
 */
package esmska;

import esmska.data.Config;
import esmska.utils.L10N;
import esmska.utils.LogSupport;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang.StringUtils;

public class CommandLineParser {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Options options = new Options();
    private static final Option help = new Option("h", "help", false, l10n.getString("CommandLineParser.show_this_help"));
    private static final Option portable = new Option("p", "portable", false, l10n.getString("CommandLineParser.enable_portable_mode"));
    private static final Option config;
    private static final Option version;
    private static final String debugDesc;
    private static final Option debug;
    private boolean isPortable;
    private String configPath;

    public boolean parseArgs(String[] args) {
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(options, args);
            List<Option> opts = Arrays.asList(cmd.getOptions());
            if (opts.contains(help)) {
                CommandLineParser.printUsage();
                System.exit(0);
            }
            if (opts.contains(portable)) {
                this.isPortable = true;
            }
            if (opts.contains(config)) {
                this.configPath = opts.get(opts.indexOf(config)).getValue();
            }
            if (opts.contains(version)) {
                System.out.println("Esmska " + Config.getLatestVersion());
                System.exit(0);
            }
            if (opts.contains(debug)) {
                String debugMode = opts.get(opts.indexOf(debug)).getValue();
                LogSupport.getConsoleHandler().setLevel(Level.ALL);
                if (StringUtils.equals(debugMode, "network")) {
                    LogSupport.enableHttpClientLogging();
                    LogSupport.getEsmskaLogger().setLevel(Level.INFO);
                }
                if (StringUtils.equals(debugMode, "full")) {
                    LogSupport.enableHttpClientLogging();
                    LogSupport.getEsmskaLogger().setLevel(Level.ALL);
                }
            }
        }
        catch (ParseException ex) {
            System.err.println(MessageFormat.format(l10n.getString("CommandLineParser.invalid_option"), ex.getMessage()));
            CommandLineParser.printUsage();
            return false;
        }
        return true;
    }

    public boolean isPortable() {
        return this.isPortable;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix(l10n.getString("CommandLineParser.usage") + " ");
        formatter.printHelp("java -jar esmska.jar [" + l10n.getString("CommandLineParser.options") + "]", "\n" + l10n.getString("CommandLineParser.available_options"), options, null);
    }

    static {
        OptionBuilder.withArgName(l10n.getString("CommandLineParser.path"));
        OptionBuilder.hasArg();
        OptionBuilder.withDescription(l10n.getString("CommandLineParser.set_user_path"));
        OptionBuilder.withLongOpt("config");
        config = OptionBuilder.create("c");
        version = new Option(null, "version", false, l10n.getString("CommandLineParser.version"));
        debugDesc = MessageFormat.format(l10n.getString("CommandLineParser.debug"), "standard", "network", "full");
        OptionBuilder.withArgName(l10n.getString("CommandLineParser.debugMode"));
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription(debugDesc);
        OptionBuilder.withLongOpt("debug");
        debug = OptionBuilder.create();
        OptionGroup configGroup = new OptionGroup();
        configGroup.addOption(portable);
        configGroup.addOption(config);
        options.addOption(help);
        options.addOptionGroup(configGroup);
        options.addOption(version);
        options.addOption(debug);
    }
}

