/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.attributes;

import org.apache.commons.lang.WordUtils;
import org.gradle.api.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute<T>
implements Named {
    private final String name;
    private final Class<T> type;

    public static <T> Attribute<T> of(String name, Class<T> type) {
        return new Attribute<T>(name, type);
    }

    public static <T> Attribute<T> of(Class<T> type) {
        return Attribute.of(WordUtils.uncapitalize((String)type.getSimpleName()), type);
    }

    private Attribute(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.name.equals(attribute.name)) {
            return false;
        }
        return this.type.equals(attribute.type);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.name;
    }
}

