/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.attributes.AttributeValue;
import org.gradle.api.attributes.MultipleCandidatesDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOrderedDisambiguationRule<T>
implements Action<MultipleCandidatesDetails<T>> {
    private final Comparator<? super T> comparator;
    private final boolean pickFirst;

    public DefaultOrderedDisambiguationRule(Comparator<? super T> comparator, boolean pickFirst) {
        this.comparator = comparator;
        this.pickFirst = pickFirst;
    }

    public void execute(MultipleCandidatesDetails<T> details) {
        Object cmp;
        Set<AttributeValue<T>> values = details.getCandidateValues();
        Object min = null;
        Object max = null;
        for (AttributeValue attributeValue : values) {
            if (!attributeValue.isPresent()) continue;
            Object v = attributeValue.get();
            if (min == null || this.comparator.compare(v, min) < 0) {
                min = v;
            }
            if (max != null && this.comparator.compare(v, max) <= 0) continue;
            max = v;
        }
        Object t = cmp = this.pickFirst ? min : max;
        if (cmp != null) {
            for (AttributeValue<T> value : details.getCandidateValues()) {
                if (!value.isPresent() || !value.get().equals(cmp)) continue;
                details.closestMatch(value);
            }
        }
    }
}

