/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileDetails;
import org.gradle.api.internal.changedetection.state.IgnoredPathFileSnapshot;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;

public class ClasspathSnapshotNormalizationStrategy
implements SnapshotNormalizationStrategy {
    public static final SnapshotNormalizationStrategy INSTANCE = new ClasspathSnapshotNormalizationStrategy();

    private ClasspathSnapshotNormalizationStrategy() {
    }

    public boolean isPathAbsolute() {
        return false;
    }

    public NormalizedFileSnapshot getNormalizedSnapshot(FileDetails fileDetails, IncrementalFileSnapshot snapshot, StringInterner stringInterner) {
        if (fileDetails.isRoot()) {
            return new IgnoredPathFileSnapshot(snapshot);
        }
        return TaskFilePropertySnapshotNormalizationStrategy.getRelativeSnapshot(fileDetails, snapshot, stringInterner);
    }

    public String toString() {
        return "CLASSPATH";
    }
}

