/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.hash.HashCode;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Nullable;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClassPathSnapshot;
import org.gradle.internal.classloader.ClassPathSnapshotter;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.HashingClassLoaderFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.Stoppable;

public class DefaultClassLoaderCache
implements ClassLoaderCache,
Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DefaultClassLoaderCache.class);
    private final Object lock = new Object();
    private final Map<ClassLoaderId, CachedClassLoader> byId = Maps.newHashMap();
    private final Map<ClassLoaderSpec, CachedClassLoader> bySpec = Maps.newHashMap();
    private final ClassPathSnapshotter snapshotter;
    private final HashingClassLoaderFactory classLoaderFactory;

    public DefaultClassLoaderCache(HashingClassLoaderFactory classLoaderFactory, ClassPathSnapshotter snapshotter) {
        this.classLoaderFactory = classLoaderFactory;
        this.snapshotter = snapshotter;
    }

    public ClassLoader get(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec) {
        return this.get(id, classPath, parent, filterSpec, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader get(ClassLoaderId id, ClassPath classPath, @Nullable ClassLoader parent, @Nullable FilteringClassLoader.Spec filterSpec, HashCode overrideHashCode) {
        ClassPathSnapshot classPathSnapshot = this.snapshotter.snapshot(classPath);
        ClassLoaderSpec spec = new ClassLoaderSpec(parent, classPathSnapshot, filterSpec, overrideHashCode);
        Object object = this.lock;
        synchronized (object) {
            CachedClassLoader cachedLoader = this.byId.get(id);
            if (cachedLoader == null || !cachedLoader.is(spec)) {
                CachedClassLoader newLoader = this.getAndRetainLoader(classPath, spec, id);
                this.byId.put(id, newLoader);
                if (cachedLoader != null) {
                    LOGGER.debug("Releasing previous classloader for {}", (Object)id);
                    cachedLoader.release(id);
                }
                return newLoader.classLoader;
            }
            return cachedLoader.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ClassLoaderId id) {
        Object object = this.lock;
        synchronized (object) {
            CachedClassLoader cachedClassLoader = this.byId.remove(id);
            if (cachedClassLoader != null) {
                cachedClassLoader.release(id);
            }
        }
    }

    private CachedClassLoader getAndRetainLoader(ClassPath classPath, ClassLoaderSpec spec, ClassLoaderId id) {
        CachedClassLoader cachedLoader = this.bySpec.get(spec);
        if (cachedLoader == null) {
            ClassLoader classLoader;
            CachedClassLoader parentCachedLoader = null;
            if (spec.isFiltered()) {
                parentCachedLoader = this.getAndRetainLoader(classPath, spec.unfiltered(), id);
                classLoader = this.classLoaderFactory.createFilteringClassLoader(parentCachedLoader.classLoader, spec.filterSpec);
            } else {
                classLoader = this.classLoaderFactory.createChildClassLoader(spec.parent, classPath, spec.overrideHashCode);
            }
            cachedLoader = new CachedClassLoader(classLoader, spec, parentCachedLoader);
            this.bySpec.put(spec, cachedLoader);
        }
        return cachedLoader.retain(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.bySpec.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            for (CachedClassLoader cachedClassLoader : this.byId.values()) {
                ClassLoaderUtils.tryClose((ClassLoader)cachedClassLoader.classLoader);
            }
            this.byId.clear();
            this.bySpec.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertInternalIntegrity() {
        Object object = this.lock;
        synchronized (object) {
            HashMap orphaned = Maps.newHashMap();
            for (Map.Entry<ClassLoaderId, CachedClassLoader> entry : this.byId.entrySet()) {
                if (this.bySpec.containsKey(entry.getValue().spec)) continue;
                orphaned.put(entry.getKey(), entry.getValue());
            }
            if (!orphaned.isEmpty()) {
                throw new IllegalStateException("The following class loaders are orphaned: " + Joiner.on((String)",").withKeyValueSeparator(":").join((Map)orphaned));
            }
        }
    }

    private class CachedClassLoader {
        private final ClassLoader classLoader;
        private final ClassLoaderSpec spec;
        private final CachedClassLoader parent;
        private final Multiset<ClassLoaderId> usedBy = HashMultiset.create();

        private CachedClassLoader(ClassLoader classLoader, @Nullable ClassLoaderSpec spec, CachedClassLoader parent) {
            this.classLoader = classLoader;
            this.spec = spec;
            this.parent = parent;
        }

        public boolean is(ClassLoaderSpec spec) {
            return this.spec.equals(spec);
        }

        public CachedClassLoader retain(ClassLoaderId loaderId) {
            this.usedBy.add((Object)loaderId);
            return this;
        }

        public void release(ClassLoaderId loaderId) {
            if (this.usedBy.isEmpty()) {
                throw new IllegalStateException("Cannot release already released classloader: " + this.classLoader);
            }
            if (this.usedBy.remove((Object)loaderId)) {
                if (this.usedBy.isEmpty()) {
                    if (this.parent != null) {
                        this.parent.release(loaderId);
                    }
                    DefaultClassLoaderCache.this.bySpec.remove(this.spec);
                }
            } else {
                throw new IllegalStateException("Classloader '" + this + "' not used by '" + loaderId + "'");
            }
        }
    }

    private static class ClassLoaderSpec {
        private final ClassLoader parent;
        private final ClassPathSnapshot classPathSnapshot;
        private final FilteringClassLoader.Spec filterSpec;
        private final HashCode overrideHashCode;

        public ClassLoaderSpec(ClassLoader parent, ClassPathSnapshot classPathSnapshot, FilteringClassLoader.Spec filterSpec, HashCode overrideHashCode) {
            this.parent = parent;
            this.classPathSnapshot = classPathSnapshot;
            this.filterSpec = filterSpec;
            this.overrideHashCode = overrideHashCode;
        }

        public ClassLoaderSpec unfiltered() {
            return new ClassLoaderSpec(this.parent, this.classPathSnapshot, null, this.overrideHashCode);
        }

        public boolean isFiltered() {
            return this.filterSpec != null;
        }

        public boolean equals(Object o) {
            ClassLoaderSpec that = (ClassLoaderSpec)o;
            return Objects.equal((Object)this.parent, (Object)that.parent) && this.classPathSnapshot.equals((Object)that.classPathSnapshot) && Objects.equal((Object)this.filterSpec, (Object)that.filterSpec) && Objects.equal((Object)this.overrideHashCode, (Object)that.overrideHashCode);
        }

        public int hashCode() {
            int result = this.classPathSnapshot.hashCode();
            result = 31 * result + (this.filterSpec != null ? this.filterSpec.hashCode() : 0);
            result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
            result = 31 * result + (this.overrideHashCode != null ? this.overrideHashCode.hashCode() : 0);
            return result;
        }
    }
}

