/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.loadercache;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.hash.FileHasher;
import org.gradle.internal.FileUtils;
import org.gradle.internal.classloader.ClassPathSnapshot;
import org.gradle.internal.classloader.ClassPathSnapshotter;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashClassPathSnapshotter
implements ClassPathSnapshotter {
    private final FileHasher hasher;

    public HashClassPathSnapshotter(FileHasher hasher) {
        this.hasher = hasher;
    }

    public ClassPathSnapshot snapshot(ClassPath classPath) {
        LinkedList visitedFilePaths = Lists.newLinkedList();
        LinkedHashSet visitedDirs = Sets.newLinkedHashSet();
        List cpFiles = classPath.getAsFiles();
        Hasher checksum = Hashing.md5().newHasher();
        this.hash(checksum, visitedFilePaths, visitedDirs, cpFiles.iterator());
        return new HashClassPathSnapshot(visitedFilePaths, checksum.hash());
    }

    private void hash(Hasher combinedHash, List<String> visitedFilePaths, Set<File> visitedDirs, Iterator<File> toHash) {
        while (toHash.hasNext()) {
            File file = FileUtils.canonicalize((File)toHash.next());
            if (file.isDirectory()) {
                if (!visitedDirs.add(file)) continue;
                Object[] sortedFiles = file.listFiles();
                Arrays.sort(sortedFiles);
                this.hash(combinedHash, visitedFilePaths, visitedDirs, (Iterator<File>)Iterators.forArray((Object[])sortedFiles));
                continue;
            }
            if (!file.isFile()) continue;
            visitedFilePaths.add(file.getAbsolutePath());
            combinedHash.putBytes(this.hasher.hash(file).asBytes());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HashClassPathSnapshot
    implements ClassPathSnapshot {
        private final List<String> files;
        private final HashCode hash;

        public HashClassPathSnapshot(List<String> files, HashCode hash) {
            assert (files != null);
            this.files = files;
            this.hash = hash;
        }

        public HashCode getStrongHash() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashClassPathSnapshot that = (HashClassPathSnapshot)o;
            return this.hash.equals((Object)that.hash) && this.files.equals(that.files);
        }

        public int hashCode() {
            int result = this.files.hashCode();
            result = 31 * result + this.hash.hashCode();
            return result;
        }
    }
}

