/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import java.util.ArrayList;
import org.gradle.api.GradleException;
import org.gradle.api.execution.TaskActionListener;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskOutputsGenerationListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.StopActionException;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskExecutionException;

public class ExecuteActionsTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(ExecuteActionsTaskExecuter.class);
    private final TaskOutputsGenerationListener outputsGenerationListener;
    private final TaskActionListener listener;

    public ExecuteActionsTaskExecuter(TaskOutputsGenerationListener outputsGenerationListener, TaskActionListener taskActionListener) {
        this.outputsGenerationListener = outputsGenerationListener;
        this.listener = taskActionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        this.listener.beforeActions(task);
        if (!task.getTaskActions().isEmpty()) {
            this.outputsGenerationListener.beforeTaskOutputsGenerated();
        }
        state.setExecuting(true);
        try {
            GradleException failure = this.executeActions(task, state, context);
            if (failure != null) {
                state.setOutcome(failure);
            } else {
                state.setOutcome(state.getDidWork() ? TaskExecutionOutcome.EXECUTED : TaskExecutionOutcome.UP_TO_DATE);
            }
        }
        finally {
            state.setExecuting(false);
            this.listener.afterActions(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GradleException executeActions(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        LOGGER.debug("Executing actions for {}.", (Object)task);
        ArrayList<ContextAwareTaskAction> actions = new ArrayList<ContextAwareTaskAction>(task.getTaskActions());
        for (ContextAwareTaskAction action : actions) {
            state.setDidWork(true);
            task.getStandardOutputCapture().start();
            try {
                this.executeAction(task, action, context);
            }
            catch (StopActionException e) {
                LOGGER.debug("Action stopped by some action with message: {}", (Object)e.getMessage());
            }
            catch (StopExecutionException e) {
                LOGGER.info("Execution stopped by some action with message: {}", (Object)e.getMessage());
                break;
            }
            catch (Throwable t) {
                TaskExecutionException taskExecutionException = new TaskExecutionException(task, t);
                return taskExecutionException;
            }
            finally {
                task.getStandardOutputCapture().stop();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(TaskInternal task, ContextAwareTaskAction action, TaskExecutionContext context) {
        action.contextualise(context);
        try {
            action.execute(task);
        }
        finally {
            action.contextualise(null);
        }
    }
}

